/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.project;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectDependencyTracker {
    public static final String POINT = "org.eclipse.m2m.qvt.oml.runtime.qvtProjectDependencyTracker";

    public static Set<IProject> getAllReferencedProjects(IProject project, boolean recursive) {
        IConfigurationElement[] providers = Platform.getExtensionRegistry().getConfigurationElementsFor(POINT);
        HashSet<IProject> referencedProjects = new HashSet<IProject>(providers.length);
        IConfigurationElement[] iConfigurationElementArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement provider = iConfigurationElementArray[n2];
            try {
                Object extension = provider.createExecutableExtension("class");
                if (extension instanceof ProjectDependencyTracker) {
                    ProjectDependencyTracker tracker = (ProjectDependencyTracker)extension;
                    referencedProjects.addAll(tracker.getReferencedProjects(project, recursive));
                }
            }
            catch (CoreException e) {
                QvtPlugin.logDiagnostic((Diagnostic)BasicDiagnostic.toDiagnostic((IStatus)e.getStatus()));
            }
            ++n2;
        }
        return referencedProjects;
    }

    public abstract Set<IProject> getReferencedProjects(IProject var1, boolean var2);
}

