/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtEnvironmentBase;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.common.project.Pair;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictionaryType;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeOCLFactory;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeOCLPackage;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ListType;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.Typedef;
import org.eclipse.ocl.AbstractTypeResolver;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.AnyType;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BasicTypeResolverImpl
extends AbstractTypeResolver<EPackage, EClassifier, EOperation, EStructuralFeature, EParameter> {
    private final Map<Pair<CollectionKind, EClassifier>, org.eclipse.ocl.types.CollectionType<EClassifier, EOperation>> fCollectionTypes = new HashMap<Pair<CollectionKind, EClassifier>, org.eclipse.ocl.types.CollectionType<EClassifier, EOperation>>();

    BasicTypeResolverImpl(QvtEnvironmentBase env, Resource resource) {
        super((Environment)env, resource);
    }

    public EClassifier resolve(EClassifier type) {
        if (type instanceof ListType) {
            return this.resolveListType((EClassifier)((ListType)type).getElementType());
        }
        if (type instanceof DictionaryType) {
            DictionaryType dictType = (DictionaryType)type;
            return this.resolveDictionaryType(dictType.getKeyType(), (EClassifier)dictType.getElementType());
        }
        return (EClassifier)super.resolve((Object)type);
    }

    public ListType resolveListType(EClassifier elementType) {
        ListType listType = this.findListType(elementType);
        if (listType == null) {
            ListType newList = QvtOperationalStdLibrary.INSTANCE.getStdlibFactory().createList(elementType);
            ((EPackage)this.getCollectionPackage()).getEClassifiers().add((Object)newList);
            return newList;
        }
        return listType;
    }

    public DictionaryType resolveDictionaryType(EClassifier keyType, EClassifier elementType) {
        DictionaryType dictionaryType = this.findDictionaryType(keyType, elementType);
        if (dictionaryType == null) {
            DictionaryType newDictionary = QvtOperationalStdLibrary.INSTANCE.getStdlibFactory().createDictionary(keyType, elementType);
            ((EPackage)this.getCollectionPackage()).getEClassifiers().add((Object)newDictionary);
            return newDictionary;
        }
        return dictionaryType;
    }

    private ListType findListType(EClassifier elementType) {
        for (EClassifier next : this.getEnvironment().getUMLReflection().getClassifiers((Object)((EPackage)this.getCollectionPackage()))) {
            ListType type;
            if (!(next instanceof ListType) || !this.exactCollectionTypeMatch((EClassifier)(type = (ListType)next).getElementType(), elementType)) continue;
            return type;
        }
        return null;
    }

    private DictionaryType findDictionaryType(EClassifier keyType, EClassifier valueType) {
        for (EClassifier next : this.getEnvironment().getUMLReflection().getClassifiers((Object)((EPackage)this.getCollectionPackage()))) {
            DictionaryType type;
            if (!(next instanceof DictionaryType) || !this.exactCollectionTypeMatch((type = (DictionaryType)next).getKeyType(), keyType) || !this.exactCollectionTypeMatch((EClassifier)type.getElementType(), valueType)) continue;
            return type;
        }
        return null;
    }

    protected org.eclipse.ocl.types.CollectionType<EClassifier, EOperation> findCollectionType(CollectionKind kind, EClassifier elementType) {
        Pair key = new Pair((Object)kind, (Object)elementType);
        org.eclipse.ocl.types.CollectionType<EClassifier, EOperation> collectionType = this.fCollectionTypes.get(key);
        if (collectionType != null) {
            return collectionType;
        }
        for (EClassifier next : this.getEnvironment().getUMLReflection().getClassifiers((Object)((EPackage)this.getCollectionPackage()))) {
            org.eclipse.ocl.types.CollectionType type;
            if (!(next instanceof org.eclipse.ocl.types.CollectionType) || next.eClass() == ImperativeOCLPackage.eINSTANCE.getDictionaryType() || next.eClass() == ImperativeOCLPackage.eINSTANCE.getListType() || (type = (org.eclipse.ocl.types.CollectionType)next).getKind() != kind || !this.exactCollectionTypeMatch((EClassifier)type.getElementType(), elementType)) continue;
            this.fCollectionTypes.put((Pair<CollectionKind, EClassifier>)key, (org.eclipse.ocl.types.CollectionType<EClassifier, EOperation>)type);
            return type;
        }
        return null;
    }

    private boolean exactCollectionTypeMatch(EClassifier type1, EClassifier type2) {
        if (TypeUtil.exactTypeMatch((Environment)this.getEnvironment(), (Object)type1, (Object)type2)) {
            if (type1 instanceof AnyType && type2 instanceof AnyType) {
                if (((AnyType)type1).getName().equals(((AnyType)type2).getName())) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected Resource createResource() {
        return new EcoreResourceFactoryImpl().createResource(URI.createURI((String)"ocl:///qvto.env.ecore"));
    }

    protected EPackage createTuplePackage() {
        EPackage result = (EPackage)super.createTuplePackage();
        return result;
    }

    protected EPackage createPackage(String name) {
        QvtEnvironmentBase env = (QvtEnvironmentBase)this.getEnvironment();
        Module module = env.getModuleContextType();
        if (module != null) {
            return module;
        }
        EPackage result = EcoreFactory.eINSTANCE.createEPackage();
        result.setName(name);
        this.getResource().getContents().add((Object)result);
        return result;
    }

    protected EPackage findPackage(String name) {
        EPackage result = null;
        for (EObject o : this.getResource().getContents()) {
            EPackage epkg;
            if (!(o instanceof EPackage) || !name.equals((epkg = (EPackage)o).getName()) || epkg instanceof Module) continue;
            result = epkg;
            break;
        }
        return result;
    }

    protected void addClassifier(EPackage pkg, EClassifier classifier) {
        pkg.getEClassifiers().add((Object)classifier);
    }

    protected void addOperation(EClassifier owner, EOperation operation) {
        ((EClass)owner).getEOperations().add((Object)operation);
    }

    protected void addProperty(EClassifier owner, EStructuralFeature property) {
        ((EClass)owner).getEStructuralFeatures().add((Object)property);
    }

    List<EOperation> getAllCompatibleAdditionalOperations(CollectionType type) {
        if (this.hasAdditionalFeatures()) {
            UMLReflection uml = this.getEnvironment().getUMLReflection();
            EClassifier eClassifier = ShadowClassAdapter.getShadowToBaseMap((EPackage)this.getAdditionalFeaturesPackage()).get(type);
            return uml.getOperations((Object)eClassifier);
        }
        return ECollections.emptyEList();
    }

    protected EClass createShadowClass(EClassifier type) {
        Typedef typeDef = ImperativeOCLFactory.eINSTANCE.createTypedef();
        typeDef.setName(type.getName());
        typeDef.setBase(type);
        EPackage pkg = (EPackage)this.getAdditionalFeaturesPackage();
        ShadowClassAdapter.getShadowToBaseMap(pkg).put(type, (EClassifier)typeDef);
        return typeDef;
    }

    protected EClassifier getShadowedClassifier(EClassifier shadow) {
        if (shadow instanceof Typedef) {
            Typedef typedef = (Typedef)shadow;
            return typedef.getBase();
        }
        return null;
    }

    protected EClassifier findShadowClass(EClassifier type) {
        if (!this.hasAdditionalFeatures()) {
            return null;
        }
        EPackage pkg = (EPackage)this.getAdditionalFeaturesPackage();
        if (type instanceof TupleType) {
            for (EClassifier shadowedClassifier : ShadowClassAdapter.getShadowToBaseMap(pkg).keySet()) {
                if (!TypeUtil.exactTypeMatch((Environment)this.getEnvironment(), (Object)type, (Object)shadowedClassifier)) continue;
                return ShadowClassAdapter.getShadowToBaseMap(pkg).get(shadowedClassifier);
            }
        }
        return ShadowClassAdapter.getShadowToBaseMap(pkg).get(type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShadowClassAdapter
    extends AdapterImpl {
        final Map<EClassifier, EClassifier> fShadowToBase = new LinkedHashMap<EClassifier, EClassifier>();

        private ShadowClassAdapter() {
        }

        Map<EClassifier, EClassifier> getShadowToBaseMap() {
            return this.fShadowToBase;
        }

        public boolean isAdapterForType(Object type) {
            if (ShadowClassAdapter.class.equals(type)) {
                return true;
            }
            return super.isAdapterForType(type);
        }

        public static Map<EClassifier, EClassifier> getShadowToBaseMap(EPackage pkg) {
            Adapter adapter = EcoreUtil.getAdapter((List)pkg.eAdapters(), ShadowClassAdapter.class);
            if (adapter instanceof ShadowClassAdapter) {
                return ((ShadowClassAdapter)adapter).getShadowToBaseMap();
            }
            ShadowClassAdapter shadowClassAdapter = new ShadowClassAdapter();
            pkg.eAdapters().add((Object)shadowClassAdapter);
            return shadowClassAdapter.getShadowToBaseMap();
        }
    }
}

