/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.io.eclipse;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFolder;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.AbstractBundleResource;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.BundleFolder;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.BundleModuleRegistry;

public class BundleFile
extends AbstractBundleResource
implements CFile {
    private URL resourceURL;
    private String unitName;

    public BundleFile(IPath resourcePath, BundleModuleRegistry bundleRegistry) {
        super(resourcePath, bundleRegistry);
        this.resourceURL = Platform.getBundle((String)bundleRegistry.getBundleSymbolicName()).getResource(resourcePath.toString());
        this.unitName = resourcePath.removeFileExtension().lastSegment();
    }

    public InputStream getContents() throws IOException {
        if (this.resourceURL != null) {
            return this.resourceURL.openStream();
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    public String getUnitName() {
        return this.unitName;
    }

    public String getCharset() throws IOException {
        return ResourcesPlugin.getEncoding();
    }

    public CFolder getParent() {
        if (this.resourcePath.segmentCount() > 1) {
            IPath parentPath = this.resourcePath.removeLastSegments(1);
            return new BundleFolder(parentPath, this.resourceRegistry);
        }
        return null;
    }

    public boolean exists() {
        return this.resourceURL != null;
    }
}

