/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.project;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.MetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerMessages;
import org.eclipse.m2m.internal.qvt.oml.compiler.QVTOCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtModule;
import org.eclipse.osgi.util.NLS;

public class DeployedQvtModule
extends QvtModule {
    private Module myModule;
    private CompiledUnit myUnit;
    private ResourceSet myResourceSet;
    private URI moduleID;

    public DeployedQvtModule(URI qvtModuleID) throws MdaException {
        if (qvtModuleID == null || qvtModuleID.segmentCount() == 0) {
            throw new MdaException(NLS.bind((String)Messages.TransformationUtil_InvalidUri, (Object)(qvtModuleID == null ? String.valueOf(null) : qvtModuleID.toString())));
        }
        this.moduleID = qvtModuleID;
    }

    protected IMetamodelRegistryProvider creatMetamodelRegistryProvider() {
        return new MetamodelRegistryProvider();
    }

    public Module getModule() throws MdaException {
        if (this.myModule == null) {
            UnitProxy srcUnit = UnitResolverFactory.Registry.INSTANCE.getUnit(this.moduleID);
            if (srcUnit == null) {
                throw new MdaException(NLS.bind((String)CompilerMessages.importedModuleNotFound, (Object)this.moduleID));
            }
            QVTOCompiler qvtCompiler = new QVTOCompiler(srcUnit.getResolver(), this.creatMetamodelRegistryProvider());
            QvtCompilerOptions options = this.getQvtCompilerOptions();
            if (options == null) {
                options = new QvtCompilerOptions();
                options.setGenerateCompletionData(false);
            }
            this.myUnit = qvtCompiler.compile(srcUnit, options, null);
            if (!options.isModuleWithErrorAllowed()) {
                this.checkModuleErrors(this.myUnit);
            }
            this.myModule = (Module)this.myUnit.getModules().get(0);
            this.myResourceSet = qvtCompiler.getResourceSet();
        }
        return this.myModule;
    }

    public ResourceSet getResourceSet() throws MdaException {
        this.getModule();
        return this.myResourceSet;
    }

    public void cleanup() {
        if (this.myResourceSet != null) {
            EmfUtil.cleanupResourceSet((ResourceSet)this.myResourceSet);
        }
    }

    public CompiledUnit getUnit() throws MdaException {
        this.getModule();
        return this.myUnit;
    }

    public String toString() {
        return "deployed:/" + this.moduleID;
    }
}

