/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.IModuleSourceInfo;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTOTypeResolver;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ExecutableXMIHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.compiler.ExeXMIResource;
import org.eclipse.m2m.internal.qvt.oml.cst.CSTFactory;
import org.eclipse.m2m.internal.qvt.oml.cst.UnitCS;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.utilities.ASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompiledUnit {
    private List<String> fQname;
    private URI fUri;
    private List<QvtMessage> fAllProblems;
    private List<CompiledUnit> fImports;
    private List<QvtOperationalModuleEnv> moduleEnvs;
    UnitCS fUnitCST;

    CompiledUnit(List<String> qualifiedName, URI uri, List<? extends QvtOperationalModuleEnv> modules) {
        if (qualifiedName == null || modules == null || uri == null) {
            throw new IllegalArgumentException();
        }
        this.fUri = uri;
        this.fQname = qualifiedName;
        this.moduleEnvs = new ArrayList<QvtOperationalModuleEnv>(modules);
        ArrayList<QvtMessage> problems = new ArrayList<QvtMessage>();
        this.fAllProblems = problems;
        for (QvtOperationalModuleEnv qvtOperationalModuleEnv : modules) {
            this.fAllProblems.addAll(qvtOperationalModuleEnv.getAllProblemMessages());
        }
        if (!problems.isEmpty()) {
            problems.trimToSize();
        }
    }

    public static ResourceSetImpl createResourceSet() {
        return CompiledUnit.createResourceSet(null);
    }

    static ResourceSetImpl createResourceSet(EPackage.Registry registry) {
        ResourceSetImpl rs = new ResourceSetImpl(){

            protected void demandLoad(Resource resource) throws IOException {
                super.demandLoad(resource);
                if ("qvtox".equals(resource.getURI().fileExtension())) {
                    ExecutableXMIHelper.fixResourceOnLoad(resource);
                }
            }
        };
        if (registry != null) {
            rs.setPackageRegistry(registry);
        }
        return rs;
    }

    public CompiledUnit(URI xmiURI, ResourceSet resourceSet) {
        this(resourceSet.getResource(xmiURI, true), new HashMap<URI, CompiledUnit>());
    }

    CompiledUnit(Resource unitXMIResource, Map<URI, CompiledUnit> unitMap) {
        this.fUri = unitXMIResource.getURI();
        this.moduleEnvs = new LinkedList<QvtOperationalModuleEnv>();
        this.fAllProblems = new ArrayList<QvtMessage>();
        this.fImports = new UniqueEList();
        unitMap.put(this.fUri, this);
        this.computeImports(unitXMIResource, unitMap);
        for (EObject rootElement : new ArrayList(unitXMIResource.getContents())) {
            if (!(rootElement instanceof Module)) continue;
            Module nextModule = (Module)rootElement;
            QvtOperationalModuleEnv nextModuleEnv = QvtOperationalEnvFactory.INSTANCE.createModuleEnvironment(nextModule);
            QVTOTypeResolver typeResolver = nextModuleEnv.getTypeResolver();
            ASTBindingHelper.createCST2ASTBinding((CSTNode)CSTFactory.eINSTANCE.createLibraryCS(), nextModule, nextModuleEnv);
            for (EOperation nextOper : nextModule.getEOperations()) {
                ImperativeOperation imperativeOper;
                EClassifier ctxType;
                if (!(nextOper instanceof ImperativeOperation) || (ctxType = QvtOperationalParserUtil.getContextualType(imperativeOper = (ImperativeOperation)nextOper)) == null) continue;
                typeResolver.resolveAdditionalOperation(ctxType, imperativeOper);
            }
            this.moduleEnvs.add(nextModuleEnv);
        }
    }

    private void validate(Resource res, List<QvtMessage> problems) {
        BasicDiagnostic diagnostics = new BasicDiagnostic();
        IModuleSourceInfo sourceInfo = null;
        if (res instanceof ExeXMIResource) {
            sourceInfo = ((ExeXMIResource)res).getSourceInfo();
        }
        Diagnostician diagnostician = new Diagnostician();
        HashMap<Class<Environment>, QvtOperationalEnv> context = new HashMap<Class<Environment>, QvtOperationalEnv>();
        context.put(Environment.class, new QvtOperationalEnvFactory().createEnvironment());
        for (EObject root : res.getContents()) {
            diagnostician.validate(root, (DiagnosticChain)diagnostics, context);
            List children = diagnostics.getChildren();
            if (children.isEmpty()) continue;
            for (Diagnostic diagnostic : children) {
                Object obj;
                int resourceSeverity = diagnostic.getSeverity();
                int messageSeverity = resourceSeverity == 4 ? 2 : 1;
                int offset = -1;
                int len = 0;
                List data = diagnostic.getData();
                if (!data.isEmpty() && (obj = data.get(0)) instanceof ASTNode) {
                    ASTNode astNode = (ASTNode)obj;
                    offset = astNode.getStartPosition();
                    len = astNode.getEndPosition() - offset;
                }
                int lineNum = -1;
                if (offset >= 0 && sourceInfo != null) {
                    lineNum = sourceInfo.getLineNumberProvider().getLineNumber(offset);
                }
                QvtMessage problem = new QvtMessage(diagnostic.getMessage(), messageSeverity, offset, len, lineNum);
                this.addProblem(problem);
            }
        }
    }

    private void computeImports(Resource unitResource, Map<URI, CompiledUnit> unitMap) {
        for (EObject next : unitResource.getContents()) {
            if (!(next instanceof Module)) continue;
            this.computeImports((Module)next, unitMap);
        }
    }

    private void computeImports(Module module, Map<URI, CompiledUnit> unitMap) {
        EList<ModuleImport> imports = module.getModuleImport();
        for (ModuleImport nextImport : imports) {
            Module importedModule = nextImport.getImportedModule();
            if (importedModule != null && importedModule.eResource() != null) {
                Resource importedResource = importedModule.eResource();
                URI importedResourceURI = importedResource.getURI();
                if (importedResourceURI.equals((Object)"http://www.eclipse.org/m2m/qvt/oml/1.0.0/Stdlib")) continue;
                CompiledUnit importedUnit = unitMap.get(importedResourceURI);
                if (importedUnit == null) {
                    importedUnit = new CompiledUnit(importedResource, unitMap);
                    unitMap.put(importedResourceURI, importedUnit);
                }
                this.fImports.add(new CompiledUnit(importedResource, unitMap));
                continue;
            }
            throw new IllegalArgumentException("imported module must be in a resource");
        }
    }

    void addProblem(QvtMessage problem) {
        if (problem == null) {
            throw new IllegalArgumentException();
        }
        this.fAllProblems.add(problem);
    }

    void setImports(List<CompiledUnit> imports) {
        this.fImports = imports;
    }

    public String getName() {
        return this.fQname.get(this.fQname.size() - 1);
    }

    public List<QvtOperationalModuleEnv> getModuleEnvironments() {
        return this.moduleEnvs;
    }

    public List<QvtMessage> getErrors() {
        ArrayList<QvtMessage> errors = new ArrayList<QvtMessage>();
        for (QvtMessage nextMessage : this.fAllProblems) {
            if (nextMessage.getSeverity() != 2) continue;
            errors.add(nextMessage);
        }
        return errors;
    }

    public List<QvtMessage> getWarnings() {
        ArrayList<QvtMessage> warnings = new ArrayList<QvtMessage>();
        for (QvtMessage nextMessage : this.fAllProblems) {
            if (nextMessage.getSeverity() != 1) continue;
            warnings.add(nextMessage);
        }
        return warnings;
    }

    public List<CompiledUnit> getCompiledImports() {
        return this.fImports != null ? this.fImports : Collections.emptyList();
    }

    public List<Module> getModules() {
        ArrayList<Module> modules = new ArrayList<Module>(this.moduleEnvs.size());
        for (QvtOperationalModuleEnv next : this.moduleEnvs) {
            if (next.getModuleContextType() == null) continue;
            modules.add(next.getModuleContextType());
        }
        return modules;
    }

    public URI getURI() {
        return this.fUri;
    }

    public UnitCS getUnitCST() {
        return this.fUnitCST;
    }

    public List<QvtMessage> getProblems() {
        return this.fAllProblems;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompiledUnit) {
            CompiledUnit another = (CompiledUnit)obj;
            return this.fUri.equals((Object)another.fUri);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.fUri.hashCode();
    }

    public String toString() {
        return this.fUri.toString();
    }
}

