/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.modelparam.ResourceEObject;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.IResultSaver;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.Messages;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.ShallowMarker;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;

public class ResourceSaver
implements IResultSaver {
    public IStatus canSave(EClassifier cls, URI destUri) {
        ResourceSet outputRS = EmfUtil.getOutputResourceSet();
        URI converted = outputRS.getURIConverter().normalize(destUri);
        Status okStatus = new Status(0, "org.eclipse.m2m.qvt.oml.emf.util.ui", 0, "", null);
        String scheme = converted.scheme();
        if (converted.isFile()) {
            if (!"file".equals(scheme) && !"platform".equals(scheme)) {
                return new Status(4, "org.eclipse.m2m.qvt.oml.emf.util.ui", 4, Messages.format(Messages.ResourceSaver_UriNotFile, destUri, scheme), null);
            }
        } else {
            if ("archive".equals(scheme)) {
                return okStatus;
            }
            if (converted.isPlatformResource()) {
                return okStatus;
            }
            try {
                URL url = new URL(destUri.toString());
                url.openConnection();
                return okStatus;
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
        }
        return new Status(4, "org.eclipse.m2m.qvt.oml.emf.util.ui", 4, NLS.bind((String)Messages.ResourceSaver_UriCorrupted, (Object)destUri), null);
    }

    public void clean(URI destUri) throws Exception {
        IFile file = URIUtils.getFile((URI)destUri);
        if (file == null) {
            return;
        }
        file.delete(true, true, null);
    }

    public boolean select(EObject obj, IWorkbenchPage page) {
        Resource resource = obj.eResource();
        if (resource == null) {
            return false;
        }
        IFile file = ResourceSaver.getFile(resource);
        if (file == null || !file.exists()) {
            return false;
        }
        IEditorPart part = null;
        IEditorDescriptor defaultEditorDescriptor = IDE.getDefaultEditor((IFile)file);
        if (defaultEditorDescriptor == null) {
            return false;
        }
        String defaultID = defaultEditorDescriptor.getId();
        if ("org.eclipse.ui.DefaultTextEditor".equals(defaultID)) {
            part = this.openEditor(page, file, "org.eclipse.emf.ecore.presentation.ReflectiveEditorID");
        }
        if (part == null) {
            part = this.openEditor(page, file, defaultID);
        }
        if (part == null) {
            return false;
        }
        if (!(part instanceof IGotoMarker)) {
            return true;
        }
        if (obj instanceof ResourceEObject && !((ResourceEObject)obj).getChildren().isEmpty()) {
            obj = (EObject)((ResourceEObject)obj).getChildren().get(0);
        }
        IGotoMarker gotoMarker = (IGotoMarker)part;
        gotoMarker.gotoMarker(this.makeMarker(obj));
        return true;
    }

    private IEditorPart openEditor(IWorkbenchPage page, IFile file, String id) {
        try {
            return IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)id, (boolean)true);
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public URI getUri(EObject obj) {
        return obj == null ? null : EcoreUtil.getURI((EObject)obj);
    }

    public static IFile getFile(EObject obj) {
        URI uri = EcoreUtil.getURI((EObject)obj);
        return URIUtils.getFile((URI)uri);
    }

    public static IFile getFile(Resource resource) {
        ResourceSet set = resource.getResourceSet();
        URI uri = set != null ? set.getURIConverter().normalize(resource.getURI()) : resource.getURI();
        return URIUtils.getFile((URI)uri);
    }

    private IMarker makeMarker(EObject obj) {
        ShallowMarker marker = new ShallowMarker("org.eclipse.emf.ecore.diagnostic");
        URI uri = EcoreUtil.getURI((EObject)obj);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("uri", String.valueOf(uri));
        marker.setAttributes(attributes);
        return marker;
    }
}

