/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.runtime.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelExtentContents;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.launch.BaseProcess;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledModule;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerFacade;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.expressions.Library;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.library.IConfiguration;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchConfigurationDelegateBase;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtInterpretedTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtModule;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.TransformationUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.Messages;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtoTransformationHelper {
    private final URI myTransfUri;

    public QvtoTransformationHelper(URI transfUri) {
        this.myTransfUri = transfUri;
    }

    public QvtoTransformationHelper(IFile qvtoFile) {
        this(URI.createPlatformResourceURI((String)qvtoFile.getFullPath().toString(), (boolean)false));
    }

    public TransfExecutionResult executeTransformation(final List<EObject> inObjects, final Map<String, Object> inConfigProperties, ResourceSet metamodelResourceSet) throws CoreException {
        try {
            final ArrayList outExtents = new ArrayList();
            final ArrayList outMainParams = new ArrayList();
            final ArrayList outTraces = new ArrayList(1);
            final ArrayList outConsole = new ArrayList(1);
            final QvtInterpretedTransformation transf = new QvtInterpretedTransformation(TransformationUtil.getQvtModule(this.myTransfUri));
            QvtCompilerOptions options = new QvtCompilerOptions();
            options.setGenerateCompletionData(false);
            options.setMetamodelResourceSet(metamodelResourceSet);
            transf.setQvtCompilerOptions(options);
            BaseProcess.IRunnable r = new BaseProcess.IRunnable(){

                public void run() throws Exception {
                    QvtLaunchConfigurationDelegateBase.doLaunch(transf, inObjects, this.getConfiguration(inConfigProperties), outExtents, outMainParams, outTraces, outConsole);
                }

                private IConfiguration getConfiguration(final Map<String, Object> inConfigProperties2) {
                    return new IConfiguration(){

                        public String getProperty(String name) {
                            return inConfigProperties2.get(name).toString();
                        }
                    };
                }
            };
            r = QvtLaunchConfigurationDelegateBase.getSafeRunnable(transf, r);
            r.run();
            final ArrayList<2> extents = new ArrayList<2>();
            Iterator iterator = outExtents.iterator();
            while (iterator.hasNext()) {
                ModelExtentContents nextExtent;
                final ModelExtentContents internExtent = nextExtent = (ModelExtentContents)iterator.next();
                ModelExtent modelExtent = new ModelExtent(){

                    @Override
                    public List<EObject> getAllRootElements() {
                        return internExtent.getAllRootElements();
                    }

                    @Override
                    public List<EObject> getInitialElements() {
                        return internExtent.getInitialElements();
                    }
                };
                extents.add(modelExtent);
            }
            return new TransfExecutionResult(){

                @Override
                public List<ModelExtent> getOutModelExtents() {
                    return extents;
                }

                @Override
                public List<EObject> getOutParameters() {
                    return outMainParams;
                }

                @Override
                public String getConsoleOutput() {
                    return outConsole.isEmpty() ? "" : (String)outConsole.get(0);
                }
            };
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2m.qvt.oml.runtime", e.getMessage()));
        }
    }

    public List<URI> getImportedTransformations() throws CoreException {
        try {
            ArrayList<URI> importUris = new ArrayList<URI>();
            QvtCompilerOptions compilerOptions = new QvtCompilerOptions();
            compilerOptions.setGenerateCompletionData(true);
            CompiledModule compiledModule = QvtCompilerFacade.getCompiledModule((URI)this.myTransfUri, (QvtCompilerOptions)compilerOptions, null).getCompiledModule();
            CFile scriptFile = ASTBindingHelper.resolveModuleFile((EObject)compiledModule.getModule());
            if (scriptFile == null) {
                throw new MdaException(NLS.bind((String)Messages.ImportedTransformation_NoWsFileForModule, (Object)compiledModule.getModule().getName()));
            }
            IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(scriptFile.getFullPath()));
            if (ifile == null) {
                throw new MdaException(NLS.bind((String)Messages.ImportedTransformation_NoWsFileForLocation, (Object)scriptFile.getFullPath()));
            }
            importUris.add(URI.createPlatformResourceURI((String)ifile.getFullPath().toString(), (boolean)false));
            LinkedHashSet imports = new LinkedHashSet();
            QvtOperationalParserUtil.collectAllImports((Module)compiledModule.getModule(), imports);
            for (Module module : imports) {
                if (module instanceof Library) continue;
                CFile scriptFile2 = ASTBindingHelper.resolveModuleFile((EObject)module);
                if (scriptFile2 == null) {
                    throw new MdaException(NLS.bind((String)Messages.ImportedTransformation_NoWsFileForModule, (Object)module.getName()));
                }
                IFile ifile2 = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(scriptFile2.getFullPath()));
                if (ifile2 == null) continue;
                importUris.add(URI.createPlatformResourceURI((String)ifile2.getFullPath().toString(), (boolean)false));
            }
            return importUris;
        }
        catch (MdaException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2m.qvt.oml.runtime", e.getMessage()));
        }
    }

    public List<String> getInputModelExtensions() throws CoreException {
        try {
            QvtModule qvtModule = TransformationUtil.getQvtModule(this.myTransfUri);
            ArrayList<String> extensions = new ArrayList<String>();
            for (QvtTransformation.TransformationParameter param : qvtModule.getParameters()) {
                if (param.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.OUT || param.getMetamodels().isEmpty()) continue;
                extensions.add(param.getMetamodels().get(0).getName());
            }
            return extensions;
        }
        catch (MdaException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2m.qvt.oml.runtime", e.getMessage()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ModelExtent {
        public List<EObject> getInitialElements();

        public List<EObject> getAllRootElements();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TransfExecutionResult {
        public List<ModelExtent> getOutModelExtents();

        public List<EObject> getOutParameters();

        public String getConsoleOutput();
    }
}

