/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtTypeResolverImpl;
import org.eclipse.m2m.internal.qvt.oml.ast.env.VirtualTable;
import org.eclipse.m2m.internal.qvt.oml.ast.env.VirtualTableAdapter;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.TypedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class QvtEnvironmentBase
extends EcoreEnvironment {
    private List<QvtEnvironmentBase> siblings;
    private Set<EOperation> fOperationsHolder;

    protected QvtEnvironmentBase(QvtEnvironmentBase parent) {
        super((Environment)parent);
    }

    protected QvtEnvironmentBase(EPackage.Registry reg, Resource resource) {
        super(reg, resource);
    }

    protected QvtEnvironmentBase(EPackage.Registry reg) {
        super(reg);
    }

    public abstract Module getModuleContextType();

    public Variable<EClassifier, EParameter> lookupImplicitSourceForOperation(String name, List<? extends TypedElement<EClassifier>> args) {
        Variable<EClassifier, EParameter> result = super.lookupImplicitSourceForOperation(name, args);
        if (result == null) {
            for (QvtEnvironmentBase nextSiblingEnv : this.getSiblings()) {
                result = nextSiblingEnv.lookupImplicitSourceForOperation(name, args);
                if (result != null) break;
            }
        }
        return result;
    }

    public Variable<EClassifier, EParameter> lookupImplicitSourceForProperty(String name) {
        Variable<EClassifier, EParameter> result = super.lookupImplicitSourceForProperty(name);
        if (result == null) {
            for (QvtEnvironmentBase nextSiblingEnv : this.getSiblings()) {
                result = nextSiblingEnv.lookupImplicitSourceForProperty(name);
                if (result != null) break;
            }
        }
        return result;
    }

    public final QvtTypeResolverImpl getQVTTypeResolver() {
        return (QvtTypeResolverImpl)this.getTypeResolver();
    }

    public final void addSibling(QvtEnvironmentBase env) {
        if (env == null || env == this || this.isOneOfParents(env)) {
            throw new IllegalArgumentException("Illegal sibling environemnt");
        }
        if (this.siblings == null) {
            this.siblings = new LinkedList<QvtEnvironmentBase>();
        }
        assert (!this.siblings.contains((Object)env));
        this.siblings.add(env);
    }

    public final List<QvtEnvironmentBase> getSiblings() {
        if (this.siblings == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.siblings);
    }

    protected final CollisionStatus findCollidingOperation(EClassifier ownerType, EOperation operation) {
        try {
            CollisionStatus collisionStatus = this.doFindCollidingOperation(ownerType, operation);
            return collisionStatus;
        }
        finally {
            if (this.fOperationsHolder != null) {
                this.fOperationsHolder.clear();
            }
        }
    }

    private CollisionStatus doFindCollidingOperation(EClassifier ownerType, EOperation operation) {
        String operationName = this.getUMLReflection().getName((Object)operation);
        List ownedOperations = TypeUtil.getOperations((Environment)this, (Object)ownerType);
        Set<EOperation> operations = this.operationHolder();
        operations.addAll(ownedOperations);
        if (!(ownerType instanceof Module)) {
            this.getQVTTypeResolver().collectAdditionalOperationsInTypeHierarchy(ownerType, true, operations);
        }
        for (EOperation next : operations) {
            EClassifier nextOwner;
            if (next == operation || !this.getUMLReflection().getName((Object)next).equals(operationName) || !this.matchParameters(next, operation) || (nextOwner = (EClassifier)this.getUMLReflection().getOwningClassifier((Object)next)) == null) continue;
            int rel = TypeUtil.getRelationship((Environment)this, (Object)ownerType, (Object)nextOwner);
            if (rel != 1 && (7 | rel) != 0) {
                EClassifier ret1 = next.getEType();
                EClassifier ret2 = operation.getEType();
                if (ret1 != null && ret2 != null && TypeUtil.getRelationship((Environment)this, (Object)ret1, (Object)ret2) != 1) {
                    if ("main".equals(operationName)) {
                        return null;
                    }
                    return new CollisionStatus(next, 2);
                }
                if (!QvtOperationalUtil.isImperativeOperation(operation) || !QvtOperationalUtil.isImperativeOperation(next)) continue;
                VirtualTable sourceOperVtable = this.getVirtualTable(operation);
                sourceOperVtable.addOperation(next);
                VirtualTable targetOperVtable = this.getVirtualTable(next);
                targetOperVtable.addOperation(operation);
                continue;
            }
            if (ownerType != nextOwner) continue;
            return new CollisionStatus(next, 1);
        }
        return null;
    }

    private VirtualTable getVirtualTable(EOperation operation) {
        return VirtualTableAdapter.getAdapter(operation, true).getVirtualTable();
    }

    private boolean matchParameters(EOperation a, EOperation b) {
        List aparms = this.getUMLReflection().getParameters((Object)a);
        List bparms = this.getUMLReflection().getParameters((Object)b);
        if (aparms.size() == bparms.size()) {
            int count = aparms.size();
            int i = 0;
            while (i < count) {
                EParameter aparm = (EParameter)aparms.get(i);
                EParameter bparm = (EParameter)bparms.get(i);
                if (TypeUtil.getRelationship((Environment)this, (Object)((EClassifier)this.getUMLReflection().getOCLType((Object)aparm)), (Object)((EClassifier)this.getUMLReflection().getOCLType((Object)bparm))) != 1) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private boolean isOneOfParents(EcoreEnvironment env) {
        EcoreEnvironment parent = (EcoreEnvironment)env.getInternalParent();
        while (parent != null) {
            if (parent == env) {
                return true;
            }
            parent = (EcoreEnvironment)parent.getInternalParent();
        }
        return false;
    }

    private Set<EOperation> operationHolder() {
        if (this.fOperationsHolder == null) {
            this.fOperationsHolder = new LinkedHashSet<EOperation>();
        }
        return this.fOperationsHolder;
    }

    public static class CollisionStatus {
        public static final int ALREADY_DEFINED = 1;
        public static final int VIRTUAL_METHOD_RETURNTYPE = 2;
        private int fKind;
        private EOperation fOperation;

        CollisionStatus(EOperation operation, int kind) {
            if (kind != 1 && kind != 2) {
                throw new IllegalArgumentException("illegal collision kind");
            }
            this.fKind = kind;
            this.fOperation = operation;
        }

        public int getCollisionKind() {
            return this.fKind;
        }

        public EOperation getOperation() {
            return this.fOperation;
        }
    }
}

