/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RegionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.PartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceElementAnalysis;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class TracePropertyAnalysis<@NonNull RA extends PartialRegionAnalysis<@NonNull RA>>
extends TraceElementAnalysis<RA> {
    protected final @NonNull RegionsAnalysis<@NonNull RA> regionsAnalysis;
    protected final @NonNull TraceClassAnalysis<@NonNull RA> traceClassAnalysis;
    protected final @NonNull PropertyDatum tracePropertyDatum;

    protected TracePropertyAnalysis(@NonNull RegionsAnalysis<@NonNull RA> regionsAnalysis, @NonNull TraceClassAnalysis<@NonNull RA> traceClassAnalysis, @NonNull PropertyDatum tracePropertyDatum) {
        this.regionsAnalysis = regionsAnalysis;
        this.traceClassAnalysis = traceClassAnalysis;
        this.tracePropertyDatum = tracePropertyDatum;
        assert (regionsAnalysis.getTraceClassAnalysis(QVTscheduleUtil.getOwningClassDatum((PropertyDatum)tracePropertyDatum)) == traceClassAnalysis);
    }

    public String getName() {
        return this.tracePropertyDatum.getName();
    }

    public @NonNull Iterable<@NonNull TracePropertyAnalysis<@NonNull RA>> getSuperTracePropertyAnalyses() {
        ArrayList<@NonNull TracePropertyAnalysis<@NonNull RA>> tracePropertyAnalyses = new ArrayList<TracePropertyAnalysis<RA>>();
        for (TraceClassAnalysis<RA> superTraceClassAnalysis : this.traceClassAnalysis.getSuperTraceClassAnalyses()) {
            TracePropertyAnalysis<RA> tracePropertyAnalysis;
            ClassDatum superTraceClassDatum = superTraceClassAnalysis.getClassDatum();
            PropertyDatum propertyDatum = (PropertyDatum)NameUtil.getNameable((Iterable)superTraceClassDatum.getOwnedPropertyDatums(), (String)this.getName());
            if (propertyDatum == null || (tracePropertyAnalysis = this.regionsAnalysis.basicGetTracePropertyAnalysis(propertyDatum)) == null || tracePropertyAnalyses.contains(tracePropertyAnalysis)) continue;
            tracePropertyAnalyses.add(tracePropertyAnalysis);
        }
        assert (tracePropertyAnalyses.contains(this));
        return tracePropertyAnalyses;
    }

    public @NonNull Property getTraceProperty() {
        return QVTscheduleUtil.getReferredProperty((PropertyDatum)this.tracePropertyDatum);
    }

    public String toString() {
        return this.tracePropertyDatum.toString();
    }
}

