/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.mappings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EGenericTypeImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.qvt.declarative.ecore.adapters.AdaptingEObject;
import org.eclipse.qvt.declarative.ecore.mappings.AbstractFeatureElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MappingUtils {
    public static <T> T asClassUnchecked(Object object, T requiredClassObject) {
        return (T)object;
    }

    public static Map<String, EPackage> createPackageMap(Resource resource) {
        HashMap<String, EPackage> uriToPackageMap = new HashMap<String, EPackage>();
        MappingUtils.createPackageMapRecursion(uriToPackageMap, (List<? extends EObject>)resource.getContents());
        return uriToPackageMap;
    }

    public static void createPackageMapRecursion(Map<String, EPackage> uriToPackageMap, List<? extends EObject> eObjects) {
        for (EObject eObject : eObjects) {
            if (!(eObject instanceof EPackage)) continue;
            uriToPackageMap.put(((EPackage)eObject).getNsURI(), (EPackage)eObject);
            MappingUtils.createPackageMapRecursion(uriToPackageMap, (List<? extends EObject>)((EPackage)eObject).getESubpackages());
        }
    }

    public static List<EGenericType> excludeNonGenericTypes(List<EGenericType> genericTypes) {
        boolean fullyGeneric = true;
        for (EGenericType genericType : genericTypes) {
            if (MappingUtils.isGeneric(genericType)) continue;
            fullyGeneric = false;
        }
        if (fullyGeneric) {
            return genericTypes;
        }
        ArrayList<EGenericType> reallyGenericTypes = new ArrayList<EGenericType>();
        for (EGenericType genericType : genericTypes) {
            if (!MappingUtils.isGeneric(genericType)) continue;
            reallyGenericTypes.add(genericType);
        }
        return reallyGenericTypes;
    }

    public static String formatClassAndFeatureName(EObject object) {
        StringBuffer s = new StringBuffer();
        s.append("'");
        MappingUtils.formatClassAndFeatureName(s, object);
        s.append("'");
        return s.toString();
    }

    public static void formatClassAndFeatureName(StringBuffer s, EObject object) {
        EObject container;
        EObject eObject = container = object != null ? object.eContainer() : null;
        if (container instanceof EClass) {
            s.append(MappingUtils.formatLocalName(container));
            s.append(".");
        }
        s.append(MappingUtils.formatLocalName(object));
    }

    public static String formatFeatureName(AbstractFeatureElement<?> feature) {
        return feature.formatName();
    }

    public static String formatFeatureName(EStructuralFeature eStructuralFeature) {
        return String.valueOf(MappingUtils.formatLocalName(eStructuralFeature.eContainer())) + "." + MappingUtils.formatLocalName(eStructuralFeature);
    }

    public static String formatFullName(Object object) {
        EObject container = null;
        if (object instanceof AdaptingEObject) {
            return String.valueOf(((AdaptingEObject)object).getMappingMetaDataRegistry().getName()) + "(" + MappingUtils.formatFullName(((AdaptingEObject)object).getTarget()) + ")";
        }
        if (object instanceof EObject) {
            if (((EObject)object).eIsProxy()) {
                return EcoreUtil.getURI((EObject)((EObject)object)).toString();
            }
            container = ((EObject)object).eContainer();
        }
        if (object instanceof EClass) {
            EPackage ePackage = ((EClass)object).getEPackage();
            if (ePackage != null) {
                return String.valueOf(MappingUtils.formatString(ePackage.getNsPrefix())) + ":" + MappingUtils.formatString(((ENamedElement)object).getName());
            }
            return "??:" + MappingUtils.formatString(((ENamedElement)object).getName());
        }
        if (container != null) {
            return String.valueOf(MappingUtils.formatFullName(container)) + "/" + MappingUtils.formatLocalName(object);
        }
        return "/" + MappingUtils.formatLocalName(object);
    }

    public static String formatLocalName(Object object) {
        if (object == null) {
            return "null-object";
        }
        if (object instanceof EObject && ((EObject)object).eIsProxy()) {
            return MappingUtils.formatString(EcoreUtil.getURI((EObject)((EObject)object)));
        }
        if (object instanceof ENamedElement) {
            return MappingUtils.formatString(((ENamedElement)object).getName());
        }
        if (object instanceof Resource) {
            return "Resource(" + MappingUtils.formatLocalName(((Resource)object).getURI()) + ")";
        }
        if (object instanceof URI) {
            return "'" + MappingUtils.formatString(((URI)object).toString()) + "'";
        }
        if (object instanceof EAnnotation) {
            return "EAnnotation.'" + MappingUtils.formatString(((EAnnotation)object).getSource()) + "'";
        }
        if (object instanceof Boolean) {
            return "Boolean." + object.toString();
        }
        if (object instanceof Integer) {
            return "Integer." + object.toString();
        }
        if (object instanceof String) {
            return "String.'" + object + "'";
        }
        if (object instanceof Map.Entry) {
            return "Map.Entry[" + MappingUtils.formatString(((Map.Entry)object).getKey()) + "]";
        }
        if (object instanceof Collection) {
            return String.valueOf(MappingUtils.formatLocalClassName(object)) + "[" + ((Collection)object).size() + "]";
        }
        return "unnamed-" + MappingUtils.formatLocalClassName(object);
    }

    public static String formatLocalClassName(Object object) {
        int i;
        String name = object.getClass().getSimpleName();
        if ("".equals(name) && (i = (name = object.getClass().getName()).lastIndexOf(".")) >= 0) {
            name = name.substring(i + 1);
        }
        return name;
    }

    public static void formatObject(StringBuffer s, Object object) {
        if (object instanceof Collection) {
            String prefix = "";
            for (Object obj : (Collection)object) {
                s.append(prefix);
                MappingUtils.formatObject(s, obj);
                prefix = ",";
            }
        } else if (object instanceof EObject) {
            s.append(MappingUtils.formatClassAndFeatureName((EObject)object));
        } else {
            s.append("'");
            s.append(MappingUtils.formatString(object));
            s.append("'");
        }
    }

    public static String formatString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "null-string";
    }

    public static boolean isGeneric(ETypedElement eTypedElement) {
        return eTypedElement != null ? MappingUtils.isGeneric(eTypedElement.getEGenericType()) : false;
    }

    public static boolean isGeneric(EGenericType eGenericType) {
        EList eTypeParameters;
        EClassifier eClassifier;
        return eGenericType != null && (eClassifier = ((EGenericTypeImpl)eGenericType).basicGetEClassifier()) != null && (eTypeParameters = eClassifier.getETypeParameters()) != null && eTypeParameters.size() > 0;
    }

    public static void promoteReferencesToSelfToSelf(Resource resource) {
        Map<String, EPackage> uriToPackageMap = MappingUtils.createPackageMap(resource);
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            EClass eClass = eObject.eClass();
            for (EStructuralFeature eFeature : eClass.getEAllStructuralFeatures()) {
                EClassifier normalisedClassifier;
                EGenericType referencedGenericType;
                EClassifier referencedClassifier;
                EPackage referencedPackage;
                EPackage normalisedPackage;
                if (eFeature instanceof EReference && ((EReference)eFeature).isContainment() || eFeature == EcorePackage.eINSTANCE.getEGenericType_EClassifier() || (normalisedPackage = uriToPackageMap.get((referencedPackage = (referencedClassifier = (referencedGenericType = eFeature.getEGenericType()) != null ? referencedGenericType.getEClassifier() : eFeature.getEType()).getEPackage()).getNsURI())) == null || normalisedPackage == referencedPackage || (normalisedClassifier = normalisedPackage.getEClassifier(referencedClassifier.getName())) == null) continue;
                if (referencedGenericType != null) {
                    referencedGenericType.setEClassifier(normalisedClassifier);
                    continue;
                }
                eFeature.setEType(normalisedClassifier);
            }
        }
    }
}

