/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.imp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lpg.runtime.Adjunct;
import lpg.runtime.ILexStream;
import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;
import org.eclipse.imp.services.base.FolderBase;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.qvt.declarative.editor.FoldingBehavior;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonEditorDefinition;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonParseResult;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonPlugin;
import org.eclipse.qvt.declarative.parser.utils.CommonASTVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonFoldingUpdater
extends FolderBase {
    protected IPrsStream prsStream = null;

    protected abstract ICommonPlugin getPlugin();

    protected void makeAdjunctAnnotations(CSTNode theAST) {
        ILexStream lexStream = this.prsStream.getILexStream();
        if (lexStream == null) {
            return;
        }
        ArrayList adjuncts = this.prsStream.getAdjuncts();
        int i = 0;
        while (i < adjuncts.size()) {
            Adjunct adjunct = (Adjunct)adjuncts.get(i);
            IToken previous_token = this.prsStream.getIToken(adjunct.getTokenIndex());
            IToken next_token = this.prsStream.getIToken(this.prsStream.getNext(previous_token.getTokenIndex()));
            IToken[] comments = previous_token.getFollowingAdjuncts();
            int k = 0;
            while (k < comments.length) {
                Adjunct comment = (Adjunct)comments[k];
                if (comment.getEndLine() > comment.getLine()) {
                    IToken gate_token = k + 1 < comments.length ? comments[k + 1] : next_token;
                    this.makeAnnotationWithOffsets(comment.getStartOffset(), gate_token.getLine() > comment.getEndLine() ? lexStream.getLineOffset(gate_token.getLine() - 1) : comment.getEndOffset());
                }
                ++k;
            }
            i += comments.length;
        }
    }

    private void makeAnnotation(IToken first_token, IToken last_token) {
        if (last_token.getEndLine() > first_token.getLine()) {
            IToken next_token = this.prsStream.getIToken(this.prsStream.getNext(last_token.getTokenIndex()));
            IToken[] adjuncts = next_token.getPrecedingAdjuncts();
            IToken gate_token = adjuncts.length == 0 ? next_token : adjuncts[0];
            this.makeAnnotationWithOffsets(first_token.getStartOffset(), gate_token.getLine() > last_token.getEndLine() ? this.prsStream.getILexStream().getLineOffset(gate_token.getLine() - 1) : last_token.getEndOffset());
        }
    }

    protected void makeAnnotation(CSTNode n) {
        this.makeAnnotation(n.getStartToken(), n.getEndToken());
    }

    public void makeAnnotationWithOffsets(int first_offset, int last_offset) {
        super.makeAnnotation(first_offset, last_offset - first_offset + 1);
    }

    public void sendVisitorToAST(HashMap<Annotation, Position> newAnnotations, List<Annotation> annotations, Object ast) {
        IToken startToken;
        CSTNode theCST = ((ICommonParseResult)ast).getCST();
        if (theCST != null && (startToken = theCST.getStartToken()) != null) {
            this.prsStream = startToken.getIPrsStream();
            FoldingCSTVisitor visitor = new FoldingCSTVisitor(this.getPlugin().getEditorDefinition());
            visitor.enter(theCST);
            this.makeAdjunctAnnotations(theCST);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FoldingCSTVisitor
    extends CommonASTVisitor<Object, CSTNode> {
        protected final CommonEditorDefinition editorDefinition;

        public FoldingCSTVisitor(CommonEditorDefinition editorDefinition) {
            super(CSTNode.class);
            this.editorDefinition = editorDefinition;
        }

        public boolean preVisit(CSTNode cstNode) {
            FoldingBehavior behavior = this.editorDefinition.getBehavior(cstNode, FoldingBehavior.class);
            if (behavior != null) {
                CommonFoldingUpdater.this.makeAnnotation(cstNode);
            }
            return true;
        }
    }
}

