/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.doc.bigmde2016.tests.qvtc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.qvtd.doc.bigmde2016.tests.FamiliesGenerator;
import org.eclipse.qvtd.doc.bigmde2016.tests.PrintAndLog;
import org.eclipse.qvtd.doc.bigmde2016.tests.qvtc.BigMDE2016_QVTc_AutomatedTests;
import org.eclipse.qvtd.doc.bigmde2016.tests.qvtc.Families.FamiliesFactory;
import org.eclipse.qvtd.doc.bigmde2016.tests.qvtc.Families.Family;
import org.eclipse.qvtd.doc.bigmde2016.tests.qvtc.Families.Member;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.junit.Test;

public class BigMDE2016CGTests
extends BigMDE2016_QVTc_AutomatedTests {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testQVTcCompiler_Families_EcoreUtilCopy() throws Exception {
        PrintAndLog logger = new PrintAndLog("results/" + this.getName());
        logger.printf("%s\n", this.getName());
        QVTiEnvironmentFactory environmentFactory = new QVTiEnvironmentFactory(ProjectManager.NO_PROJECTS, null);
        try {
            int[] tests;
            int[] nArray = tests = PrintAndLog.getTestSizes();
            int n = tests.length;
            int n2 = 0;
            while (n2 < n) {
                int testSize = nArray[n2];
                List<@NonNull ? extends EObject> rootObjects = FamiliesGenerator.createFamiliesModel(testSize, 9);
                BigMDE2016CGTests.garbageCollect();
                logger.printf("%9d, ", 10 * testSize);
                long startTime = System.nanoTime();
                @NonNull Collection rootObjects2 = EcoreUtil.copyAll(rootObjects);
                long endTime = System.nanoTime();
                logger.printf("%9.6f\n", (double)(endTime - startTime) / 1.0E9);
                assert (rootObjects2.size() == testSize);
                ++n2;
            }
        }
        finally {
            environmentFactory.dispose();
            logger.dispose();
        }
    }

    @Test
    public void testQVTcCompiler_Families2Persons_CG() throws Exception {
        PrintAndLog logger = new PrintAndLog(this.getName());
        logger.printf("%s\n", this.getName());
        QVTiEnvironmentFactory environmentFactory = new QVTiEnvironmentFactory(ProjectManager.NO_PROJECTS, null);
        try {
            int[] tests;
            int[] nArray = tests = PrintAndLog.getTestSizes();
            int n = tests.length;
            int n2 = 0;
            while (n2 < n) {
                int testSize = nArray[n2];
                this.doTest(logger, environmentFactory, testSize);
                ++n2;
            }
        }
        finally {
            environmentFactory.dispose();
            logger.dispose();
        }
    }

    @Test
    public void testQVTcCompiler_Families2Persons_ManualInPlace() throws Exception {
        PrintAndLog logger = new PrintAndLog(this.getName());
        logger.printf("%s\n", this.getName());
        QVTiEnvironmentFactory environmentFactory = new QVTiEnvironmentFactory(ProjectManager.NO_PROJECTS, null);
        try {
            int[] tests;
            int[] nArray = tests = PrintAndLog.getTestSizes();
            int n = tests.length;
            int n2 = 0;
            while (n2 < n) {
                int testSize = nArray[n2];
                List<@NonNull ? extends EObject> rootObjects = FamiliesGenerator.createFamiliesModel(testSize, 9);
                BigMDE2016CGTests.garbageCollect();
                logger.printf("%9d, ", 10 * testSize);
                long startTime = System.nanoTime();
                ArrayList<Member> members = new ArrayList<Member>(9 * testSize);
                for (EObject eObject : rootObjects) {
                    Family family = (Family)eObject;
                    members.add(family.getFather());
                    members.add(family.getMother());
                    members.addAll((Collection<Member>)family.getSons());
                    members.addAll((Collection<Member>)family.getDaughters());
                }
                long l = System.nanoTime();
                logger.printf("%9.6f\n", (double)(l - startTime) / 1.0E9);
                assert (members.size() == 9 * testSize);
                ++n2;
            }
        }
        finally {
            environmentFactory.dispose();
            logger.dispose();
        }
    }

    @Test
    public void testQVTcCompiler_Families2Persons_ManualCopy() throws Exception {
        PrintAndLog logger = new PrintAndLog(this.getName());
        logger.printf("%s\n", this.getName());
        QVTiEnvironmentFactory environmentFactory = new QVTiEnvironmentFactory(ProjectManager.NO_PROJECTS, null);
        try {
            int[] tests;
            int[] nArray = tests = PrintAndLog.getTestSizes();
            int n = tests.length;
            int n2 = 0;
            while (n2 < n) {
                int testSize = nArray[n2];
                List<@NonNull ? extends EObject> rootObjects = FamiliesGenerator.createFamiliesModel(testSize, 9);
                BigMDE2016CGTests.garbageCollect();
                logger.printf("%9d, ", 10 * testSize);
                long startTime = System.nanoTime();
                ArrayList<Member> members = new ArrayList<Member>(9 * testSize);
                for (EObject eObject : rootObjects) {
                    Family family = (Family)eObject;
                    members.add(this.manualCopy(family.getFather()));
                    members.add(this.manualCopy(family.getMother()));
                    for (Member member : family.getSons()) {
                        members.add(this.manualCopy(member));
                    }
                    for (Member member : family.getDaughters()) {
                        members.add(this.manualCopy(member));
                    }
                }
                long l = System.nanoTime();
                logger.printf("%9.6f\n", (double)(l - startTime) / 1.0E9);
                assert (members.size() == 9 * testSize);
                ++n2;
            }
        }
        finally {
            environmentFactory.dispose();
            logger.dispose();
        }
    }

    private Member manualCopy(@NonNull Member oldMember) {
        Member newMember = FamiliesFactory.eINSTANCE.createMember();
        newMember.setFirstName(oldMember.getFirstName());
        return newMember;
    }
}

