/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis;

import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.UniqueList;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.AbstractPartialRegionPropertyAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.BasePartialRegionPropertyAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionsAnalysis;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class ActualPartialRegionPropertyAnalysis<@NonNull PRA extends PartialRegionsAnalysis<@NonNull PRA>>
extends AbstractPartialRegionPropertyAnalysis<PRA> {
    protected final @NonNull BasePartialRegionPropertyAnalysis<@NonNull PRA> basePropertyAnalysis;

    protected ActualPartialRegionPropertyAnalysis(@NonNull BasePartialRegionPropertyAnalysis<PRA> basePropertyAnalysis, @NonNull PartialRegionClassAnalysis<@NonNull PRA> classAnalysis, @NonNull PropertyDatum propertyDatum) {
        super(basePropertyAnalysis.partialRegionsAnalysis, classAnalysis, propertyDatum);
        this.basePropertyAnalysis = basePropertyAnalysis;
    }

    @Override
    public @NonNull BasePartialRegionPropertyAnalysis<@NonNull PRA> getBasePropertyAnalysis() {
        return this.basePropertyAnalysis;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull Iterable<@NonNull PartialRegionAnalysis<@NonNull PRA>> getCompatibleProducers() {
        @NonNull @NonNull UniqueList compatibleProducers = new UniqueList();
        ClassDatum owningClassDatum = QVTscheduleUtil.getOwningClassDatum((PropertyDatum)this.propertyDatum);
        ClassDatum targetClassDatum = this.propertyDatum.getTargetClassDatum();
        Property referredProperty = this.propertyDatum.getReferredProperty();
        Property oppositeProperty = referredProperty.getOpposite();
        for (ActualPartialRegionPropertyAnalysis actualPropertyAnalysis : this.basePropertyAnalysis.propertyDatum2propertyAnalysis.values()) {
            PropertyDatum actualPropertyDatum = actualPropertyAnalysis.getPropertyDatum();
            ClassDatum actualOwningClassDatum = QVTscheduleUtil.getOwningClassDatum((PropertyDatum)actualPropertyDatum);
            ClassDatum actualTargetClassDatum = actualPropertyDatum.getTargetClassDatum();
            Property actualProperty = actualPropertyDatum.getReferredProperty();
            boolean isCompatible = false;
            if (actualProperty == oppositeProperty) {
                isCompatible = QVTscheduleUtil.conformsTo((ClassDatum)owningClassDatum, (ClassDatum)actualOwningClassDatum);
            } else {
                assert (actualProperty == referredProperty) : "Inconsistent producer property " + actualProperty;
                if (QVTscheduleUtil.conformsTo((ClassDatum)actualOwningClassDatum, (ClassDatum)owningClassDatum)) {
                    boolean bl = isCompatible = targetClassDatum == null || actualTargetClassDatum == null || QVTscheduleUtil.conformsTo((ClassDatum)actualTargetClassDatum, (ClassDatum)targetClassDatum);
                }
            }
            if (!isCompatible) continue;
            @NonNull ActualPartialRegionPropertyAnalysis<@NonNull PRA> actualSuperPropertyAnalysis = actualPropertyAnalysis;
            for (PartialRegionAnalysis actualProducer : actualSuperPropertyAnalysis.getExactProducers()) {
                compatibleProducers.add(actualProducer);
            }
        }
        assert (compatibleProducers.containsAll((Collection)this.producers));
        return compatibleProducers;
    }
}

