/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtimperative.tests;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.core.VMVariable;
import org.eclipse.ocl.examples.xtext.tests.TestFile;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.examples.xtext.tests.TestUIUtil;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.xtext.base.ui.model.BaseEditorCallback;
import org.eclipse.qvtd.debug.core.QVTiDebugTarget;
import org.eclipse.qvtd.debug.evaluator.QVTiVMRootEvaluationEnvironment;
import org.eclipse.qvtd.debug.vm.QVTiVMVirtualMachine;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.qvtd.xtext.qvtbase.tests.XtextTestCase;
import org.eclipse.qvtd.xtext.qvtimperative.ui.internal.QVTimperativeActivator;

public class QVTiDebuggerTests
extends XtextTestCase {
    private void checkPosition(@NonNull IThread vmThread, int lineNumber, int charStart, int charEnd) throws DebugException {
        IStackFrame topStackFrame = vmThread.getTopStackFrame();
        QVTiDebuggerTests.assertEquals((String)"lineNumber", (int)lineNumber, (int)topStackFrame.getLineNumber());
        QVTiDebuggerTests.assertEquals((String)"charStart", (int)charStart, (int)topStackFrame.getCharStart());
        QVTiDebuggerTests.assertEquals((String)"charEnd", (int)charEnd, (int)topStackFrame.getCharEnd());
    }

    private void checkVariable(@NonNull IThread vmThread, @NonNull String name, @Nullable Object expectedValue) throws DebugException {
        IStackFrame topStackFrame = vmThread.getTopStackFrame();
        IVariable[] variables = topStackFrame.getVariables();
        if (variables != null) {
            IVariable[] iVariableArray = variables;
            int n = variables.length;
            int n2 = 0;
            while (n2 < n) {
                IVariable variable = iVariableArray[n2];
                if (name.equals(variable.getName()) && variable instanceof VMVariable) {
                    Object valueObject = ((VMVariable)variable).getVmVar().valueObject;
                    QVTiDebuggerTests.assertEquals((Object)expectedValue, (Object)valueObject);
                    return;
                }
                ++n2;
            }
        }
        QVTiDebuggerTests.fail((String)("Unknown variable '" + name + "'"));
    }

    private void checkVariables(@NonNull IThread vmThread, String ... names) throws DebugException {
        ArrayList<String> expectedNames = new ArrayList<String>();
        if (names != null) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                expectedNames.add(name);
                ++n2;
            }
        }
        Collections.sort(expectedNames);
        IStackFrame topStackFrame = vmThread.getTopStackFrame();
        IVariable[] variables = topStackFrame.getVariables();
        ArrayList<String> actualNames = new ArrayList<String>();
        if (variables != null) {
            IVariable[] iVariableArray = variables;
            int n = variables.length;
            int n3 = 0;
            while (n3 < n) {
                IVariable variable = iVariableArray[n3];
                actualNames.add(variable.getName());
                ++n3;
            }
        }
        Collections.sort(actualNames);
        QVTiDebuggerTests.assertEquals(expectedNames, actualNames);
    }

    protected ILaunchConfigurationWorkingCopy createLaunchConfiguration(@NonNull TestProject testProject, @NonNull String launchName, @NonNull TestFile txFile, @NonNull Map<String, String> newInKeys, @NonNull Map<String, String> newOutKeys) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.qvtd.debug.launching.QVTiLaunchConfigurationDelegate");
        ILaunchConfigurationWorkingCopy launchConfiguration = launchConfigurationType.newInstance((IContainer)testProject.getIProject(), launchName);
        launchConfiguration.setAttribute("tx", txFile.getURI().toString());
        launchConfiguration.setAttribute("in", newInKeys);
        launchConfiguration.setAttribute("out", newOutKeys);
        launchConfiguration.setAttribute("interpreted", true);
        launchConfiguration.setAttribute("console-trace", false);
        return launchConfiguration;
    }

    protected @NonNull String getProjectName() {
        return (String)ClassUtil.nonNullState((Object)((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/'));
    }

    public void testDebugger_Run_HSV2HSL() throws Exception {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            return;
        }
        @NonNull String inName = "hsl";
        @NonNull String outName = "hsv";
        @NonNull String middleName = "middle";
        TestUIUtil.closeIntro();
        TestUIUtil.enableSwitchToDebugPerspectivePreference();
        OCL ocl = OCL.newInstance((ProjectManager)OCL.CLASS_PATH);
        URIConverter uriConverter = ocl.getResourceSet().getURIConverter();
        TestProject testProject = this.getTestProject();
        TestFile txFile = testProject.copyFile(uriConverter, null, this.getModelsURI("HSV2HSL/HSV2HSL.qvti"));
        TestFile inFile = testProject.copyFile(uriConverter, null, this.getModelsURI("HSV2HSL/HSVNode.xmi"));
        testProject.copyFile(uriConverter, null, this.getModelsURI("HSV2HSL/HSVTree.ecore"));
        testProject.copyFile(uriConverter, null, this.getModelsURI("HSV2HSL/HSLTree.ecore"));
        testProject.copyFile(uriConverter, null, this.getModelsURI("HSV2HSL/HSV2HSL.ecore"));
        TestFile outFile = testProject.getOutputFile("HSLNode.xmi");
        TestFile middleFile = testProject.getOutputFile("HSV2HSLNode.xmi");
        HashMap<String, String> inMap = new HashMap<String, String>();
        inMap.put("hsv", inFile.getURI().toString());
        HashMap<String, String> outMap = new HashMap<String, String>();
        outMap.put("hsl", outFile.getURI().toString());
        outMap.put("middle", middleFile.getURI().toString());
        ILaunchConfigurationWorkingCopy launchConfiguration = this.createLaunchConfiguration(testProject, "HSV2HSL", txFile, inMap, outMap);
        launchConfiguration.doSave();
        TestUIUtil.flushEvents();
        ILaunch launch = launchConfiguration.launch("run", null);
        assert (launch != null);
        TestUIUtil.waitForLaunchToTerminate((ILaunch)launch);
        int i = 0;
        while (i < 10) {
            testProject.getIProject().refreshLocal(2, null);
            if (outFile.getFile().exists()) break;
            TestUIUtil.wait((int)1000);
            ++i;
        }
        ResourceSetImpl expectedResourceSet = new ResourceSetImpl();
        ocl.getProjectManager().initializeResourceSet((ResourceSet)expectedResourceSet);
        Resource expectedResource = expectedResourceSet.getResource(this.getModelsURI("HSV2HSL/HSLNodeValidate.xmi"), true);
        assert (expectedResource != null);
        ResourceSetImpl actualResourceSet = new ResourceSetImpl();
        Resource actualResource = actualResourceSet.getResource(outFile.getURI(), true);
        assert (actualResource != null);
        TestUtil.assertSameModel((Resource)expectedResource, (Resource)actualResource);
        ocl.dispose();
    }

    public void testDebugger_Debug_HSV2HSL() throws Exception {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            return;
        }
        assert (!EPackage.Registry.INSTANCE.containsKey((Object)"http://www.eclipse.org/qvt/examples/0.1/HSVTree"));
        assert (!EPackage.Registry.INSTANCE.containsKey((Object)"http://www.eclipse.org/qvt/examples/0.1/HSLTree"));
        assert (!EPackage.Registry.INSTANCE.containsKey((Object)"http://www.eclipse.org/qvt/examples/0.1/HSVtoHSL"));
        @NonNull String inName = "hsl";
        @NonNull String outName = "hsv";
        @NonNull String middleName = "middle";
        TestUIUtil.closeIntro();
        TestUIUtil.enableSwitchToDebugPerspectivePreference();
        Injector injector = QVTimperativeActivator.getInstance().getInjector("org.eclipse.qvtd.xtext.qvtimperative.QVTimperative");
        ((BaseEditorCallback)injector.getInstance(BaseEditorCallback.class)).setDontAskForNatureAgain();
        OCL ocl = OCL.newInstance((ProjectManager)OCL.CLASS_PATH);
        URIConverter uriConverter = ocl.getResourceSet().getURIConverter();
        TestProject testProject = this.getTestProject();
        TestFile txFile = testProject.copyFile(uriConverter, null, this.getModelsURI("HSV2HSL/HSV2HSL.qvti"));
        TestFile inFile = testProject.copyFile(uriConverter, null, this.getModelsURI("HSV2HSL/HSVNode.xmi"));
        testProject.copyFile(uriConverter, null, this.getModelsURI("HSV2HSL/HSVTree.ecore"));
        testProject.copyFile(uriConverter, null, this.getModelsURI("HSV2HSL/HSLTree.ecore"));
        testProject.copyFile(uriConverter, null, this.getModelsURI("HSV2HSL/HSV2HSL.ecore"));
        TestFile outFile = testProject.getOutputFile("HSLNode.xmi");
        TestFile middleFile = testProject.getOutputFile("HSV2HSLNode.xmi");
        HashMap<String, String> inMap = new HashMap<String, String>();
        inMap.put("hsv", inFile.getURI().toString());
        HashMap<String, String> outMap = new HashMap<String, String>();
        outMap.put("hsl", outFile.getURI().toString());
        outMap.put("middle", middleFile.getURI().toString());
        ILaunchConfigurationWorkingCopy launchConfiguration = this.createLaunchConfiguration(testProject, "HSV2HSL", txFile, inMap, outMap);
        launchConfiguration.doSave();
        TestUIUtil.flushEvents();
        ILaunch launch = launchConfiguration.launch("debug", null);
        assert (launch != null);
        QVTiDebugTarget debugTarget = (QVTiDebugTarget)launch.getDebugTarget();
        QVTiVMVirtualMachine vm = (QVTiVMVirtualMachine)debugTarget.getVM();
        QVTiVMRootEvaluationEnvironment vmRootEvaluationEnvironment = (QVTiVMRootEvaluationEnvironment)vm.getEvaluationEnv();
        assert (vmRootEvaluationEnvironment != null);
        ImperativeTransformation asTransformation = (ImperativeTransformation)vmRootEvaluationEnvironment.getDebuggableElement();
        TypedModel inTypedModel = QVTimperativeUtil.getModelParameter((Transformation)asTransformation, (String)"hsl");
        TypedModel middleTypedModel = QVTimperativeUtil.getModelParameter((Transformation)asTransformation, (String)"middle");
        TypedModel outTypedModel = QVTimperativeUtil.getModelParameter((Transformation)asTransformation, (String)"hsv");
        Parameter asTransformationVariable = asTransformation.getOwnedContext();
        Parameter asInVariable = inTypedModel.getOwnedContext();
        Parameter asMiddleVariable = middleTypedModel.getOwnedContext();
        Parameter asOutVariable = outTypedModel.getOwnedContext();
        assert (asTransformationVariable != null && asInVariable != null && asMiddleVariable != null && asOutVariable != null);
        IThread vmThread = debugTarget.getThreads()[0];
        assert (vmThread != null);
        TestUIUtil.waitForSuspended((IThread)vmThread);
        TestUIUtil.waitForNotStepping((IThread)vmThread);
        this.checkPosition(vmThread, 8, 448, 455);
        this.checkVariables(vmThread, "$pc", "this", "hsv", "hsl", "middle");
        this.checkVariable(vmThread, "$pc", asTransformation);
        this.checkVariable(vmThread, "this", vmRootEvaluationEnvironment.getValueOf((TypedElement)asTransformationVariable));
        this.checkVariable(vmThread, "hsv", vmRootEvaluationEnvironment.getValueOf((TypedElement)asOutVariable));
        this.checkVariable(vmThread, "hsl", vmRootEvaluationEnvironment.getValueOf((TypedElement)asInVariable));
        this.checkVariable(vmThread, "middle", vmRootEvaluationEnvironment.getValueOf((TypedElement)asMiddleVariable));
        vmThread.stepInto();
        TestUIUtil.waitForSuspended((IThread)vmThread);
        this.checkPosition(vmThread, 20, 1022, 1030);
        this.checkVariables(vmThread, "$pc", "nodes");
        this.checkVariable(vmThread, "$pc", QVTimperativeUtil.getDefaultEntryPoint((ImperativeTransformation)asTransformation));
        vmThread.stepReturn();
        boolean hasTerminated = false;
        int i = 0;
        while (i < 10) {
            TestUIUtil.flushEvents();
            Thread.sleep(100L);
            if (vmThread.isTerminated()) {
                hasTerminated = true;
                break;
            }
            ++i;
        }
        if (!hasTerminated) {
            IStackFrame topStackFrame = vmThread.getTopStackFrame();
            IVariable[] variables = topStackFrame.getVariables();
            if (variables != null) {
                IVariable[] iVariableArray = variables;
                int n = variables.length;
                int n2 = 0;
                while (n2 < n) {
                    IVariable variable = iVariableArray[n2];
                    if ("$invalid".equals(variable.getName()) && variable instanceof VMVariable) {
                        Object valueObject = ((VMVariable)variable).getVmVar().valueObject;
                        throw (Exception)valueObject;
                    }
                    ++n2;
                }
            }
            TestCase.fail((String)"Failed to terminate");
        }
        QVTiDebuggerTests.assertEquals((int)0, (int)vm.getExitCode());
        TestUIUtil.flushEvents();
        ResourceSetImpl expectedResourceSet = new ResourceSetImpl();
        ocl.getProjectManager().initializeResourceSet((ResourceSet)expectedResourceSet);
        Resource expectedResource = expectedResourceSet.getResource(this.getModelsURI("HSV2HSL/HSLNodeValidate.xmi"), true);
        assert (expectedResource != null);
        ResourceSetImpl actualResourceSet = new ResourceSetImpl();
        Resource actualResource = actualResourceSet.getResource(outFile.getURI(), true);
        assert (actualResource != null);
        TestUtil.assertSameModel((Resource)expectedResource, (Resource)actualResource);
        ocl.dispose();
    }
}

