/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.evaluation;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformer;
import org.eclipse.qvtd.runtime.evaluation.Connection;
import org.eclipse.qvtd.runtime.evaluation.ExecutionVisitor;
import org.eclipse.qvtd.runtime.evaluation.Interval;
import org.eclipse.qvtd.runtime.evaluation.Invocation;
import org.eclipse.qvtd.runtime.evaluation.InvocationConstructor;
import org.eclipse.qvtd.runtime.evaluation.ModeFactory;
import org.eclipse.qvtd.runtime.evaluation.SlotState;
import org.eclipse.qvtd.runtime.internal.evaluation.AbstractIntervalInternal;
import org.eclipse.qvtd.runtime.internal.evaluation.AbstractInvocationInternal;

public abstract class AbstractInvocation
extends AbstractInvocationInternal {
    protected AbstractInvocation(@NonNull InvocationConstructor constructor) {
        super(constructor.getInterval());
    }

    @Override
    public <R> R accept(@NonNull ExecutionVisitor<R> visitor) {
        return visitor.visitInvocation(this);
    }

    @Override
    public @NonNull String getName() {
        return String.valueOf(this.getClass().getSimpleName()) + "\n@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(System.identityHashCode(this));
    }

    public static abstract class Incremental
    extends AbstractInvocation
    implements Invocation.Incremental {
        public static final @NonNull List<@NonNull Object> EMPTY_OBJECT_LIST = Collections.emptyList();
        public static final @NonNull List<@NonNull SlotState.Incremental> EMPTY_SLOT_LIST = Collections.emptyList();
        protected final @NonNull InvocationConstructor.Incremental constructor;
        private final int invocationHashCode;
        protected final int sequence;
        private Set<@NonNull Object> createdObjects = null;
        private Set<@NonNull SlotState.Incremental> readSlots = null;
        private Set<@NonNull SlotState.Incremental> writeSlots = null;
        private boolean isDestroyed = false;

        protected Incremental(@NonNull InvocationConstructor.Incremental constructor, int invocationHashCode) {
            super(constructor);
            this.constructor = constructor;
            this.invocationHashCode = invocationHashCode;
            this.sequence = constructor.nextSequence();
        }

        @Override
        public void addCreatedObject(@NonNull Object createdObject) {
            if (this.createdObjects == null) {
                this.createdObjects = new HashSet<Object>();
            }
            this.createdObjects.add(createdObject);
        }

        @Override
        public void addReadSlot(@NonNull SlotState.Incremental readSlot) {
            if (this.readSlots == null) {
                this.readSlots = new HashSet<SlotState.Incremental>();
            }
            this.readSlots.add(readSlot);
            readSlot.addTargetInternal(this);
        }

        @Override
        public void addWriteSlot(@NonNull SlotState.Incremental writeSlot) {
            if (this.writeSlots == null) {
                this.writeSlots = new HashSet<SlotState.Incremental>();
            }
            this.writeSlots.add(writeSlot);
            writeSlot.addSourceInternal(this);
        }

        @Deprecated
        protected @NonNull Connection createConnection(@NonNull String name, @NonNull TypeId typeId, boolean isStrict) {
            return this.createConnection(this.constructor.getInterval(), name, typeId, isStrict, ModeFactory.NON_INCREMENTAL);
        }

        protected @NonNull Connection createConnection(@NonNull Interval interval, @NonNull String name, @NonNull TypeId typeId, boolean isStrict, @NonNull ModeFactory modeFactory) {
            return interval.createConnection(name, typeId, isStrict, modeFactory);
        }

        @Deprecated
        protected @NonNull Connection.Incremental createIncrementalConnection(@NonNull String name, @NonNull TypeId typeId, boolean isStrict) {
            return (Connection.Incremental)this.createConnection(this.constructor.getInterval(), name, typeId, isStrict, ModeFactory.INCREMENTAL);
        }

        @Override
        public void destroy() {
            this.isDestroyed = true;
            ((AbstractIntervalInternal)this.interval).destroy(this);
            this.constructor.destroy(this, this.invocationHashCode);
            if (AbstractTransformer.INVOCATIONS.isActive()) {
                AbstractTransformer.INVOCATIONS.println("destroy " + this);
            }
            if (this.writeSlots != null) {
                for (SlotState.Incremental writeSlot : this.writeSlots) {
                    writeSlot.revokeAssigned();
                }
            }
            int i = 0;
            for (Connection.Incremental consumedConnection : this.constructor.getConsumedConnections()) {
                consumedConnection.revokeConsumer(this.getBoundValue(i), this);
            }
        }

        @Override
        public @NonNull InvocationConstructor.Incremental getConstructor() {
            return this.constructor;
        }

        @Override
        public @NonNull Iterable<@NonNull Object> getCreatedObjects() {
            return this.createdObjects != null ? this.createdObjects : EMPTY_OBJECT_LIST;
        }

        @Override
        public @NonNull String getName() {
            InvocationConstructor.Incremental constructor2 = this.constructor;
            return String.valueOf(constructor2 != null ? constructor2.getName() : "null") + "-" + this.sequence;
        }

        @Override
        public @NonNull Iterable<@NonNull SlotState.Incremental> getReadSlots() {
            return this.readSlots != null ? this.readSlots : EMPTY_SLOT_LIST;
        }

        @Override
        public @NonNull Iterable<@NonNull SlotState.Incremental> getWriteSlots() {
            return this.writeSlots != null ? this.writeSlots : EMPTY_SLOT_LIST;
        }

        @Override
        public void revoke() {
            if (AbstractTransformer.INVOCATIONS.isActive()) {
                AbstractTransformer.INVOCATIONS.println("revoke " + this);
            }
            if (this.writeSlots != null) {
                for (SlotState.Incremental writeSlot : this.writeSlots) {
                    writeSlot.revokeAssigned();
                }
            }
            if (!this.isDestroyed) {
                this.interval.queue(this);
            }
        }

        @Override
        public @NonNull String toString() {
            return this.getName();
        }

        @Override
        public void unblock() {
            super.unblock();
        }
    }
}

