/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.umlx.ui.launching;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.resource.BasicProjectManager;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.DefaultCompilerOptions;
import org.eclipse.qvtd.debug.QVTiDebugPlugin;
import org.eclipse.qvtd.debug.core.QVTiDebugCore;
import org.eclipse.qvtd.debug.evaluator.BasicQVTrExecutor;
import org.eclipse.qvtd.debug.launching.QVTcLaunchConstants;
import org.eclipse.qvtd.debug.launching.QVTiLaunchConfigurationDelegate;
import org.eclipse.qvtd.debug.launching.QVTrLaunchConfigurationDelegate;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperative;
import org.eclipse.qvtd.umlx.compiler.UMLXCompilerChain;
import org.eclipse.qvtd.xtext.qvtcore.QVTcoreStandaloneSetup;

public class UMLXLaunchConfigurationDelegate
extends QVTiLaunchConfigurationDelegate
implements QVTcLaunchConstants {
    public static final @NonNull String @NonNull [] compileStepKeys = QVTrLaunchConfigurationDelegate.compileStepKeys;
    public static final @NonNull String @NonNull [] generateStepKeys = QVTrLaunchConfigurationDelegate.generateStepKeys;

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        String projectName = configuration.getAttribute("project", "");
        if (projectName == null) {
            QVTiDebugPlugin.throwCoreExceptionError((String)"No default project", null);
            return false;
        }
        String txName = configuration.getAttribute("tx", null);
        if (txName == null) {
            QVTiDebugPlugin.throwCoreExceptionError((String)"No transformation to compile", null);
            return false;
        }
        URI txURI = URI.createURI((String)txName);
        String outputName = configuration.getAttribute("direction", null);
        if (outputName == null) {
            QVTiDebugPlugin.throwCoreExceptionError((String)("No output direction for '" + txURI + "'"), null);
            return false;
        }
        boolean interpreted = configuration.getAttribute("interpreted", true);
        boolean dotGraphs = configuration.getAttribute("dot-graphs", true);
        boolean yedGraphs = configuration.getAttribute("yed-graphs", true);
        QVTimperative qvt = QVTimperative.newInstance((ProjectManager)BasicProjectManager.CLASS_PATH, null);
        QVTiEnvironmentFactory environmentFactory = qvt.getEnvironmentFactory();
        QVTcoreStandaloneSetup.class.getName();
        DefaultCompilerOptions compilerOptions = this.createCompilerOptions();
        Map intermediatesMap = configuration.getAttribute("intermediates", EMPTY_MAP);
        assert (intermediatesMap != null);
        compilerOptions.setURIsFromStrings(compileStepKeys, intermediatesMap);
        compilerOptions.setDebugGraphs(dotGraphs, yedGraphs);
        if (!interpreted) {
            try {
                URI genModelURI = URI.createURI((String)((String)intermediatesMap.get("GenModel")), (boolean)true);
                URI javaURI = URI.createURI((String)((String)intermediatesMap.get("Java")), (boolean)true);
                URI classURI = URI.createURI((String)((String)intermediatesMap.get("Class")), (boolean)true);
                compilerOptions.setQVTrGenerateOptions(projectName, txURI, genModelURI, javaURI, classURI);
            }
            catch (Exception e) {
                QVTiDebugPlugin.throwCoreExceptionError((String)("Failed to configure transformation '" + txURI + "'"), (Throwable)e);
                return false;
            }
        }
        UMLXCompilerChain compilerChain = new UMLXCompilerChain(environmentFactory, txURI, txURI, (CompilerOptions)compilerOptions);
        try {
            if (interpreted) {
                compilerChain.compile(outputName);
            } else {
                compilerChain.build(outputName, new String[0]);
            }
        }
        catch (Exception e) {
            QVTiDebugPlugin.throwCoreExceptionError((String)("Failed to compile transformation '" + txURI + "'"), (Throwable)e);
            return false;
        }
        return super.buildForLaunch(configuration, mode, monitor);
    }

    protected @NonNull QVTiExecutor createExecutor(@NonNull QVTiEnvironmentFactory envFactory, @NonNull ImperativeTransformation transformation) {
        return new BasicQVTrExecutor(envFactory, transformation);
    }

    protected @NonNull QVTiDebugCore getDebugCore() {
        return QVTiDebugCore.INSTANCE;
    }

    protected @NonNull URI getTransformationURI(ILaunchConfiguration configuration) throws CoreException {
        Map intermediatesMap = configuration.getAttribute("intermediates", EMPTY_MAP);
        String qvtiName = (String)intermediatesMap.get("QVTi");
        return URI.createURI((String)qvtiName, (boolean)true);
    }
}

