/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Role;

public abstract class AbstractRole
implements Role {
    protected final @NonNull Role.Phase phase;

    protected AbstractRole(@NonNull Role.Phase phase) {
        this.phase = phase;
    }

    @Override
    public int compareTo(Role o) {
        return this.phase.compareTo(o.getPhase());
    }

    @Override
    public @NonNull String getColor() {
        switch (this.phase) {
            case CONSTANT: {
                return "black";
            }
            case LOADED: {
                return "blue";
            }
            case PREDICATED: {
                return "cyan";
            }
            case REALIZED: {
                return "green";
            }
        }
        return "grey";
    }

    @Override
    public @NonNull Role.Phase getPhase() {
        return this.phase;
    }

    @Override
    public final boolean isConstant() {
        return this.phase == Role.Phase.CONSTANT;
    }

    @Override
    public final boolean isLoaded() {
        return this.phase == Role.Phase.LOADED;
    }

    @Override
    public final boolean isPredicated() {
        return this.phase == Role.Phase.PREDICATED;
    }

    @Override
    public final boolean isRealized() {
        return this.phase == Role.Phase.REALIZED;
    }

    public String toString() {
        return (Object)((Object)this.phase) + "-" + this.getClass().getSimpleName();
    }
}

