/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.EmftvmPackage;
import org.eclipse.m2m.atl.emftvm.Instruction;
import org.eclipse.m2m.atl.emftvm.Iterate;
import org.eclipse.m2m.atl.emftvm.LineNumber;
import org.eclipse.m2m.atl.emftvm.Opcode;

public abstract class InstructionImpl
extends EObjectImpl
implements Instruction {
    protected static final Opcode OPCODE_EDEFAULT = Opcode.PUSH;
    protected Opcode opcode = OPCODE_EDEFAULT;
    protected static final int STACK_PRODUCTION_EDEFAULT = 0;
    protected int stackProduction = 0;
    protected static final int STACK_CONSUMPTION_EDEFAULT = 0;
    protected int stackConsumption = 0;
    protected static final int STACK_LEVEL_EDEFAULT = 0;
    protected int stackLevel = 0;
    protected boolean stackLevelSet;
    protected LineNumber lineNumber;

    protected InstructionImpl() {
    }

    protected EClass eStaticClass() {
        return EmftvmPackage.Literals.INSTRUCTION;
    }

    public CodeBlock getOwningBlock() {
        if (this.eContainerFeatureID() != 0) {
            return null;
        }
        return (CodeBlock)this.eInternalContainer();
    }

    public NotificationChain basicSetOwningBlock(CodeBlock newOwningBlock, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newOwningBlock, 0, msgs);
        return msgs;
    }

    public void setOwningBlock(CodeBlock newOwningBlock) {
        if (newOwningBlock != this.eInternalContainer() || this.eContainerFeatureID() != 0 && newOwningBlock != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newOwningBlock)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newOwningBlock != null) {
                msgs = ((InternalEObject)newOwningBlock).eInverseAdd((InternalEObject)this, 2, CodeBlock.class, msgs);
            }
            if ((msgs = this.basicSetOwningBlock(newOwningBlock, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)newOwningBlock, (Object)newOwningBlock));
        }
    }

    public Opcode getOpcode() {
        return this.opcode;
    }

    public int getStackProduction() {
        return this.stackProduction;
    }

    public int getStackConsumption() {
        return this.stackConsumption;
    }

    public int getStackLevel() {
        if (!this.stackLevelSet) {
            this.stackLevel = this.getStackProduction() - this.getStackConsumption();
            CodeBlock cb = this.getOwningBlock();
            if (cb != null) {
                int prevStackLevel = 0;
                EList<Instruction> code = cb.getCode();
                int index = code.indexOf((Object)this);
                EList<Instruction> nlp = cb.getNonLoopingPredecessors(this);
                for (Instruction pred : nlp) {
                    if (pred instanceof Iterate && code.indexOf((Object)pred) != index - 1) continue;
                    prevStackLevel = Math.max(prevStackLevel, pred.getStackLevel());
                }
                this.stackLevel += prevStackLevel;
            }
            this.stackLevelSet = true;
        }
        return this.stackLevel;
    }

    public LineNumber getLineNumber() {
        if (this.lineNumber != null && this.lineNumber.eIsProxy()) {
            InternalEObject oldLineNumber = (InternalEObject)this.lineNumber;
            this.lineNumber = (LineNumber)this.eResolveProxy(oldLineNumber);
            if (this.lineNumber != oldLineNumber && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)oldLineNumber, (Object)this.lineNumber));
            }
        }
        return this.lineNumber;
    }

    public LineNumber basicGetLineNumber() {
        return this.lineNumber;
    }

    public NotificationChain basicSetLineNumber(LineNumber newLineNumber, NotificationChain msgs) {
        LineNumber oldLineNumber = this.lineNumber;
        this.lineNumber = newLineNumber;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldLineNumber, (Object)newLineNumber);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setLineNumber(LineNumber newLineNumber) {
        if (newLineNumber != this.lineNumber) {
            NotificationChain msgs = null;
            if (this.lineNumber != null) {
                msgs = ((InternalEObject)this.lineNumber).eInverseRemove((InternalEObject)this, 7, LineNumber.class, msgs);
            }
            if (newLineNumber != null) {
                msgs = ((InternalEObject)newLineNumber).eInverseAdd((InternalEObject)this, 7, LineNumber.class, msgs);
            }
            if ((msgs = this.basicSetLineNumber(newLineNumber, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)newLineNumber, (Object)newLineNumber));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetOwningBlock((CodeBlock)otherEnd, msgs);
            }
            case 5: {
                if (this.lineNumber != null) {
                    msgs = ((InternalEObject)this.lineNumber).eInverseRemove((InternalEObject)this, 7, LineNumber.class, msgs);
                }
                return this.basicSetLineNumber((LineNumber)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return this.basicSetOwningBlock(null, msgs);
            }
            case 5: {
                return this.basicSetLineNumber(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 0: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 2, CodeBlock.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getOwningBlock();
            }
            case 1: {
                return this.getOpcode();
            }
            case 2: {
                return this.getStackProduction();
            }
            case 3: {
                return this.getStackConsumption();
            }
            case 4: {
                return this.getStackLevel();
            }
            case 5: {
                if (resolve) {
                    return this.getLineNumber();
                }
                return this.basicGetLineNumber();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setOwningBlock((CodeBlock)newValue);
                return;
            }
            case 5: {
                this.setLineNumber((LineNumber)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setOwningBlock(null);
                return;
            }
            case 5: {
                this.setLineNumber(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.getOwningBlock() != null;
            }
            case 1: {
                return this.opcode != OPCODE_EDEFAULT;
            }
            case 2: {
                return this.stackProduction != 0;
            }
            case 3: {
                return this.stackConsumption != 0;
            }
            case 4: {
                return this.stackLevel != 0;
            }
            case 5: {
                return this.lineNumber != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public void eNotify(Notification notification) {
        super.eNotify(notification);
        switch (notification.getFeatureID(null)) {
            case 2: {
                this.stackLevelSet = false;
            }
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer();
        if (this.getOwningBlock() != null) {
            result.append(String.format("%2d: ", this.getOwningBlock().getCode().indexOf((Object)this)));
        }
        result.append((Object)this.getOpcode());
        return result.toString();
    }
}

