/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.m2m.atl.adt.ui.AtlPreferenceConstants;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.preferences.AtlPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class AbstractPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected String[][] checkBoxModel;
    protected org.eclipse.swt.widgets.List colorList;
    protected String[][] colorListModel;
    protected ColorSelector colorSelector;
    protected AtlPreferenceStore fPreferenceeStore;
    protected String[][] textFieldModel;
    private Map<Button, String> checkBoxes = new HashMap<Button, String>();
    private SelectionListener checkBoxFieldListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            AbstractPreferencePage.this.fPreferenceeStore.setValue((String)AbstractPreferencePage.this.checkBoxes.get(button), button.getSelection());
        }
    };
    private List<SelectionListener> fMasterSlaveListeners = new ArrayList<SelectionListener>();
    private ModifyListener fTextFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.widget;
            AbstractPreferencePage.this.fPreferenceeStore.setValue((String)AbstractPreferencePage.this.textFields.get(text), text.getText());
        }
    };
    private Map<Text, String> textFields = new HashMap<Text, String>();

    public AbstractPreferencePage(String title) {
        this.setDescription(title);
        this.fPreferenceeStore = new AtlPreferenceStore(this.getPreferenceStore(), AtlPreferenceConstants.createStoreKeys());
        this.fPreferenceeStore.load();
        this.fPreferenceeStore.start();
    }

    public void dispose() {
        if (this.fPreferenceeStore != null) {
            this.fPreferenceeStore.stop();
            this.fPreferenceeStore = null;
        }
        super.dispose();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return AtlUIPlugin.getDefault().getPreferenceStore();
    }

    public IPreferenceStore getPreferenceStore() {
        return AtlUIPlugin.getDefault().getPreferenceStore();
    }

    protected void handleColorListSelection() {
        String key = this.colorListModel[this.colorList.getSelectionIndex()][1];
        this.colorSelector.setColorValue(PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceeStore, (String)key));
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        this.initializeFieldsToUserValues();
        if (this.colorListModel != null && this.colorList != null) {
            int i = 0;
            while (i < this.colorListModel.length) {
                this.colorList.add(this.colorListModel[i][0]);
                ++i;
            }
            this.colorList.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (AbstractPreferencePage.this.colorList != null && !AbstractPreferencePage.this.colorList.isDisposed()) {
                        AbstractPreferencePage.this.colorList.select(0);
                        AbstractPreferencePage.this.handleColorListSelection();
                    }
                }
            });
        }
        for (SelectionListener listener : this.fMasterSlaveListeners) {
            listener.widgetSelected(null);
        }
    }

    protected void initializeFieldsToDefaultValues() {
        String key;
        if (this.checkBoxes != null) {
            for (Button b : this.checkBoxes.keySet()) {
                key = this.checkBoxes.get(b);
                b.setSelection(this.fPreferenceeStore.getDefaultBoolean(key));
                this.fPreferenceeStore.setValue(this.checkBoxes.get(b), b.getSelection());
            }
        }
        if (this.textFields != null) {
            for (Text t : this.textFields.keySet()) {
                key = this.textFields.get(t);
                t.setText(this.fPreferenceeStore.getDefaultString(key));
                this.fPreferenceeStore.setValue(this.textFields.get(t), t.getText());
            }
        }
    }

    protected void initializeFieldsToUserValues() {
        String key;
        if (this.checkBoxes != null) {
            for (Button b : this.checkBoxes.keySet()) {
                key = this.checkBoxes.get(b);
                b.setSelection(this.fPreferenceeStore.getBoolean(key));
            }
        }
        if (this.textFields != null) {
            for (Text t : this.textFields.keySet()) {
                key = this.textFields.get(t);
                t.setText(this.fPreferenceeStore.getString(key));
            }
        }
    }

    protected Button newCheckBoxField(Composite parent, String label) {
        Button res = new Button(parent, 16416);
        res.setText(label);
        return res;
    }

    protected Button newCheckBoxField(Composite parent, String label, String key) {
        return this.newCheckBoxField(parent, label, key, this.checkBoxFieldListener);
    }

    protected Button newCheckBoxField(Composite parent, String label, String key, SelectionListener sl) {
        Button res = this.newCheckBoxField(parent, label);
        res.addSelectionListener(sl);
        this.checkBoxes.put(res, key);
        return res;
    }

    protected Control[] newColorList(Composite parent, String listLabel, String buttonLabel, final String[][] colorListModel) {
        Composite compo1 = this.newComposite(parent, 1);
        this.newLabelField(compo1, listLabel);
        Composite compo2 = this.newComposite(compo1, 2);
        this.colorList = this.newScrollList(compo2);
        this.colorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractPreferencePage.this.handleColorListSelection();
            }
        });
        Composite compo3 = this.newComposite(compo2, 2);
        this.newLabelField(compo3, buttonLabel);
        this.colorSelector = new ColorSelector(compo3);
        Button colorButton = this.colorSelector.getButton();
        colorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = AbstractPreferencePage.this.colorList.getSelectionIndex();
                String key = colorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)AbstractPreferencePage.this.fPreferenceeStore, (String)key, (RGB)AbstractPreferencePage.this.colorSelector.getColorValue());
            }
        });
        return null;
    }

    protected Composite newComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected Composite newCompositeCheckBoxes(Composite parent) {
        Composite control = this.newComposite(parent, 1);
        int i = 0;
        while (i < this.checkBoxModel.length) {
            this.newCheckBoxField(control, this.checkBoxModel[i][0], this.checkBoxModel[i][1]);
            ++i;
        }
        return control;
    }

    protected Composite newCompositeColors(Composite parent, String listLabel, String buttonLabel) {
        Composite control = this.newComposite(parent, 2);
        this.newColorList(control, listLabel, buttonLabel, this.colorListModel);
        return control;
    }

    protected Composite newCompositeTextFields(Composite parent) {
        Composite control = this.newComposite(parent, 2);
        int i = 0;
        while (i < this.textFieldModel.length) {
            this.newLabelledTextField(control, this.textFieldModel[i][0], "", Integer.parseInt(this.textFieldModel[i][2]), this.textFieldModel[i][1]);
            ++i;
        }
        return control;
    }

    protected Group newGroup(Composite parent, String text) {
        Group group = new Group(parent, 16);
        RowLayout rowlayout = new RowLayout();
        rowlayout.type = 256;
        group.setLayout((Layout)rowlayout);
        group.setText(text);
        return group;
    }

    protected Label newLabelField(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        return label;
    }

    protected Text newLabelledTextField(Composite parent, String label, String text, int limit, String key) {
        this.newLabelField(parent, label);
        return this.newTextField(parent, text, limit, key);
    }

    protected Button newPushButton(Composite parent, String text, SelectionListener sl) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.addSelectionListener(sl);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    protected Button newRadioButton(Composite parent, String text, SelectionListener sl) {
        Button button = new Button(parent, 16400);
        button.setText(text);
        button.addSelectionListener(sl);
        return button;
    }

    protected org.eclipse.swt.widgets.List newScrollList(Composite parent) {
        org.eclipse.swt.widgets.List res = new org.eclipse.swt.widgets.List(parent, 2564);
        GridData gd = new GridData(1810);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        res.setLayoutData((Object)gd);
        return res;
    }

    protected TabItem newTabItem(TabFolder parent, String text, Control control) {
        TabItem item = new TabItem(parent, 0);
        item.setText(text);
        item.setControl(control);
        return item;
    }

    protected Text newTextField(Composite parent, String text, int limit) {
        Text res = new Text(parent, 2052);
        res.setText(text);
        res.setTextLimit(limit);
        return res;
    }

    protected Text newTextField(Composite parent, String text, int limit, String key) {
        return this.newTextField(parent, text, limit, key, this.fTextFieldListener);
    }

    protected Text newTextField(Composite parent, String text, int limit, String key, ModifyListener sl) {
        Text res = this.newTextField(parent, text, limit);
        res.addModifyListener(sl);
        this.textFields.put(res, key);
        return res;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeFieldsToDefaultValues();
        if (this.colorListModel != null) {
            int i = 0;
            while (i < this.colorListModel.length) {
                PreferenceConverter.setValue((IPreferenceStore)this.fPreferenceeStore, (String)this.colorListModel[i][1], (RGB)PreferenceConverter.getDefaultColor((IPreferenceStore)this.fPreferenceeStore, (String)this.colorListModel[i][1]));
                ++i;
            }
            this.handleColorListSelection();
        }
    }

    public boolean performOk() {
        this.fPreferenceeStore.propagate();
        AtlUIPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    protected void tabForward(Composite parent) {
        Label vfiller = new Label(parent, 16384);
        GridData gridData = new GridData();
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        vfiller.setLayoutData((Object)gridData);
    }
}

