/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.m2m.atl.engine.emfvm.ASM;
import org.eclipse.m2m.atl.engine.emfvm.ASMOperation;
import org.eclipse.m2m.atl.engine.emfvm.ASMXMLReaderException;
import org.eclipse.m2m.atl.engine.emfvm.Bytecode;
import org.eclipse.m2m.atl.engine.emfvm.Messages;
import org.eclipse.m2m.atl.engine.emfvm.VMException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ASMXMLReader
extends DefaultHandler {
    private Object asmNameIndex;
    private List<String> cp = new ArrayList<String>();
    private boolean inCode;
    private ASM ret = new ASM();
    private ASMOperation currentOperation;
    private List<Bytecode> bytecodes;
    private int errors;

    public ASM read(InputStream in) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            this.errors = 0;
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(in, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            throw new VMException(null, e.getLocalizedMessage(), e);
        }
        catch (SAXException e) {
            throw new VMException(null, e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            throw new VMException(null, e.getLocalizedMessage(), e);
        }
        if (this.errors > 0) {
            throw new VMException(null, Messages.getString("ASMXMLReader.FATALERROR"));
        }
        return this.ret;
    }

    private String resolve(Object index) {
        int idx = this.toInt(index);
        return this.cp.get(idx);
    }

    private int toInt(Object s) {
        return Integer.parseInt((String)s);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        int i = 0;
        while (i < attributes.getLength()) {
            attrs.put(attributes.getQName(i), attributes.getValue(i));
            ++i;
        }
        if (qName.equals("asm")) {
            this.asmNameIndex = attrs.get("name");
            Object version = attrs.get("version");
            if (version != null) {
                this.ret.setVersion(version.toString());
            }
        } else if (!qName.equals("cp")) {
            if (qName.equals("constant")) {
                this.cp.add((String)attrs.get("value"));
            } else if (qName.equals("field")) {
                this.ret.addField(this.resolve(attrs.get("name")), this.resolve(attrs.get("type")));
            } else if (qName.equals("operation")) {
                this.currentOperation = new ASMOperation(this.ret, this.resolve(attrs.get("name")));
                this.bytecodes = new ArrayList<Bytecode>();
            } else if (qName.equals("context")) {
                this.currentOperation.setContext(this.resolve(attrs.get("type")));
            } else if (!qName.equals("parameters")) {
                if (qName.equals("parameter")) {
                    this.currentOperation.addParameter(this.resolve(attrs.get("name")), this.resolve(attrs.get("type")));
                } else if (qName.equals("code")) {
                    this.inCode = true;
                } else if (!qName.equals("linenumbertable")) {
                    if (qName.equals("lne")) {
                        this.currentOperation.addLineNumberEntry(this.resolve(attrs.get("id")), this.toInt(attrs.get("begin")), this.toInt(attrs.get("end")));
                    } else if (!qName.equals("localvariabletable")) {
                        if (qName.equals("lve")) {
                            this.currentOperation.addLocalVariableEntry(this.toInt(attrs.get("slot")), this.resolve(attrs.get("name")), this.toInt(attrs.get("begin")), this.toInt(attrs.get("end")));
                        } else if (this.inCode) {
                            if (attrs.containsKey("arg")) {
                                this.bytecodes.add(new Bytecode(qName, this.resolve(attrs.get("arg"))));
                            } else {
                                this.bytecodes.add(new Bytecode(qName));
                            }
                        }
                    }
                }
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("cp")) {
            this.ret.setName(this.resolve(this.asmNameIndex));
        } else if (qName.equals("code")) {
            this.inCode = false;
        } else if (qName.equals("operation")) {
            this.currentOperation.setBytecodes(this.bytecodes.toArray(new Bytecode[0]));
            this.ret.addOperation(this.currentOperation);
            this.currentOperation = null;
        }
    }

    public void error(SAXParseException e) {
        ++this.errors;
        throw new VMException(null, Messages.getString("ASMXMLReader.PARSINGERROR", e.getLineNumber(), e.getColumnNumber(), e.getMessage()));
    }

    public void fatalError(SAXParseException e) throws SAXParseException {
        throw new ASMXMLReaderException(Messages.getString("ASMXMLReader.PARSINGERROR", e.getLineNumber(), new Integer(e.getColumnNumber()), e.getLocalizedMessage()), e.getPublicId(), e.getSystemId(), e.getLineNumber(), e.getColumnNumber(), e);
    }
}

