/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.profiler.core;

import java.util.Observable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.profiler.core.ATLModelHandler;
import org.eclipse.m2m.atl.profiler.core.Messages;
import org.eclipse.m2m.atl.profiler.core.ProfilerModelHandler;
import org.eclipse.m2m.atl.profiler.core.exception.InterceptedLeavingStackFrameException;
import org.eclipse.m2m.atl.profiler.core.exception.NoRegisteredOperationFoundException;
import org.eclipse.m2m.atl.profiler.core.vm.IOperation;
import org.eclipse.m2m.atl.profiler.core.vm.IStackFrame;
import org.eclipse.m2m.atl.profiler.model.ATLOperation;
import org.eclipse.m2m.atl.profiler.model.ProfilingInstruction;
import org.eclipse.m2m.atl.profiler.model.ProfilingModel;
import org.eclipse.m2m.atl.profiler.model.ProfilingOperation;

public final class ATLProfiler
extends Observable {
    private static ATLProfiler instance;
    private boolean seeTreeExecution;
    private boolean seeDebugMessages;
    private boolean seeRegistry;

    private ATLProfiler() {
    }

    public static ATLProfiler getInstance() {
        if (instance == null) {
            instance = new ATLProfiler();
        }
        return instance;
    }

    public void initProfiler(EObject model) {
        ProfilerModelHandler.getInstance().init();
        ProfilerModelHandler.getInstance().setDebugMessages(this.seeDebugMessages);
        ATLModelHandler.getInstance().init();
        ATLModelHandler.getInstance().registerATLModel(model);
    }

    public void interceptEnter(IStackFrame frame) {
        IOperation sfOp = frame.getIOperation();
        String sfOpName = ATLModelHandler.getInstance().getATLName(sfOp.getName());
        ATLOperation atlOperation = ProfilerModelHandler.getInstance().getOperationRegistry().get(sfOpName);
        EObject atlElement = null;
        if (atlOperation == null) {
            atlElement = ATLModelHandler.getInstance().getATLOperationFromName(sfOpName);
        }
        ProfilerModelHandler.getInstance().newOperation(sfOpName, frame, atlOperation, atlElement);
    }

    public void interceptLeave(IStackFrame frame) {
        IOperation sfOp = frame.getIOperation();
        String sfOpName = ATLModelHandler.getInstance().getATLName(sfOp.getName());
        try {
            ProfilerModelHandler.getInstance().closeOperation(sfOpName, frame);
        }
        catch (NoRegisteredOperationFoundException e) {
            e.printStackTrace();
        }
        catch (InterceptedLeavingStackFrameException e) {
            e.printStackTrace();
        }
    }

    public void interceptStep(IStackFrame frame) {
        ProfilerModelHandler.getInstance().makeStep(frame);
    }

    public void interceptError(IStackFrame frame, String msg, Throwable e) {
        ProfilerModelHandler.getInstance().interceptError(frame, msg, e);
        ATLLogger.info((String)("\nMessage : " + msg + "\nFrame : " + frame + "\nException : " + e));
    }

    public void interceptTerminated() {
        ProfilerModelHandler.getInstance().endExecution();
        ProfilingModel profilingModel = ProfilerModelHandler.getInstance().getProfilingModel();
        this.printTreeExecution((ProfilingOperation)profilingModel, 0);
        this.setChanged();
        this.notifyObservers(profilingModel);
        this.clearChanged();
    }

    public void printProfilingSummary() {
        String total = "\n===" + Messages.getString("ATLProfiler.PROFILING") + "===\n";
        total = String.valueOf(total) + this.profilingSummary();
        if (this.seeRegistry) {
            total = String.valueOf(total) + this.registrySummary();
        }
        total = String.valueOf(total) + "\n===" + Messages.getString("ATLProfiler.PROFILING") + "===\n\n";
        ATLLogger.info((String)total);
    }

    private String profilingSummary() {
        double eta = (double)(ProfilerModelHandler.getInstance().getProfilingModel().getEndTime() - ProfilerModelHandler.getInstance().getProfilingModel().getLaunchedTime()) / 1000.0;
        String msg = String.valueOf(Messages.getString("ATLProfiler.TOTAL_INSTRUCTIONS")) + ProfilerModelHandler.getInstance().getProfilingModel().getTotalExecutedInstructions();
        msg = String.valueOf(msg) + Messages.getString("ATLProfiler.EXECUTED_IN", eta);
        return msg;
    }

    private String registrySummary() {
        String print = Messages.getString("ATLProfiler.REGISTERED_OPERATIONS");
        for (ATLOperation op : ProfilerModelHandler.getInstance().getOperationRegistry().values()) {
            print = String.valueOf(print) + Messages.getString("ATLProfiler.CALL", op.getName(), op.getCalls());
        }
        print = String.valueOf(print) + " ---------------------------- \n";
        return print;
    }

    private void printTreeExecution(ProfilingOperation operation, int i) {
        if (this.seeTreeExecution) {
            this.printBlanks(i);
            double time = (double)(operation.getEndTime() - operation.getLaunchedTime()) / 1000.0;
            ATLLogger.info((String)Messages.getString("ATLProfiler.INSTRUCTIONS", operation.getAtlInstruction().getName(), operation.getTotalExecutedInstructions(), time));
            ++i;
            for (ProfilingInstruction inst : operation.getExecutionInstructions()) {
                this.printBlanks(i);
                if (inst instanceof ProfilingOperation) {
                    this.printTreeExecution((ProfilingOperation)inst, i);
                    continue;
                }
                this.printProfiling(inst, i);
            }
        }
    }

    private void printProfiling(ProfilingInstruction inst, int i) {
        this.printBlanks(++i);
        ATLLogger.info((String)("-inst- " + inst.getContent()));
    }

    private void printBlanks(int i) {
        while (i > 0) {
            ATLLogger.info((String)" ");
            --i;
        }
    }
}

