/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.namemapping;

import org.eclipse.m2e.wtp.namemapping.FileNameMapping;
import org.eclipse.m2e.wtp.namemapping.FullFileNameMapping;
import org.eclipse.m2e.wtp.namemapping.NoVersionFileNameMapping;
import org.eclipse.m2e.wtp.namemapping.StandardFileNameMapping;

public final class FileNameMappingFactory {
    static final String STANDARD_FILE_NAME_MAPPING = "standard";
    static final String FULL_FILE_NAME_MAPPING = "full";
    static final String NO_VERSION_FILE_NAME_MAPPING = "no-version";

    private FileNameMappingFactory() {
    }

    public static FileNameMapping getDefaultFileNameMapping() {
        return new StandardFileNameMapping();
    }

    public static FileNameMapping getFileNameMapping(String nameOrClass) throws IllegalStateException {
        if (STANDARD_FILE_NAME_MAPPING.equals(nameOrClass)) {
            return FileNameMappingFactory.getDefaultFileNameMapping();
        }
        if (FULL_FILE_NAME_MAPPING.equals(nameOrClass)) {
            return new FullFileNameMapping();
        }
        if (NO_VERSION_FILE_NAME_MAPPING.equals(nameOrClass)) {
            return new NoVersionFileNameMapping();
        }
        try {
            Class<FileNameMapping> c = Class.forName(nameOrClass).asSubclass(FileNameMapping.class);
            return c.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("File name mapping implementation[" + nameOrClass + "] was not found " + e.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException("Could not instantiate file name mapping implementation[" + nameOrClass + "] make sure it has a default public constructor");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Could not access file name mapping implementation[" + nameOrClass + "] make sure it has a default public constructor");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Specified class[" + nameOrClass + "] does not implement[" + FileNameMapping.class.getName() + "]");
        }
    }
}

