/**
 * Copyright (c) 2016-2018 TypeFox and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j;

import org.eclipse.lsp4j.jsonrpc.ProtocolDraft;
import org.eclipse.lsp4j.jsonrpc.ProtocolSince;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;

/**
 * Capabilities specific to the {@code textDocument/codeLens}
 */
@SuppressWarnings("all")
public class CodeLensCapabilities extends DynamicRegistrationCapabilities {
  /**
   * Whether the client supports resolving additional code lens
   * properties via a separate {@code codeLens/resolve} request.
   */
  @ProtocolDraft
  @ProtocolSince("3.18.0")
  private CodeLensResolveSupportCapabilities resolveSupport;

  public CodeLensCapabilities() {
  }

  public CodeLensCapabilities(final Boolean dynamicRegistration) {
    super(dynamicRegistration);
  }

  /**
   * Whether the client supports resolving additional code lens
   * properties via a separate {@code codeLens/resolve} request.
   */
  @ProtocolDraft
  @ProtocolSince("3.18.0")
  public CodeLensResolveSupportCapabilities getResolveSupport() {
    return this.resolveSupport;
  }

  /**
   * Whether the client supports resolving additional code lens
   * properties via a separate {@code codeLens/resolve} request.
   */
  @ProtocolDraft
  @ProtocolSince("3.18.0")
  public void setResolveSupport(final CodeLensResolveSupportCapabilities resolveSupport) {
    this.resolveSupport = resolveSupport;
  }

  @Override
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("resolveSupport", this.resolveSupport);
    b.add("dynamicRegistration", getDynamicRegistration());
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    if (!super.equals(obj))
      return false;
    CodeLensCapabilities other = (CodeLensCapabilities) obj;
    if (this.resolveSupport == null) {
      if (other.resolveSupport != null)
        return false;
    } else if (!this.resolveSupport.equals(other.resolveSupport))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    return 31 * super.hashCode() + ((this.resolveSupport== null) ? 0 : this.resolveSupport.hashCode());
  }
}
