/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.semanticTokens;

import java.util.List;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.operations.semanticTokens.SemanticTokensDataStreamProcessor;
import org.eclipse.lsp4e.test.semanticTokens.SemanticTokensTestUtil;
import org.eclipse.lsp4e.test.utils.AbstractTest;
import org.eclipse.lsp4j.SemanticTokensLegend;
import org.eclipse.swt.custom.StyleRange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SemanticTokensDataStreamProcessorTest
extends AbstractTest {
    @Test
    public void testKeyword() {
        Document document = new Document("type foo {\n\t\n}\ntype bar extends foo {\n\t\n}\n");
        SemanticTokensDataStreamProcessor processor = new SemanticTokensDataStreamProcessor(SemanticTokensTestUtil.keywordTokenTypeMapper(SemanticTokensTestUtil.RED_TOKEN), SemanticTokensTestUtil.offsetMapper((IDocument)document));
        List<Integer> expectedStream = SemanticTokensTestUtil.keywordSemanticTokens();
        List<StyleRange> expectedStyleRanges = List.of(new StyleRange(0, 4, SemanticTokensTestUtil.RED, null), new StyleRange(15, 4, SemanticTokensTestUtil.RED, null), new StyleRange(24, 7, SemanticTokensTestUtil.RED, null));
        List styleRanges = processor.getTokensData(expectedStream, this.getSemanticTokensLegend());
        Assertions.assertEquals(expectedStyleRanges, (Object)styleRanges);
    }

    private SemanticTokensLegend getSemanticTokensLegend() {
        SemanticTokensLegend semanticTokensLegend = new SemanticTokensLegend();
        semanticTokensLegend.setTokenTypes(List.of("keyword", "other"));
        semanticTokensLegend.setTokenModifiers(List.of("obsolete"));
        return semanticTokensLegend;
    }
}

