/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.lsp4e.ConnectDocumentToLanguageServerSetupParticipant;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WorkspaceFoldersTest
extends AbstractTestWithProject {
    @BeforeEach
    public void setUp() {
        MockLanguageServer.INSTANCE.getWorkspaceService().getWorkspaceFoldersEvents().clear();
    }

    @Test
    public void testRecycleLSAfterInitialProjectGotDeletedIfWorkspaceFolders() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "");
        TestUtils.openEditor(testFile1);
        List wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile1, c -> true);
        TestUtils.waitForAndAssertCondition(5000, () -> MockLanguageServer.INSTANCE.isRunning());
        LanguageServerWrapper wrapper1 = (LanguageServerWrapper)wrappers.iterator().next();
        Assertions.assertTrue((boolean)wrapper1.isActive());
        UI.getActivePage().closeAllEditors(false);
        TestUtils.waitForAndAssertCondition(5000, () -> !MockLanguageServer.INSTANCE.isRunning());
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        this.project = TestUtils.createProject("LanguageServiceAccessorTest2" + System.currentTimeMillis());
        IFile testFile2 = TestUtils.createUniqueTestFile(this.project, "");
        TestUtils.openEditor(testFile2);
        wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile2, c -> true);
        TestUtils.waitForAndAssertCondition(5000, () -> MockLanguageServer.INSTANCE.isRunning());
        LanguageServerWrapper wrapper2 = (LanguageServerWrapper)wrappers.iterator().next();
        Assertions.assertTrue((boolean)wrapper2.isActive());
        Assertions.assertTrue((wrapper1 == wrapper2 ? 1 : 0) != 0);
    }

    @Test
    public void testPojectCreate() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "");
        TestUtils.openEditor(testFile1);
        List wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile1, c -> true);
        TestUtils.waitForAndAssertCondition(5000, () -> MockLanguageServer.INSTANCE.isRunning());
        ConnectDocumentToLanguageServerSetupParticipant.waitForAll();
        LanguageServerWrapper wrapper1 = (LanguageServerWrapper)wrappers.iterator().next();
        Assertions.assertTrue((boolean)wrapper1.isActive());
        UI.getActivePage().closeAllEditors(false);
        TestUtils.waitForAndAssertCondition(5000, () -> !MockLanguageServer.INSTANCE.isRunning());
        Path expected = Paths.get(this.project.getLocationURI());
        Assertions.assertTrue((boolean)MockLanguageServer.INSTANCE.getWorkspaceService().getWorkspaceFoldersEvents().stream().flatMap(event -> event.getEvent().getAdded().stream()).anyMatch(added -> Paths.get(URI.create(added.getUri())).equals(expected)));
    }

    @Test
    public void testProjectClose() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "");
        TestUtils.openEditor(testFile1);
        LanguageServiceAccessor.getLSWrappers((IFile)testFile1, capabilities -> true).iterator().next();
        TestUtils.waitForAndAssertCondition(5000, () -> MockLanguageServer.INSTANCE.isRunning());
        ConnectDocumentToLanguageServerSetupParticipant.waitForAll();
        TestUtils.JobSynchronizer synchronizer = new TestUtils.JobSynchronizer();
        this.project.close((IProgressMonitor)synchronizer);
        synchronizer.await();
        Path expected = Paths.get(this.project.getLocationURI());
        TestUtils.waitForAndAssertCondition(5000, () -> MockLanguageServer.INSTANCE.getWorkspaceService().getWorkspaceFoldersEvents().stream().flatMap(evt -> evt.getEvent().getRemoved().stream()).anyMatch(removed -> Paths.get(URI.create(removed.getUri())).equals(expected)));
    }

    @Test
    public void testProjectDelete() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "");
        TestUtils.openEditor(testFile1);
        List wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile1, c -> true);
        TestUtils.waitForAndAssertCondition(5000, () -> MockLanguageServer.INSTANCE.isRunning());
        ConnectDocumentToLanguageServerSetupParticipant.waitForAll();
        LanguageServerWrapper wrapper1 = (LanguageServerWrapper)wrappers.iterator().next();
        Assertions.assertTrue((boolean)wrapper1.isActive());
        Path expected = Paths.get(this.project.getLocationURI());
        TestUtils.JobSynchronizer synchronizer = new TestUtils.JobSynchronizer();
        this.project.delete(true, true, (IProgressMonitor)synchronizer);
        synchronizer.await();
        Assertions.assertTrue((boolean)MockLanguageServer.INSTANCE.getWorkspaceService().getWorkspaceFoldersEvents().stream().flatMap(event -> event.getEvent().getRemoved().stream()).anyMatch(removed -> Paths.get(URI.create(removed.getUri())).equals(expected)));
    }

    @Test
    public void testProjectReopen() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "");
        TestUtils.openEditor(testFile1);
        LanguageServiceAccessor.getLSWrappers((IFile)testFile1, capabilities -> true).iterator().next();
        TestUtils.waitForAndAssertCondition(5000, () -> MockLanguageServer.INSTANCE.isRunning());
        ConnectDocumentToLanguageServerSetupParticipant.waitForAll();
        TestUtils.JobSynchronizer synchronizer = new TestUtils.JobSynchronizer();
        this.project.close((IProgressMonitor)synchronizer);
        synchronizer.await();
        TestUtils.waitForAndAssertCondition(5000, () -> !this.project.isOpen());
        TestUtils.JobSynchronizer synchronizer2 = new TestUtils.JobSynchronizer();
        this.project.open((IProgressMonitor)synchronizer2);
        synchronizer2.await();
        TestUtils.waitForAndAssertCondition(5000, () -> this.project.isOpen());
        Path expected = Paths.get(this.project.getLocationURI());
        TestUtils.waitForAndAssertCondition(5000, () -> MockLanguageServer.INSTANCE.getWorkspaceService().getWorkspaceFoldersEvents().stream().flatMap(evt -> evt.getEvent().getAdded().stream()).anyMatch(added -> Paths.get(URI.create(added.getUri())).equals(expected)));
    }

    @Override
    public ServerCapabilities getServerCapabilities() {
        ServerCapabilities base = MockLanguageServer.defaultServerCapabilities();
        WorkspaceServerCapabilities wsc = new WorkspaceServerCapabilities();
        WorkspaceFoldersOptions wso = new WorkspaceFoldersOptions();
        wso.setSupported(Boolean.valueOf(true));
        wso.setChangeNotifications(Boolean.valueOf(true));
        wsc.setWorkspaceFolders(wso);
        base.setWorkspace(wsc);
        return base;
    }
}

