/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;

public abstract class LanguageServers<E extends LanguageServers<E>> {
    private static final @NonNull Predicate<ServerCapabilities> NO_FILTER = s -> true;
    private @NonNull Predicate<ServerCapabilities> filter = NO_FILTER;
    protected @Nullable LanguageServersRegistry.LanguageServerDefinition serverDefinition;

    public <T> @NonNull CompletableFuture<@NonNull List<@NonNull T>> collectAll(Function<LanguageServer, ? extends @NonNull CompletableFuture<T>> fn) {
        return this.collectAll((? super LanguageServerWrapper w, LanguageServer ls) -> (CompletableFuture)fn.apply((LanguageServer)ls));
    }

    public <T> @NonNull CompletableFuture<@NonNull List<@NonNull T>> collectAll(BiFunction<? super LanguageServerWrapper, LanguageServer, ? extends @NonNull CompletableFuture<T>> fn) {
        CompletableFuture<@NonNull ArrayList<E>> init = CompletableFuture.completedFuture(new ArrayList());
        return this.executeOnServers(fn).reduce(init, LanguageServers::add, LanguageServers::addAll).thenApplyAsync(Function.identity());
    }

    public <T> @NonNull List<@NonNull CompletableFuture<@Nullable T>> computeAll(Function<LanguageServer, ? extends @NonNull CompletableFuture<T>> fn) {
        return this.computeAll((? super LanguageServerWrapper w, LanguageServer ls) -> (CompletableFuture)fn.apply((LanguageServer)ls));
    }

    public <T> @NonNull List<@NonNull CompletableFuture<@Nullable T>> computeAll(BiFunction<? super LanguageServerWrapper, LanguageServer, ? extends @NonNull CompletableFuture<T>> fn) {
        return this.getServers().stream().map(cf -> cf.thenCompose(w -> w == null ? CompletableFuture.completedFuture(null) : w.executeImpl(ls -> (CompletableFuture)fn.apply((LanguageServerWrapper)w, (LanguageServer)ls)).thenApplyAsync(Function.identity()))).toList();
    }

    public <T> CompletableFuture<Optional<T>> computeFirst(Function<LanguageServer, ? extends @NonNull CompletableFuture<T>> fn) {
        return this.computeFirst((? super LanguageServerWrapper w, LanguageServer ls) -> (CompletableFuture)fn.apply((LanguageServer)ls));
    }

    public <T> CompletableFuture<Optional<T>> computeFirst(BiFunction<? super LanguageServerWrapper, LanguageServer, ? extends @NonNull CompletableFuture<T>> fn) {
        CompletableFuture result = new CompletableFuture();
        CompletableFuture.allOf((CompletableFuture[])this.executeOnServers(fn).map(cf -> cf.thenApply(t -> {
            if (!LanguageServers.isEmpty(t)) {
                result.complete(Optional.of(t));
            }
            return t;
        })).toArray(CompletableFuture[]::new)).whenComplete((v, t) -> this.completeEmptyOrWithException(result, (Throwable)t));
        return result.thenApplyAsync(Function.identity());
    }

    public @NonNull E withPreferredServer(@Nullable LanguageServersRegistry.LanguageServerDefinition serverDefinition) {
        Assert.isLegal((this.serverDefinition == null ? 1 : 0) != 0);
        this.serverDefinition = serverDefinition;
        return (E)this;
    }

    public @NonNull E withFilter(@NonNull Predicate<ServerCapabilities> filter) {
        Assert.isLegal((this.filter == NO_FILTER ? 1 : 0) != 0);
        this.filter = filter;
        return (E)this;
    }

    public @NonNull E withCapability(@NonNull Function<ServerCapabilities, Either<Boolean, ? extends Object>> serverCapabilities) {
        Assert.isLegal((this.filter == NO_FILTER ? 1 : 0) != 0);
        this.filter = f -> LSPEclipseUtils.hasCapability((Either<Boolean, ? extends Object>)((Either)serverCapabilities.apply((ServerCapabilities)f)));
        return (E)this;
    }

    public @NonNull Predicate<ServerCapabilities> getFilter() {
        return this.filter;
    }

    protected Boolean matches(@NonNull CompletableFuture<@Nullable LanguageServerWrapper> wrapperFuture) {
        try {
            return (Boolean)((CompletableFuture)wrapperFuture.thenApply(Objects::nonNull)).get(50L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            LanguageServerPlugin.logError(e);
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException e) {
            LanguageServerPlugin.logWarning("Could not get language server due to timeout after 50 milliseconds", e);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean anyMatching() {
        return this.getServers().stream().filter(this::matches).findFirst().isPresent();
    }

    /*
     * WARNING - void declaration
     */
    private static <T> boolean isEmpty(T t) {
        block2: {
            block3: {
                void c;
                if (t == null) break block2;
                T t2 = t;
                if (!(t2 instanceof Collection)) break block3;
                Collection collection = (Collection)t2;
                Collection cfr_ignored_0 = (Collection)t2;
                if (c.isEmpty()) break block2;
            }
            return false;
        }
        return true;
    }

    protected Collection<LanguageServerWrapper> order(Collection<LanguageServerWrapper> wrappers) {
        if (this.serverDefinition != null && wrappers.size() > 1) {
            ArrayList<LanguageServerWrapper> temp = new ArrayList<LanguageServerWrapper>(wrappers);
            int i = 0;
            while (i < temp.size()) {
                LanguageServerWrapper wrapper = (LanguageServerWrapper)temp.get(i);
                if (wrapper != null && wrapper.serverDefinition != null && Objects.equals(this.serverDefinition, wrapper.serverDefinition)) {
                    Collections.swap(temp, 0, i);
                    return temp;
                }
                ++i;
            }
        }
        return wrappers;
    }

    protected abstract @NonNull List<@NonNull CompletableFuture<@Nullable LanguageServerWrapper>> getServers();

    protected void computeVersion() {
    }

    public static <T> @NonNull Stream<T> streamSafely(@Nullable Collection<T> col) {
        return col == null ? Stream.of(new Object[0]) : col.stream();
    }

    private static <T> @NonNull CompletableFuture<@NonNull List<@NonNull T>> add(@NonNull CompletableFuture<? extends @NonNull List<@NonNull T>> accumulator, @NonNull CompletableFuture<@Nullable T> element) {
        return accumulator.thenCombine(element, (a, b) -> {
            if (b != null) {
                a.add(b);
            }
            return a;
        });
    }

    public static <T> @NonNull CompletableFuture<@NonNull List<T>> addAll(@NonNull CompletableFuture<@NonNull List<T>> accumulator, @NonNull CompletableFuture<@NonNull List<T>> another) {
        return accumulator.thenCombine(another, (a, b) -> {
            a.addAll(b);
            return a;
        });
    }

    private <T> @NonNull Stream<CompletableFuture<T>> executeOnServers(BiFunction<? super LanguageServerWrapper, LanguageServer, ? extends CompletableFuture<T>> fn) {
        return this.getServers().stream().map(cf -> cf.thenCompose(w -> w == null ? CompletableFuture.completedFuture(null) : w.executeImpl(ls -> (CompletableFuture)fn.apply((LanguageServerWrapper)w, (LanguageServer)ls))));
    }

    private <T> void completeEmptyOrWithException(CompletableFuture<Optional<T>> completableFuture, Throwable t) {
        if (t != null) {
            completableFuture.completeExceptionally(t);
        } else {
            completableFuture.complete(Optional.empty());
        }
    }

    public static @NonNull LanguageServerDocumentExecutor forDocument(@NonNull IDocument document) {
        return new LanguageServerDocumentExecutor(document);
    }

    public static @NonNull LanguageServerProjectExecutor forProject(IProject project) {
        return new LanguageServerProjectExecutor(project);
    }

    public static class LanguageServerDocumentExecutor
    extends LanguageServers<LanguageServerDocumentExecutor> {
        private final @NonNull IDocument document;

        protected LanguageServerDocumentExecutor(@NonNull IDocument document) {
            this.document = document;
        }

        public @NonNull IDocument getDocument() {
            return this.document;
        }

        @NonNull CompletableFuture<@Nullable LanguageServerWrapper> connect(@NonNull CompletableFuture<@Nullable LanguageServerWrapper> wrapperFuture) {
            return wrapperFuture.thenCompose(wrapper -> {
                if (wrapper != null) {
                    try {
                        CompletableFuture<LanguageServerWrapper> serverFuture = wrapper.connectDocument(this.document);
                        if (serverFuture != null) {
                            return serverFuture;
                        }
                    }
                    catch (IOException e) {
                        LanguageServerPlugin.logError(e);
                    }
                }
                return CompletableFuture.completedFuture(null);
            });
        }

        private @NonNull CompletableFuture<@Nullable LanguageServerWrapper> filter(@NonNull LanguageServerWrapper wrapper) {
            return ((CompletableFuture)wrapper.getInitializedServer().thenCompose(server -> CompletableFuture.completedFuture(server != null && this.getFilter().test(wrapper.getServerCapabilities())))).thenApply(matches -> matches != false ? wrapper : null);
        }

        @Override
        protected @NonNull List<@NonNull CompletableFuture<@Nullable LanguageServerWrapper>> getServers() {
            Collection<LanguageServerWrapper> wrappers = LanguageServiceAccessor.getLSWrappers(this.document);
            return this.order(wrappers).stream().map(this::filter).map(this::connect).toList();
        }

        @Override
        public boolean anyMatching() {
            return LanguageServiceAccessor.getLSWrappers(this.document).stream().map(this::filter).filter(this::matches).findFirst().isPresent();
        }
    }

    public static class LanguageServerProjectExecutor
    extends LanguageServers<LanguageServerProjectExecutor> {
        private final IProject project;
        private boolean restartStopped = true;

        LanguageServerProjectExecutor(IProject project) {
            this.project = project;
        }

        public @NonNull LanguageServerProjectExecutor excludeInactive() {
            this.restartStopped = false;
            return this;
        }

        @Override
        protected @NonNull List<@NonNull CompletableFuture<@Nullable LanguageServerWrapper>> getServers() {
            Collection<@NonNull LanguageServerWrapper> startedWrappers = this.order(LanguageServiceAccessor.getStartedWrappers(this.project, this.getFilter(), !this.restartStopped));
            ArrayList<@NonNull CompletableFuture<LanguageServerWrapper>> wrappers = new ArrayList<CompletableFuture<LanguageServerWrapper>>(startedWrappers.size());
            for (LanguageServerWrapper wrapper : startedWrappers) {
                wrappers.add((CompletableFuture<LanguageServerWrapper>)wrapper.getInitializedServer().thenApply(ls -> wrapper));
            }
            return wrappers;
        }
    }
}

