/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Do not edit: This file is generated by Xtext
 */
grammar InternalSetting;

options {
	superClass=AbstractInternalAntlrParser;
}

@lexer::header {
package org.eclipse.lsat.setting.teditor.parser.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;
}

@parser::header {
package org.eclipse.lsat.setting.teditor.parser.antlr.internal;

import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.parser.antlr.AntlrDatatypeRuleToken;
import org.eclipse.lsat.setting.teditor.services.SettingGrammarAccess;

}

@parser::members {

 	private SettingGrammarAccess grammarAccess;

    public InternalSettingParser(TokenStream input, SettingGrammarAccess grammarAccess) {
        this(input);
        this.grammarAccess = grammarAccess;
        registerRules(grammarAccess.getGrammar());
    }

    @Override
    protected String getFirstRuleName() {
    	return "Settings";
   	}

   	@Override
   	protected SettingGrammarAccess getGrammarAccess() {
   		return grammarAccess;
   	}

}

@rulecatch {
    catch (RecognitionException re) {
        recover(input,re);
        appendSkippedTokens();
    }
}

// Entry rule entryRuleSettings
entryRuleSettings returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSettingsRule()); }
	iv_ruleSettings=ruleSettings
	{ $current=$iv_ruleSettings.current; }
	EOF;

// Rule Settings
ruleSettings returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getSettingsAccess().getSettingsAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getSettingsAccess().getImportsImportParserRuleCall_1_0());
				}
				lv_imports_1_0=ruleImport
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getSettingsRule());
					}
					add(
						$current,
						"imports",
						lv_imports_1_0,
						"org.eclipse.lsat.setting.teditor.Setting.Import");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		(
			(
				{
					newCompositeNode(grammarAccess.getSettingsAccess().getDeclarationsDeclarationParserRuleCall_2_0());
				}
				lv_declarations_2_0=ruleDeclaration
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getSettingsRule());
					}
					add(
						$current,
						"declarations",
						lv_declarations_2_0,
						"org.eclipse.lsat.setting.teditor.Setting.Declaration");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		(
			(
				{
					newCompositeNode(grammarAccess.getSettingsAccess().getPhysicalSettingsPhysicalSettingsParserRuleCall_3_0());
				}
				lv_physicalSettings_3_0=rulePhysicalSettings
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getSettingsRule());
					}
					add(
						$current,
						"physicalSettings",
						lv_physicalSettings_3_0,
						"org.eclipse.lsat.setting.teditor.Setting.PhysicalSettings");
					afterParserOrEnumRuleCall();
				}
			)
		)*
	)
;

// Entry rule entryRuleImport
entryRuleImport returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getImportRule()); }
	iv_ruleImport=ruleImport
	{ $current=$iv_ruleImport.current; }
	EOF;

// Rule Import
ruleImport returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='import'
		{
			newLeafNode(otherlv_0, grammarAccess.getImportAccess().getImportKeyword_0());
		}
		(
			(
				lv_importURI_1_0=RULE_STRING
				{
					newLeafNode(lv_importURI_1_0, grammarAccess.getImportAccess().getImportURISTRINGTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getImportRule());
					}
					setWithLastConsumed(
						$current,
						"importURI",
						lv_importURI_1_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)
	)
;

// Entry rule entryRulePhysicalSettings
entryRulePhysicalSettings returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPhysicalSettingsRule()); }
	iv_rulePhysicalSettings=rulePhysicalSettings
	{ $current=$iv_rulePhysicalSettings.current; }
	EOF;

// Rule PhysicalSettings
rulePhysicalSettings returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getPhysicalSettingsAccess().getPhysicalSettingsAction_0(),
					$current);
			}
		)
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getPhysicalSettingsRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getPhysicalSettingsAccess().getResourceIResourceCrossReference_1_0());
				}
				ruleResourceQualifiedName
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2='.'
		{
			newLeafNode(otherlv_2, grammarAccess.getPhysicalSettingsAccess().getFullStopKeyword_2());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getPhysicalSettingsRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getPhysicalSettingsAccess().getPeripheralPeripheralCrossReference_3_0());
				}
				ruleIID
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4='{'
		{
			newLeafNode(otherlv_4, grammarAccess.getPhysicalSettingsAccess().getLeftCurlyBracketKeyword_4());
		}
		(
			otherlv_5='Timings'
			{
				newLeafNode(otherlv_5, grammarAccess.getPhysicalSettingsAccess().getTimingsKeyword_5_0());
			}
			otherlv_6='{'
			{
				newLeafNode(otherlv_6, grammarAccess.getPhysicalSettingsAccess().getLeftCurlyBracketKeyword_5_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getPhysicalSettingsAccess().getTimingSettingsTimingSettingsMapEntryParserRuleCall_5_2_0());
					}
					lv_timingSettings_7_0=ruleTimingSettingsMapEntry
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPhysicalSettingsRule());
						}
						add(
							$current,
							"timingSettings",
							lv_timingSettings_7_0,
							"org.eclipse.lsat.setting.teditor.Setting.TimingSettingsMapEntry");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			otherlv_8='}'
			{
				newLeafNode(otherlv_8, grammarAccess.getPhysicalSettingsAccess().getRightCurlyBracketKeyword_5_3());
			}
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getPhysicalSettingsAccess().getMotionSettingsMotionSettingsMapEntryParserRuleCall_6_0());
				}
				lv_motionSettings_9_0=ruleMotionSettingsMapEntry
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getPhysicalSettingsRule());
					}
					add(
						$current,
						"motionSettings",
						lv_motionSettings_9_0,
						"org.eclipse.lsat.setting.teditor.Setting.MotionSettingsMapEntry");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		(
			otherlv_10='MoveAdjustments'
			{
				newLeafNode(otherlv_10, grammarAccess.getPhysicalSettingsAccess().getMoveAdjustmentsKeyword_7_0());
			}
			otherlv_11='{'
			{
				newLeafNode(otherlv_11, grammarAccess.getPhysicalSettingsAccess().getLeftCurlyBracketKeyword_7_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getPhysicalSettingsAccess().getMoveAdjustmentsMoveAdjustmentsParserRuleCall_7_2_0());
					}
					lv_moveAdjustments_12_0=ruleMoveAdjustments
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPhysicalSettingsRule());
						}
						add(
							$current,
							"moveAdjustments",
							lv_moveAdjustments_12_0,
							"org.eclipse.lsat.setting.teditor.Setting.MoveAdjustments");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			otherlv_13='}'
			{
				newLeafNode(otherlv_13, grammarAccess.getPhysicalSettingsAccess().getRightCurlyBracketKeyword_7_3());
			}
		)?
		otherlv_14='}'
		{
			newLeafNode(otherlv_14, grammarAccess.getPhysicalSettingsAccess().getRightCurlyBracketKeyword_8());
		}
	)
;

// Entry rule entryRuleMotionSettingsMapEntry
entryRuleMotionSettingsMapEntry returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMotionSettingsMapEntryRule()); }
	iv_ruleMotionSettingsMapEntry=ruleMotionSettingsMapEntry
	{ $current=$iv_ruleMotionSettingsMapEntry.current; }
	EOF;

// Rule MotionSettingsMapEntry
ruleMotionSettingsMapEntry returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getMotionSettingsMapEntryAccess().getMotionSettingsMapEntryAction_0(),
					$current);
			}
		)
		otherlv_1='Axis'
		{
			newLeafNode(otherlv_1, grammarAccess.getMotionSettingsMapEntryAccess().getAxisKeyword_1());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getMotionSettingsMapEntryRule());
					}
				}
				otherlv_2=RULE_ID
				{
					newLeafNode(otherlv_2, grammarAccess.getMotionSettingsMapEntryAccess().getKeyAxisCrossReference_2_0());
				}
			)
		)
		otherlv_3='{'
		{
			newLeafNode(otherlv_3, grammarAccess.getMotionSettingsMapEntryAccess().getLeftCurlyBracketKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getMotionSettingsMapEntryAccess().getValueMotionSettingsParserRuleCall_4_0());
				}
				lv_value_4_0=ruleMotionSettings
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMotionSettingsMapEntryRule());
					}
					set(
						$current,
						"value",
						lv_value_4_0,
						"org.eclipse.lsat.setting.teditor.Setting.MotionSettings");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_5='}'
		{
			newLeafNode(otherlv_5, grammarAccess.getMotionSettingsMapEntryAccess().getRightCurlyBracketKeyword_5());
		}
	)
;

// Entry rule entryRuleMotionSettings
entryRuleMotionSettings returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMotionSettingsRule()); }
	iv_ruleMotionSettings=ruleMotionSettings
	{ $current=$iv_ruleMotionSettings.current; }
	EOF;

// Rule MotionSettings
ruleMotionSettings returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getMotionSettingsAccess().getMotionSettingsAction_0(),
					$current);
			}
		)
		otherlv_1='Profiles'
		{
			newLeafNode(otherlv_1, grammarAccess.getMotionSettingsAccess().getProfilesKeyword_1());
		}
		otherlv_2='{'
		{
			newLeafNode(otherlv_2, grammarAccess.getMotionSettingsAccess().getLeftCurlyBracketKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getMotionSettingsAccess().getProfileSettingsProfileSettingsMapEntryParserRuleCall_3_0());
				}
				lv_profileSettings_3_0=ruleProfileSettingsMapEntry
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMotionSettingsRule());
					}
					add(
						$current,
						"profileSettings",
						lv_profileSettings_3_0,
						"org.eclipse.lsat.setting.teditor.Setting.ProfileSettingsMapEntry");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_4='}'
		{
			newLeafNode(otherlv_4, grammarAccess.getMotionSettingsAccess().getRightCurlyBracketKeyword_4());
		}
		(
			otherlv_5='Positions'
			{
				newLeafNode(otherlv_5, grammarAccess.getMotionSettingsAccess().getPositionsKeyword_5_0());
			}
			otherlv_6='{'
			{
				newLeafNode(otherlv_6, grammarAccess.getMotionSettingsAccess().getLeftCurlyBracketKeyword_5_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getMotionSettingsAccess().getLocationSettingsLocationSettingsMapEntryParserRuleCall_5_2_0());
					}
					lv_locationSettings_7_0=ruleLocationSettingsMapEntry
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getMotionSettingsRule());
						}
						add(
							$current,
							"locationSettings",
							lv_locationSettings_7_0,
							"org.eclipse.lsat.setting.teditor.Setting.LocationSettingsMapEntry");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			otherlv_8='}'
			{
				newLeafNode(otherlv_8, grammarAccess.getMotionSettingsAccess().getRightCurlyBracketKeyword_5_3());
			}
		)?
		(
			otherlv_9='Distances'
			{
				newLeafNode(otherlv_9, grammarAccess.getMotionSettingsAccess().getDistancesKeyword_6_0());
			}
			otherlv_10='{'
			{
				newLeafNode(otherlv_10, grammarAccess.getMotionSettingsAccess().getLeftCurlyBracketKeyword_6_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getMotionSettingsAccess().getDistanceSettingsDistanceSettingsMapEntryParserRuleCall_6_2_0());
					}
					lv_distanceSettings_11_0=ruleDistanceSettingsMapEntry
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getMotionSettingsRule());
						}
						add(
							$current,
							"distanceSettings",
							lv_distanceSettings_11_0,
							"org.eclipse.lsat.setting.teditor.Setting.DistanceSettingsMapEntry");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			otherlv_12='}'
			{
				newLeafNode(otherlv_12, grammarAccess.getMotionSettingsAccess().getRightCurlyBracketKeyword_6_3());
			}
		)?
	)
;

// Entry rule entryRuleProfileSettingsMapEntry
entryRuleProfileSettingsMapEntry returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getProfileSettingsMapEntryRule()); }
	iv_ruleProfileSettingsMapEntry=ruleProfileSettingsMapEntry
	{ $current=$iv_ruleProfileSettingsMapEntry.current; }
	EOF;

// Rule ProfileSettingsMapEntry
ruleProfileSettingsMapEntry returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getProfileSettingsMapEntryRule());
					}
				}
				otherlv_0=RULE_ID
				{
					newLeafNode(otherlv_0, grammarAccess.getProfileSettingsMapEntryAccess().getKeyProfileCrossReference_0_0());
				}
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getProfileSettingsMapEntryAccess().getValueMotionProfileSettingsParserRuleCall_1_0());
				}
				lv_value_1_0=ruleMotionProfileSettings
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getProfileSettingsMapEntryRule());
					}
					set(
						$current,
						"value",
						lv_value_1_0,
						"org.eclipse.lsat.setting.teditor.Setting.MotionProfileSettings");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleLocationSettingsMapEntry
entryRuleLocationSettingsMapEntry returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLocationSettingsMapEntryRule()); }
	iv_ruleLocationSettingsMapEntry=ruleLocationSettingsMapEntry
	{ $current=$iv_ruleLocationSettingsMapEntry.current; }
	EOF;

// Rule LocationSettingsMapEntry
ruleLocationSettingsMapEntry returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getLocationSettingsMapEntryRule());
					}
				}
				otherlv_0=RULE_ID
				{
					newLeafNode(otherlv_0, grammarAccess.getLocationSettingsMapEntryAccess().getKeyPositionCrossReference_0_0());
				}
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getLocationSettingsMapEntryAccess().getValuePhysicalLocationParserRuleCall_1_0());
				}
				lv_value_1_0=rulePhysicalLocation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getLocationSettingsMapEntryRule());
					}
					set(
						$current,
						"value",
						lv_value_1_0,
						"org.eclipse.lsat.setting.teditor.Setting.PhysicalLocation");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleDistanceSettingsMapEntry
entryRuleDistanceSettingsMapEntry returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDistanceSettingsMapEntryRule()); }
	iv_ruleDistanceSettingsMapEntry=ruleDistanceSettingsMapEntry
	{ $current=$iv_ruleDistanceSettingsMapEntry.current; }
	EOF;

// Rule DistanceSettingsMapEntry
ruleDistanceSettingsMapEntry returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getDistanceSettingsMapEntryRule());
					}
				}
				otherlv_0=RULE_ID
				{
					newLeafNode(otherlv_0, grammarAccess.getDistanceSettingsMapEntryAccess().getKeyDistanceCrossReference_0_0());
				}
			)
		)
		otherlv_1='='
		{
			newLeafNode(otherlv_1, grammarAccess.getDistanceSettingsMapEntryAccess().getEqualsSignKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getDistanceSettingsMapEntryAccess().getValueExpressionParserRuleCall_2_0());
				}
				lv_value_2_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getDistanceSettingsMapEntryRule());
					}
					set(
						$current,
						"value",
						lv_value_2_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleTimingSettingsMapEntry
entryRuleTimingSettingsMapEntry returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTimingSettingsMapEntryRule()); }
	iv_ruleTimingSettingsMapEntry=ruleTimingSettingsMapEntry
	{ $current=$iv_ruleTimingSettingsMapEntry.current; }
	EOF;

// Rule TimingSettingsMapEntry
ruleTimingSettingsMapEntry returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getTimingSettingsMapEntryRule());
					}
				}
				otherlv_0=RULE_ID
				{
					newLeafNode(otherlv_0, grammarAccess.getTimingSettingsMapEntryAccess().getKeyActionTypeCrossReference_0_0());
				}
			)
		)
		otherlv_1='='
		{
			newLeafNode(otherlv_1, grammarAccess.getTimingSettingsMapEntryAccess().getEqualsSignKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getTimingSettingsMapEntryAccess().getValueTimingParserRuleCall_2_0());
				}
				lv_value_2_0=ruleTiming
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTimingSettingsMapEntryRule());
					}
					set(
						$current,
						"value",
						lv_value_2_0,
						"org.eclipse.lsat.setting.teditor.Setting.Timing");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleMoveAdjustments
entryRuleMoveAdjustments returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMoveAdjustmentsRule()); }
	iv_ruleMoveAdjustments=ruleMoveAdjustments
	{ $current=$iv_ruleMoveAdjustments.current; }
	EOF;

// Rule MoveAdjustments
ruleMoveAdjustments returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getMoveAdjustmentsAccess().getTimeDeclarationTimeDeclarationParserRuleCall_0_0());
				}
				lv_timeDeclaration_0_0=ruleTimeDeclaration
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMoveAdjustmentsRule());
					}
					set(
						$current,
						"timeDeclaration",
						lv_timeDeclaration_0_0,
						"org.eclipse.lsat.setting.teditor.Setting.TimeDeclaration");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_1='='
		{
			newLeafNode(otherlv_1, grammarAccess.getMoveAdjustmentsAccess().getEqualsSignKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getMoveAdjustmentsAccess().getAdjustExpressionExpressionParserRuleCall_2_0());
				}
				lv_adjustExpression_2_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMoveAdjustmentsRule());
					}
					set(
						$current,
						"adjustExpression",
						lv_adjustExpression_2_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_3='profile'
			{
				newLeafNode(otherlv_3, grammarAccess.getMoveAdjustmentsAccess().getProfileKeyword_3_0());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getMoveAdjustmentsRule());
						}
					}
					otherlv_4=RULE_ID
					{
						newLeafNode(otherlv_4, grammarAccess.getMoveAdjustmentsAccess().getProfileProfileCrossReference_3_1_0());
					}
				)
			)
		)?
	)
;

// Entry rule entryRuleMotionProfileSettings
entryRuleMotionProfileSettings returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMotionProfileSettingsRule()); }
	iv_ruleMotionProfileSettings=ruleMotionProfileSettings
	{ $current=$iv_ruleMotionProfileSettings.current; }
	EOF;

// Rule MotionProfileSettings
ruleMotionProfileSettings returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getMotionProfileSettingsAccess().getMotionProfileSettingsAction_0(),
					$current);
			}
		)
		(
			(
				lv_motionProfile_1_0=RULE_ID
				{
					newLeafNode(lv_motionProfile_1_0, grammarAccess.getMotionProfileSettingsAccess().getMotionProfileIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getMotionProfileSettingsRule());
					}
					setWithLastConsumed(
						$current,
						"motionProfile",
						lv_motionProfile_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)?
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getMotionProfileSettingsAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getMotionProfileSettingsAccess().getMotionArgumentsMotionArgumentsMapEntryParserRuleCall_3_0_0());
					}
					lv_motionArguments_3_0=ruleMotionArgumentsMapEntry
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getMotionProfileSettingsRule());
						}
						add(
							$current,
							"motionArguments",
							lv_motionArguments_3_0,
							"org.eclipse.lsat.setting.teditor.Setting.MotionArgumentsMapEntry");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_4=','
				{
					newLeafNode(otherlv_4, grammarAccess.getMotionProfileSettingsAccess().getCommaKeyword_3_1_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getMotionProfileSettingsAccess().getMotionArgumentsMotionArgumentsMapEntryParserRuleCall_3_1_1_0());
						}
						lv_motionArguments_5_0=ruleMotionArgumentsMapEntry
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getMotionProfileSettingsRule());
							}
							add(
								$current,
								"motionArguments",
								lv_motionArguments_5_0,
								"org.eclipse.lsat.setting.teditor.Setting.MotionArgumentsMapEntry");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		otherlv_6=')'
		{
			newLeafNode(otherlv_6, grammarAccess.getMotionProfileSettingsAccess().getRightParenthesisKeyword_4());
		}
	)
;

// Entry rule entryRuleMotionArgumentsMapEntry
entryRuleMotionArgumentsMapEntry returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMotionArgumentsMapEntryRule()); }
	iv_ruleMotionArgumentsMapEntry=ruleMotionArgumentsMapEntry
	{ $current=$iv_ruleMotionArgumentsMapEntry.current; }
	EOF;

// Rule MotionArgumentsMapEntry
ruleMotionArgumentsMapEntry returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				lv_key_0_0=RULE_ID
				{
					newLeafNode(lv_key_0_0, grammarAccess.getMotionArgumentsMapEntryAccess().getKeyIDTerminalRuleCall_0_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getMotionArgumentsMapEntryRule());
					}
					setWithLastConsumed(
						$current,
						"key",
						lv_key_0_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		otherlv_1='='
		{
			newLeafNode(otherlv_1, grammarAccess.getMotionArgumentsMapEntryAccess().getEqualsSignKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getMotionArgumentsMapEntryAccess().getValueExpressionParserRuleCall_2_0());
				}
				lv_value_2_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMotionArgumentsMapEntryRule());
					}
					set(
						$current,
						"value",
						lv_value_2_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRulePhysicalLocation
entryRulePhysicalLocation returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPhysicalLocationRule()); }
	iv_rulePhysicalLocation=rulePhysicalLocation
	{ $current=$iv_rulePhysicalLocation.current; }
	EOF;

// Rule PhysicalLocation
rulePhysicalLocation returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			otherlv_0='='
			{
				newLeafNode(otherlv_0, grammarAccess.getPhysicalLocationAccess().getEqualsSignKeyword_0_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getPhysicalLocationAccess().getDefaultExpExpressionParserRuleCall_0_1_0());
					}
					lv_defaultExp_1_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPhysicalLocationRule());
						}
						set(
							$current,
							"defaultExp",
							lv_defaultExp_1_0,
							"org.eclipse.lsat.setting.teditor.Setting.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		    |
		(
			otherlv_2='('
			{
				newLeafNode(otherlv_2, grammarAccess.getPhysicalLocationAccess().getLeftParenthesisKeyword_1_0());
			}
			(
				otherlv_3='min'
				{
					newLeafNode(otherlv_3, grammarAccess.getPhysicalLocationAccess().getMinKeyword_1_1_0());
				}
				otherlv_4='='
				{
					newLeafNode(otherlv_4, grammarAccess.getPhysicalLocationAccess().getEqualsSignKeyword_1_1_1());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getPhysicalLocationAccess().getMinExpExpressionParserRuleCall_1_1_2_0());
						}
						lv_minExp_5_0=ruleExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getPhysicalLocationRule());
							}
							set(
								$current,
								"minExp",
								lv_minExp_5_0,
								"org.eclipse.lsat.setting.teditor.Setting.Expression");
							afterParserOrEnumRuleCall();
						}
					)
				)
				otherlv_6=','
				{
					newLeafNode(otherlv_6, grammarAccess.getPhysicalLocationAccess().getCommaKeyword_1_1_3());
				}
			)?
			(
				otherlv_7='max'
				{
					newLeafNode(otherlv_7, grammarAccess.getPhysicalLocationAccess().getMaxKeyword_1_2_0());
				}
				otherlv_8='='
				{
					newLeafNode(otherlv_8, grammarAccess.getPhysicalLocationAccess().getEqualsSignKeyword_1_2_1());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getPhysicalLocationAccess().getMaxExpExpressionParserRuleCall_1_2_2_0());
						}
						lv_maxExp_9_0=ruleExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getPhysicalLocationRule());
							}
							set(
								$current,
								"maxExp",
								lv_maxExp_9_0,
								"org.eclipse.lsat.setting.teditor.Setting.Expression");
							afterParserOrEnumRuleCall();
						}
					)
				)
				otherlv_10=','
				{
					newLeafNode(otherlv_10, grammarAccess.getPhysicalLocationAccess().getCommaKeyword_1_2_3());
				}
			)?
			otherlv_11='default'
			{
				newLeafNode(otherlv_11, grammarAccess.getPhysicalLocationAccess().getDefaultKeyword_1_3());
			}
			otherlv_12='='
			{
				newLeafNode(otherlv_12, grammarAccess.getPhysicalLocationAccess().getEqualsSignKeyword_1_4());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getPhysicalLocationAccess().getDefaultExpExpressionParserRuleCall_1_5_0());
					}
					lv_defaultExp_13_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPhysicalLocationRule());
						}
						set(
							$current,
							"defaultExp",
							lv_defaultExp_13_0,
							"org.eclipse.lsat.setting.teditor.Setting.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_14=')'
			{
				newLeafNode(otherlv_14, grammarAccess.getPhysicalLocationAccess().getRightParenthesisKeyword_1_6());
			}
		)
	)
;

// Entry rule entryRuleTiming
entryRuleTiming returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTimingRule()); }
	iv_ruleTiming=ruleTiming
	{ $current=$iv_ruleTiming.current; }
	EOF;

// Rule Timing
ruleTiming returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getTimingAccess().getScalarParserRuleCall_0());
		}
		this_Scalar_0=ruleScalar
		{
			$current = $this_Scalar_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTimingAccess().getArrayParserRuleCall_1());
		}
		this_Array_1=ruleArray
		{
			$current = $this_Array_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleScalar
entryRuleScalar returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getScalarRule()); }
	iv_ruleScalar=ruleScalar
	{ $current=$iv_ruleScalar.current; }
	EOF;

// Rule Scalar
ruleScalar returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				newCompositeNode(grammarAccess.getScalarAccess().getValueExpExpressionParserRuleCall_0());
			}
			lv_valueExp_0_0=ruleExpression
			{
				if ($current==null) {
					$current = createModelElementForParent(grammarAccess.getScalarRule());
				}
				set(
					$current,
					"valueExp",
					lv_valueExp_0_0,
					"org.eclipse.lsat.setting.teditor.Setting.Expression");
				afterParserOrEnumRuleCall();
			}
		)
	)
;

// Entry rule entryRuleArray
entryRuleArray returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getArrayRule()); }
	iv_ruleArray=ruleArray
	{ $current=$iv_ruleArray.current; }
	EOF;

// Rule Array
ruleArray returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='Array'
		{
			newLeafNode(otherlv_0, grammarAccess.getArrayAccess().getArrayKeyword_0());
		}
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getArrayAccess().getLeftParenthesisKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getArrayAccess().getValuesExpExpressionParserRuleCall_2_0());
				}
				lv_valuesExp_2_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getArrayRule());
					}
					add(
						$current,
						"valuesExp",
						lv_valuesExp_2_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_3=','
			{
				newLeafNode(otherlv_3, grammarAccess.getArrayAccess().getCommaKeyword_3_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getArrayAccess().getValuesExpExpressionParserRuleCall_3_1_0());
					}
					lv_valuesExp_4_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getArrayRule());
						}
						add(
							$current,
							"valuesExp",
							lv_valuesExp_4_0,
							"org.eclipse.lsat.setting.teditor.Setting.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
		otherlv_5=')'
		{
			newLeafNode(otherlv_5, grammarAccess.getArrayAccess().getRightParenthesisKeyword_4());
		}
	)
;

// Entry rule entryRuleDeclaration
entryRuleDeclaration returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDeclarationRule()); }
	iv_ruleDeclaration=ruleDeclaration
	{ $current=$iv_ruleDeclaration.current; }
	EOF;

// Rule Declaration
ruleDeclaration returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getDeclarationAccess().getDeclarationAction_0(),
					$current);
			}
		)
		otherlv_1='val'
		{
			newLeafNode(otherlv_1, grammarAccess.getDeclarationAccess().getValKeyword_1());
		}
		(
			(
				lv_name_2_0=RULE_ID
				{
					newLeafNode(lv_name_2_0, grammarAccess.getDeclarationAccess().getNameIDTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getDeclarationRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_2_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		otherlv_3='='
		{
			newLeafNode(otherlv_3, grammarAccess.getDeclarationAccess().getEqualsSignKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getDeclarationAccess().getExpressionExpressionParserRuleCall_4_0());
				}
				lv_expression_4_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getDeclarationRule());
					}
					set(
						$current,
						"expression",
						lv_expression_4_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleTimeDeclaration
entryRuleTimeDeclaration returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTimeDeclarationRule()); }
	iv_ruleTimeDeclaration=ruleTimeDeclaration
	{ $current=$iv_ruleTimeDeclaration.current; }
	EOF;

// Rule TimeDeclaration
ruleTimeDeclaration returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			lv_name_0_0=RULE_ID
			{
				newLeafNode(lv_name_0_0, grammarAccess.getTimeDeclarationAccess().getNameIDTerminalRuleCall_0());
			}
			{
				if ($current==null) {
					$current = createModelElement(grammarAccess.getTimeDeclarationRule());
				}
				setWithLastConsumed(
					$current,
					"name",
					lv_name_0_0,
					"org.eclipse.xtext.common.Terminals.ID");
			}
		)
	)
;

// Entry rule entryRuleExpression
entryRuleExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getExpressionRule()); }
	iv_ruleExpression=ruleExpression
	{ $current=$iv_ruleExpression.current; }
	EOF;

// Rule Expression
ruleExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	{
		newCompositeNode(grammarAccess.getExpressionAccess().getPlusOrMinusParserRuleCall());
	}
	this_PlusOrMinus_0=rulePlusOrMinus
	{
		$current = $this_PlusOrMinus_0.current;
		afterParserOrEnumRuleCall();
	}
;

// Entry rule entryRulePlusOrMinus
entryRulePlusOrMinus returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPlusOrMinusRule()); }
	iv_rulePlusOrMinus=rulePlusOrMinus
	{ $current=$iv_rulePlusOrMinus.current; }
	EOF;

// Rule PlusOrMinus
rulePlusOrMinus returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getPlusOrMinusAccess().getMulOrDivOrModParserRuleCall_0());
		}
		this_MulOrDivOrMod_0=ruleMulOrDivOrMod
		{
			$current = $this_MulOrDivOrMod_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			(
				(
					(
						{
							$current = forceCreateModelElementAndSet(
								grammarAccess.getPlusOrMinusAccess().getAddLeftAction_1_0_0_0(),
								$current);
						}
					)
					otherlv_2='+'
					{
						newLeafNode(otherlv_2, grammarAccess.getPlusOrMinusAccess().getPlusSignKeyword_1_0_0_1());
					}
				)
				    |
				(
					(
						{
							$current = forceCreateModelElementAndSet(
								grammarAccess.getPlusOrMinusAccess().getSubtractLeftAction_1_0_1_0(),
								$current);
						}
					)
					otherlv_4='-'
					{
						newLeafNode(otherlv_4, grammarAccess.getPlusOrMinusAccess().getHyphenMinusKeyword_1_0_1_1());
					}
				)
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getPlusOrMinusAccess().getRightMulOrDivOrModParserRuleCall_1_1_0());
					}
					lv_right_5_0=ruleMulOrDivOrMod
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPlusOrMinusRule());
						}
						set(
							$current,
							"right",
							lv_right_5_0,
							"org.eclipse.lsat.setting.teditor.Setting.MulOrDivOrMod");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
	)
;

// Entry rule entryRuleMulOrDivOrMod
entryRuleMulOrDivOrMod returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMulOrDivOrModRule()); }
	iv_ruleMulOrDivOrMod=ruleMulOrDivOrMod
	{ $current=$iv_ruleMulOrDivOrMod.current; }
	EOF;

// Rule MulOrDivOrMod
ruleMulOrDivOrMod returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getMulOrDivOrModAccess().getPrimaryParserRuleCall_0());
		}
		this_Primary_0=rulePrimary
		{
			$current = $this_Primary_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			(
				(
					(
						{
							$current = forceCreateModelElementAndSet(
								grammarAccess.getMulOrDivOrModAccess().getMultiplyLeftAction_1_0_0_0(),
								$current);
						}
					)
					otherlv_2='*'
					{
						newLeafNode(otherlv_2, grammarAccess.getMulOrDivOrModAccess().getAsteriskKeyword_1_0_0_1());
					}
				)
				    |
				(
					(
						{
							$current = forceCreateModelElementAndSet(
								grammarAccess.getMulOrDivOrModAccess().getDivideLeftAction_1_0_1_0(),
								$current);
						}
					)
					otherlv_4='/'
					{
						newLeafNode(otherlv_4, grammarAccess.getMulOrDivOrModAccess().getSolidusKeyword_1_0_1_1());
					}
				)
				    |
				(
					(
						{
							$current = forceCreateModelElementAndSet(
								grammarAccess.getMulOrDivOrModAccess().getModuloLeftAction_1_0_2_0(),
								$current);
						}
					)
					otherlv_6='%'
					{
						newLeafNode(otherlv_6, grammarAccess.getMulOrDivOrModAccess().getPercentSignKeyword_1_0_2_1());
					}
				)
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getMulOrDivOrModAccess().getRightPrimaryParserRuleCall_1_1_0());
					}
					lv_right_7_0=rulePrimary
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getMulOrDivOrModRule());
						}
						set(
							$current,
							"right",
							lv_right_7_0,
							"org.eclipse.lsat.setting.teditor.Setting.Primary");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
	)
;

// Entry rule entryRulePrimary
entryRulePrimary returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPrimaryRule()); }
	iv_rulePrimary=rulePrimary
	{ $current=$iv_rulePrimary.current; }
	EOF;

// Rule Primary
rulePrimary returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			otherlv_0='('
			{
				newLeafNode(otherlv_0, grammarAccess.getPrimaryAccess().getLeftParenthesisKeyword_0_0());
			}
			{
				newCompositeNode(grammarAccess.getPrimaryAccess().getExpressionParserRuleCall_0_1());
			}
			this_Expression_1=ruleExpression
			{
				$current = $this_Expression_1.current;
				afterParserOrEnumRuleCall();
			}
			otherlv_2=')'
			{
				newLeafNode(otherlv_2, grammarAccess.getPrimaryAccess().getRightParenthesisKeyword_0_2());
			}
		)
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryAccess().getAtomicParserRuleCall_1());
		}
		this_Atomic_3=ruleAtomic
		{
			$current = $this_Atomic_3.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryAccess().getDistributionParserRuleCall_2());
		}
		this_Distribution_4=ruleDistribution
		{
			$current = $this_Distribution_4.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryAccess().getMathFunctionParserRuleCall_3());
		}
		this_MathFunction_5=ruleMathFunction
		{
			$current = $this_MathFunction_5.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryAccess().getTrigonometryParserRuleCall_4());
		}
		this_Trigonometry_6=ruleTrigonometry
		{
			$current = $this_Trigonometry_6.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleAtomic
entryRuleAtomic returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAtomicRule()); }
	iv_ruleAtomic=ruleAtomic
	{ $current=$iv_ruleAtomic.current; }
	EOF;

// Rule Atomic
ruleAtomic returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getAtomicAccess().getBigDecimalConstantAction_0_0(),
						$current);
				}
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getAtomicAccess().getValueEBigDecimalParserRuleCall_0_1_0());
					}
					lv_value_1_0=ruleEBigDecimal
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getAtomicRule());
						}
						set(
							$current,
							"value",
							lv_value_1_0,
							"org.eclipse.lsat.setting.teditor.Setting.EBigDecimal");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		    |
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getAtomicAccess().getDeclarationRefAction_1_0(),
						$current);
				}
			)
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getAtomicRule());
						}
					}
					otherlv_3=RULE_ID
					{
						newLeafNode(otherlv_3, grammarAccess.getAtomicAccess().getDeclarationDeclarationCrossReference_1_1_0());
					}
				)
			)
		)
	)
;

// Entry rule entryRuleMathFunction
entryRuleMathFunction returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMathFunctionRule()); }
	iv_ruleMathFunction=ruleMathFunction
	{ $current=$iv_ruleMathFunction.current; }
	EOF;

// Rule MathFunction
ruleMathFunction returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getMathFunctionAccess().getAbsExpressionParserRuleCall_0());
		}
		this_AbsExpression_0=ruleAbsExpression
		{
			$current = $this_AbsExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getMathFunctionAccess().getExpExpressionParserRuleCall_1());
		}
		this_ExpExpression_1=ruleExpExpression
		{
			$current = $this_ExpExpression_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getMathFunctionAccess().getLogExpressionParserRuleCall_2());
		}
		this_LogExpression_2=ruleLogExpression
		{
			$current = $this_LogExpression_2.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getMathFunctionAccess().getMinExpressionParserRuleCall_3());
		}
		this_MinExpression_3=ruleMinExpression
		{
			$current = $this_MinExpression_3.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getMathFunctionAccess().getMaxExpressionParserRuleCall_4());
		}
		this_MaxExpression_4=ruleMaxExpression
		{
			$current = $this_MaxExpression_4.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getMathFunctionAccess().getSqrtExpressionParserRuleCall_5());
		}
		this_SqrtExpression_5=ruleSqrtExpression
		{
			$current = $this_SqrtExpression_5.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleAbsExpression
entryRuleAbsExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAbsExpressionRule()); }
	iv_ruleAbsExpression=ruleAbsExpression
	{ $current=$iv_ruleAbsExpression.current; }
	EOF;

// Rule AbsExpression
ruleAbsExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getAbsExpressionAccess().getAbsExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='Abs'
		{
			newLeafNode(otherlv_1, grammarAccess.getAbsExpressionAccess().getAbsKeyword_1());
		}
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getAbsExpressionAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getAbsExpressionAccess().getValueExpressionParserRuleCall_3_0());
				}
				lv_value_3_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getAbsExpressionRule());
					}
					set(
						$current,
						"value",
						lv_value_3_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=')'
		{
			newLeafNode(otherlv_4, grammarAccess.getAbsExpressionAccess().getRightParenthesisKeyword_4());
		}
	)
;

// Entry rule entryRuleExpExpression
entryRuleExpExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getExpExpressionRule()); }
	iv_ruleExpExpression=ruleExpExpression
	{ $current=$iv_ruleExpExpression.current; }
	EOF;

// Rule ExpExpression
ruleExpExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getExpExpressionAccess().getExpExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='Exp'
		{
			newLeafNode(otherlv_1, grammarAccess.getExpExpressionAccess().getExpKeyword_1());
		}
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getExpExpressionAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getExpExpressionAccess().getValueExpressionParserRuleCall_3_0());
				}
				lv_value_3_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getExpExpressionRule());
					}
					set(
						$current,
						"value",
						lv_value_3_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=')'
		{
			newLeafNode(otherlv_4, grammarAccess.getExpExpressionAccess().getRightParenthesisKeyword_4());
		}
	)
;

// Entry rule entryRuleLogExpression
entryRuleLogExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLogExpressionRule()); }
	iv_ruleLogExpression=ruleLogExpression
	{ $current=$iv_ruleLogExpression.current; }
	EOF;

// Rule LogExpression
ruleLogExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getLogExpressionAccess().getLogExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='Log'
		{
			newLeafNode(otherlv_1, grammarAccess.getLogExpressionAccess().getLogKeyword_1());
		}
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getLogExpressionAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getLogExpressionAccess().getValueExpressionParserRuleCall_3_0());
				}
				lv_value_3_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getLogExpressionRule());
					}
					set(
						$current,
						"value",
						lv_value_3_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=')'
		{
			newLeafNode(otherlv_4, grammarAccess.getLogExpressionAccess().getRightParenthesisKeyword_4());
		}
	)
;

// Entry rule entryRuleMinExpression
entryRuleMinExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMinExpressionRule()); }
	iv_ruleMinExpression=ruleMinExpression
	{ $current=$iv_ruleMinExpression.current; }
	EOF;

// Rule MinExpression
ruleMinExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getMinExpressionAccess().getMinExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='Min'
		{
			newLeafNode(otherlv_1, grammarAccess.getMinExpressionAccess().getMinKeyword_1());
		}
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getMinExpressionAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getMinExpressionAccess().getAExpressionParserRuleCall_3_0());
				}
				lv_a_3_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMinExpressionRule());
					}
					set(
						$current,
						"a",
						lv_a_3_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=','
		{
			newLeafNode(otherlv_4, grammarAccess.getMinExpressionAccess().getCommaKeyword_4());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getMinExpressionAccess().getBExpressionParserRuleCall_5_0());
				}
				lv_b_5_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMinExpressionRule());
					}
					set(
						$current,
						"b",
						lv_b_5_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_6=')'
		{
			newLeafNode(otherlv_6, grammarAccess.getMinExpressionAccess().getRightParenthesisKeyword_6());
		}
	)
;

// Entry rule entryRuleMaxExpression
entryRuleMaxExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMaxExpressionRule()); }
	iv_ruleMaxExpression=ruleMaxExpression
	{ $current=$iv_ruleMaxExpression.current; }
	EOF;

// Rule MaxExpression
ruleMaxExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getMaxExpressionAccess().getMaxExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='Max'
		{
			newLeafNode(otherlv_1, grammarAccess.getMaxExpressionAccess().getMaxKeyword_1());
		}
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getMaxExpressionAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getMaxExpressionAccess().getAExpressionParserRuleCall_3_0());
				}
				lv_a_3_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMaxExpressionRule());
					}
					set(
						$current,
						"a",
						lv_a_3_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=','
		{
			newLeafNode(otherlv_4, grammarAccess.getMaxExpressionAccess().getCommaKeyword_4());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getMaxExpressionAccess().getBExpressionParserRuleCall_5_0());
				}
				lv_b_5_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMaxExpressionRule());
					}
					set(
						$current,
						"b",
						lv_b_5_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_6=')'
		{
			newLeafNode(otherlv_6, grammarAccess.getMaxExpressionAccess().getRightParenthesisKeyword_6());
		}
	)
;

// Entry rule entryRuleSqrtExpression
entryRuleSqrtExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSqrtExpressionRule()); }
	iv_ruleSqrtExpression=ruleSqrtExpression
	{ $current=$iv_ruleSqrtExpression.current; }
	EOF;

// Rule SqrtExpression
ruleSqrtExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getSqrtExpressionAccess().getSqrtExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='Sqrt'
		{
			newLeafNode(otherlv_1, grammarAccess.getSqrtExpressionAccess().getSqrtKeyword_1());
		}
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getSqrtExpressionAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getSqrtExpressionAccess().getValueExpressionParserRuleCall_3_0());
				}
				lv_value_3_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getSqrtExpressionRule());
					}
					set(
						$current,
						"value",
						lv_value_3_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=')'
		{
			newLeafNode(otherlv_4, grammarAccess.getSqrtExpressionAccess().getRightParenthesisKeyword_4());
		}
	)
;

// Entry rule entryRuleTrigonometry
entryRuleTrigonometry returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTrigonometryRule()); }
	iv_ruleTrigonometry=ruleTrigonometry
	{ $current=$iv_ruleTrigonometry.current; }
	EOF;

// Rule Trigonometry
ruleTrigonometry returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getTrigonometryAccess().getSinExpressionParserRuleCall_0());
		}
		this_SinExpression_0=ruleSinExpression
		{
			$current = $this_SinExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTrigonometryAccess().getCosExpressionParserRuleCall_1());
		}
		this_CosExpression_1=ruleCosExpression
		{
			$current = $this_CosExpression_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTrigonometryAccess().getTanExpressionParserRuleCall_2());
		}
		this_TanExpression_2=ruleTanExpression
		{
			$current = $this_TanExpression_2.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTrigonometryAccess().getAsinExpressionParserRuleCall_3());
		}
		this_AsinExpression_3=ruleAsinExpression
		{
			$current = $this_AsinExpression_3.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTrigonometryAccess().getAcosExpressionParserRuleCall_4());
		}
		this_AcosExpression_4=ruleAcosExpression
		{
			$current = $this_AcosExpression_4.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTrigonometryAccess().getAtanExpressionParserRuleCall_5());
		}
		this_AtanExpression_5=ruleAtanExpression
		{
			$current = $this_AtanExpression_5.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTrigonometryAccess().getAtan2ExpressionParserRuleCall_6());
		}
		this_Atan2Expression_6=ruleAtan2Expression
		{
			$current = $this_Atan2Expression_6.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTrigonometryAccess().getPiConstantParserRuleCall_7());
		}
		this_PiConstant_7=rulePiConstant
		{
			$current = $this_PiConstant_7.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleSinExpression
entryRuleSinExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSinExpressionRule()); }
	iv_ruleSinExpression=ruleSinExpression
	{ $current=$iv_ruleSinExpression.current; }
	EOF;

// Rule SinExpression
ruleSinExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getSinExpressionAccess().getSinExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='Sin'
		{
			newLeafNode(otherlv_1, grammarAccess.getSinExpressionAccess().getSinKeyword_1());
		}
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getSinExpressionAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getSinExpressionAccess().getValueExpressionParserRuleCall_3_0());
				}
				lv_value_3_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getSinExpressionRule());
					}
					set(
						$current,
						"value",
						lv_value_3_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=')'
		{
			newLeafNode(otherlv_4, grammarAccess.getSinExpressionAccess().getRightParenthesisKeyword_4());
		}
	)
;

// Entry rule entryRuleCosExpression
entryRuleCosExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getCosExpressionRule()); }
	iv_ruleCosExpression=ruleCosExpression
	{ $current=$iv_ruleCosExpression.current; }
	EOF;

// Rule CosExpression
ruleCosExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getCosExpressionAccess().getCosExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='Cos'
		{
			newLeafNode(otherlv_1, grammarAccess.getCosExpressionAccess().getCosKeyword_1());
		}
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getCosExpressionAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getCosExpressionAccess().getValueExpressionParserRuleCall_3_0());
				}
				lv_value_3_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getCosExpressionRule());
					}
					set(
						$current,
						"value",
						lv_value_3_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=')'
		{
			newLeafNode(otherlv_4, grammarAccess.getCosExpressionAccess().getRightParenthesisKeyword_4());
		}
	)
;

// Entry rule entryRuleTanExpression
entryRuleTanExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTanExpressionRule()); }
	iv_ruleTanExpression=ruleTanExpression
	{ $current=$iv_ruleTanExpression.current; }
	EOF;

// Rule TanExpression
ruleTanExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getTanExpressionAccess().getTanExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='Tan'
		{
			newLeafNode(otherlv_1, grammarAccess.getTanExpressionAccess().getTanKeyword_1());
		}
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getTanExpressionAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getTanExpressionAccess().getValueExpressionParserRuleCall_3_0());
				}
				lv_value_3_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTanExpressionRule());
					}
					set(
						$current,
						"value",
						lv_value_3_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=')'
		{
			newLeafNode(otherlv_4, grammarAccess.getTanExpressionAccess().getRightParenthesisKeyword_4());
		}
	)
;

// Entry rule entryRuleAsinExpression
entryRuleAsinExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAsinExpressionRule()); }
	iv_ruleAsinExpression=ruleAsinExpression
	{ $current=$iv_ruleAsinExpression.current; }
	EOF;

// Rule AsinExpression
ruleAsinExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getAsinExpressionAccess().getAsinExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='Asin'
		{
			newLeafNode(otherlv_1, grammarAccess.getAsinExpressionAccess().getAsinKeyword_1());
		}
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getAsinExpressionAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getAsinExpressionAccess().getValueExpressionParserRuleCall_3_0());
				}
				lv_value_3_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getAsinExpressionRule());
					}
					set(
						$current,
						"value",
						lv_value_3_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=')'
		{
			newLeafNode(otherlv_4, grammarAccess.getAsinExpressionAccess().getRightParenthesisKeyword_4());
		}
	)
;

// Entry rule entryRuleAcosExpression
entryRuleAcosExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAcosExpressionRule()); }
	iv_ruleAcosExpression=ruleAcosExpression
	{ $current=$iv_ruleAcosExpression.current; }
	EOF;

// Rule AcosExpression
ruleAcosExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getAcosExpressionAccess().getAcosExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='Acos'
		{
			newLeafNode(otherlv_1, grammarAccess.getAcosExpressionAccess().getAcosKeyword_1());
		}
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getAcosExpressionAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getAcosExpressionAccess().getValueExpressionParserRuleCall_3_0());
				}
				lv_value_3_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getAcosExpressionRule());
					}
					set(
						$current,
						"value",
						lv_value_3_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=')'
		{
			newLeafNode(otherlv_4, grammarAccess.getAcosExpressionAccess().getRightParenthesisKeyword_4());
		}
	)
;

// Entry rule entryRuleAtanExpression
entryRuleAtanExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAtanExpressionRule()); }
	iv_ruleAtanExpression=ruleAtanExpression
	{ $current=$iv_ruleAtanExpression.current; }
	EOF;

// Rule AtanExpression
ruleAtanExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getAtanExpressionAccess().getAtanExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='Atan'
		{
			newLeafNode(otherlv_1, grammarAccess.getAtanExpressionAccess().getAtanKeyword_1());
		}
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getAtanExpressionAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getAtanExpressionAccess().getValueExpressionParserRuleCall_3_0());
				}
				lv_value_3_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getAtanExpressionRule());
					}
					set(
						$current,
						"value",
						lv_value_3_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=')'
		{
			newLeafNode(otherlv_4, grammarAccess.getAtanExpressionAccess().getRightParenthesisKeyword_4());
		}
	)
;

// Entry rule entryRuleAtan2Expression
entryRuleAtan2Expression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAtan2ExpressionRule()); }
	iv_ruleAtan2Expression=ruleAtan2Expression
	{ $current=$iv_ruleAtan2Expression.current; }
	EOF;

// Rule Atan2Expression
ruleAtan2Expression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getAtan2ExpressionAccess().getAtan2ExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='Atan2'
		{
			newLeafNode(otherlv_1, grammarAccess.getAtan2ExpressionAccess().getAtan2Keyword_1());
		}
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getAtan2ExpressionAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getAtan2ExpressionAccess().getYExpressionParserRuleCall_3_0());
				}
				lv_y_3_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getAtan2ExpressionRule());
					}
					set(
						$current,
						"y",
						lv_y_3_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=','
		{
			newLeafNode(otherlv_4, grammarAccess.getAtan2ExpressionAccess().getCommaKeyword_4());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getAtan2ExpressionAccess().getXExpressionParserRuleCall_5_0());
				}
				lv_x_5_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getAtan2ExpressionRule());
					}
					set(
						$current,
						"x",
						lv_x_5_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_6=')'
		{
			newLeafNode(otherlv_6, grammarAccess.getAtan2ExpressionAccess().getRightParenthesisKeyword_6());
		}
	)
;

// Entry rule entryRulePiConstant
entryRulePiConstant returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPiConstantRule()); }
	iv_rulePiConstant=rulePiConstant
	{ $current=$iv_rulePiConstant.current; }
	EOF;

// Rule PiConstant
rulePiConstant returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getPiConstantAccess().getPiConstantAction_0(),
					$current);
			}
		)
		otherlv_1='Pi'
		{
			newLeafNode(otherlv_1, grammarAccess.getPiConstantAccess().getPiKeyword_1());
		}
	)
;

// Entry rule entryRuleDistribution
entryRuleDistribution returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDistributionRule()); }
	iv_ruleDistribution=ruleDistribution
	{ $current=$iv_ruleDistribution.current; }
	EOF;

// Rule Distribution
ruleDistribution returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getDistributionAccess().getTriangularDistributionParserRuleCall_0());
		}
		this_TriangularDistribution_0=ruleTriangularDistribution
		{
			$current = $this_TriangularDistribution_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getDistributionAccess().getPertDistributionParserRuleCall_1());
		}
		this_PertDistribution_1=rulePertDistribution
		{
			$current = $this_PertDistribution_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getDistributionAccess().getNormalDistributionParserRuleCall_2());
		}
		this_NormalDistribution_2=ruleNormalDistribution
		{
			$current = $this_NormalDistribution_2.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getDistributionAccess().getEnumeratedDistributionParserRuleCall_3());
		}
		this_EnumeratedDistribution_3=ruleEnumeratedDistribution
		{
			$current = $this_EnumeratedDistribution_3.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getDistributionAccess().getGammaDistributionParserRuleCall_4());
		}
		this_GammaDistribution_4=ruleGammaDistribution
		{
			$current = $this_GammaDistribution_4.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getDistributionAccess().getPoissonDistributionParserRuleCall_5());
		}
		this_PoissonDistribution_5=rulePoissonDistribution
		{
			$current = $this_PoissonDistribution_5.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getDistributionAccess().getLogNormalDistributionParserRuleCall_6());
		}
		this_LogNormalDistribution_6=ruleLogNormalDistribution
		{
			$current = $this_LogNormalDistribution_6.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleTriangularDistribution
entryRuleTriangularDistribution returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTriangularDistributionRule()); }
	iv_ruleTriangularDistribution=ruleTriangularDistribution
	{ $current=$iv_ruleTriangularDistribution.current; }
	EOF;

// Rule TriangularDistribution
ruleTriangularDistribution returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='Triangular'
		{
			newLeafNode(otherlv_0, grammarAccess.getTriangularDistributionAccess().getTriangularKeyword_0());
		}
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getTriangularDistributionAccess().getLeftParenthesisKeyword_1());
		}
		otherlv_2='min'
		{
			newLeafNode(otherlv_2, grammarAccess.getTriangularDistributionAccess().getMinKeyword_2());
		}
		otherlv_3='='
		{
			newLeafNode(otherlv_3, grammarAccess.getTriangularDistributionAccess().getEqualsSignKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getTriangularDistributionAccess().getMinExpExpressionParserRuleCall_4_0());
				}
				lv_minExp_4_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTriangularDistributionRule());
					}
					set(
						$current,
						"minExp",
						lv_minExp_4_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_5=','
		{
			newLeafNode(otherlv_5, grammarAccess.getTriangularDistributionAccess().getCommaKeyword_5());
		}
		otherlv_6='max'
		{
			newLeafNode(otherlv_6, grammarAccess.getTriangularDistributionAccess().getMaxKeyword_6());
		}
		otherlv_7='='
		{
			newLeafNode(otherlv_7, grammarAccess.getTriangularDistributionAccess().getEqualsSignKeyword_7());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getTriangularDistributionAccess().getMaxExpExpressionParserRuleCall_8_0());
				}
				lv_maxExp_8_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTriangularDistributionRule());
					}
					set(
						$current,
						"maxExp",
						lv_maxExp_8_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_9=','
		{
			newLeafNode(otherlv_9, grammarAccess.getTriangularDistributionAccess().getCommaKeyword_9());
		}
		otherlv_10='mode'
		{
			newLeafNode(otherlv_10, grammarAccess.getTriangularDistributionAccess().getModeKeyword_10());
		}
		otherlv_11='='
		{
			newLeafNode(otherlv_11, grammarAccess.getTriangularDistributionAccess().getEqualsSignKeyword_11());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getTriangularDistributionAccess().getModeExpExpressionParserRuleCall_12_0());
				}
				lv_modeExp_12_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTriangularDistributionRule());
					}
					set(
						$current,
						"modeExp",
						lv_modeExp_12_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_13=','
			{
				newLeafNode(otherlv_13, grammarAccess.getTriangularDistributionAccess().getCommaKeyword_13_0());
			}
			otherlv_14='default'
			{
				newLeafNode(otherlv_14, grammarAccess.getTriangularDistributionAccess().getDefaultKeyword_13_1());
			}
			otherlv_15='='
			{
				newLeafNode(otherlv_15, grammarAccess.getTriangularDistributionAccess().getEqualsSignKeyword_13_2());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getTriangularDistributionAccess().getDefaultExpExpressionParserRuleCall_13_3_0());
					}
					lv_defaultExp_16_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getTriangularDistributionRule());
						}
						set(
							$current,
							"defaultExp",
							lv_defaultExp_16_0,
							"org.eclipse.lsat.setting.teditor.Setting.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		otherlv_17=')'
		{
			newLeafNode(otherlv_17, grammarAccess.getTriangularDistributionAccess().getRightParenthesisKeyword_14());
		}
	)
;

// Entry rule entryRulePertDistribution
entryRulePertDistribution returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPertDistributionRule()); }
	iv_rulePertDistribution=rulePertDistribution
	{ $current=$iv_rulePertDistribution.current; }
	EOF;

// Rule PertDistribution
rulePertDistribution returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='Pert'
		{
			newLeafNode(otherlv_0, grammarAccess.getPertDistributionAccess().getPertKeyword_0());
		}
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getPertDistributionAccess().getLeftParenthesisKeyword_1());
		}
		otherlv_2='min'
		{
			newLeafNode(otherlv_2, grammarAccess.getPertDistributionAccess().getMinKeyword_2());
		}
		otherlv_3='='
		{
			newLeafNode(otherlv_3, grammarAccess.getPertDistributionAccess().getEqualsSignKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getPertDistributionAccess().getMinExpExpressionParserRuleCall_4_0());
				}
				lv_minExp_4_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getPertDistributionRule());
					}
					set(
						$current,
						"minExp",
						lv_minExp_4_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_5=','
		{
			newLeafNode(otherlv_5, grammarAccess.getPertDistributionAccess().getCommaKeyword_5());
		}
		otherlv_6='max'
		{
			newLeafNode(otherlv_6, grammarAccess.getPertDistributionAccess().getMaxKeyword_6());
		}
		otherlv_7='='
		{
			newLeafNode(otherlv_7, grammarAccess.getPertDistributionAccess().getEqualsSignKeyword_7());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getPertDistributionAccess().getMaxExpExpressionParserRuleCall_8_0());
				}
				lv_maxExp_8_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getPertDistributionRule());
					}
					set(
						$current,
						"maxExp",
						lv_maxExp_8_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_9=','
		{
			newLeafNode(otherlv_9, grammarAccess.getPertDistributionAccess().getCommaKeyword_9());
		}
		otherlv_10='mode'
		{
			newLeafNode(otherlv_10, grammarAccess.getPertDistributionAccess().getModeKeyword_10());
		}
		otherlv_11='='
		{
			newLeafNode(otherlv_11, grammarAccess.getPertDistributionAccess().getEqualsSignKeyword_11());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getPertDistributionAccess().getModeExpExpressionParserRuleCall_12_0());
				}
				lv_modeExp_12_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getPertDistributionRule());
					}
					set(
						$current,
						"modeExp",
						lv_modeExp_12_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_13=','
		{
			newLeafNode(otherlv_13, grammarAccess.getPertDistributionAccess().getCommaKeyword_13());
		}
		otherlv_14='gamma'
		{
			newLeafNode(otherlv_14, grammarAccess.getPertDistributionAccess().getGammaKeyword_14());
		}
		otherlv_15='='
		{
			newLeafNode(otherlv_15, grammarAccess.getPertDistributionAccess().getEqualsSignKeyword_15());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getPertDistributionAccess().getGammaExpExpressionParserRuleCall_16_0());
				}
				lv_gammaExp_16_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getPertDistributionRule());
					}
					set(
						$current,
						"gammaExp",
						lv_gammaExp_16_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_17=','
			{
				newLeafNode(otherlv_17, grammarAccess.getPertDistributionAccess().getCommaKeyword_17_0());
			}
			otherlv_18='default'
			{
				newLeafNode(otherlv_18, grammarAccess.getPertDistributionAccess().getDefaultKeyword_17_1());
			}
			otherlv_19='='
			{
				newLeafNode(otherlv_19, grammarAccess.getPertDistributionAccess().getEqualsSignKeyword_17_2());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getPertDistributionAccess().getDefaultExpExpressionParserRuleCall_17_3_0());
					}
					lv_defaultExp_20_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPertDistributionRule());
						}
						set(
							$current,
							"defaultExp",
							lv_defaultExp_20_0,
							"org.eclipse.lsat.setting.teditor.Setting.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		otherlv_21=')'
		{
			newLeafNode(otherlv_21, grammarAccess.getPertDistributionAccess().getRightParenthesisKeyword_18());
		}
	)
;

// Entry rule entryRuleNormalDistribution
entryRuleNormalDistribution returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getNormalDistributionRule()); }
	iv_ruleNormalDistribution=ruleNormalDistribution
	{ $current=$iv_ruleNormalDistribution.current; }
	EOF;

// Rule NormalDistribution
ruleNormalDistribution returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='Normal'
		{
			newLeafNode(otherlv_0, grammarAccess.getNormalDistributionAccess().getNormalKeyword_0());
		}
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getNormalDistributionAccess().getLeftParenthesisKeyword_1());
		}
		otherlv_2='mean'
		{
			newLeafNode(otherlv_2, grammarAccess.getNormalDistributionAccess().getMeanKeyword_2());
		}
		otherlv_3='='
		{
			newLeafNode(otherlv_3, grammarAccess.getNormalDistributionAccess().getEqualsSignKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getNormalDistributionAccess().getMeanExpExpressionParserRuleCall_4_0());
				}
				lv_meanExp_4_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getNormalDistributionRule());
					}
					set(
						$current,
						"meanExp",
						lv_meanExp_4_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_5=','
		{
			newLeafNode(otherlv_5, grammarAccess.getNormalDistributionAccess().getCommaKeyword_5());
		}
		otherlv_6='sd'
		{
			newLeafNode(otherlv_6, grammarAccess.getNormalDistributionAccess().getSdKeyword_6());
		}
		otherlv_7='='
		{
			newLeafNode(otherlv_7, grammarAccess.getNormalDistributionAccess().getEqualsSignKeyword_7());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getNormalDistributionAccess().getSdExpExpressionParserRuleCall_8_0());
				}
				lv_sdExp_8_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getNormalDistributionRule());
					}
					set(
						$current,
						"sdExp",
						lv_sdExp_8_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_9=','
			{
				newLeafNode(otherlv_9, grammarAccess.getNormalDistributionAccess().getCommaKeyword_9_0());
			}
			otherlv_10='default'
			{
				newLeafNode(otherlv_10, grammarAccess.getNormalDistributionAccess().getDefaultKeyword_9_1());
			}
			otherlv_11='='
			{
				newLeafNode(otherlv_11, grammarAccess.getNormalDistributionAccess().getEqualsSignKeyword_9_2());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getNormalDistributionAccess().getDefaultExpExpressionParserRuleCall_9_3_0());
					}
					lv_defaultExp_12_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getNormalDistributionRule());
						}
						set(
							$current,
							"defaultExp",
							lv_defaultExp_12_0,
							"org.eclipse.lsat.setting.teditor.Setting.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		otherlv_13=')'
		{
			newLeafNode(otherlv_13, grammarAccess.getNormalDistributionAccess().getRightParenthesisKeyword_10());
		}
	)
;

// Entry rule entryRuleEnumeratedDistribution
entryRuleEnumeratedDistribution returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEnumeratedDistributionRule()); }
	iv_ruleEnumeratedDistribution=ruleEnumeratedDistribution
	{ $current=$iv_ruleEnumeratedDistribution.current; }
	EOF;

// Rule EnumeratedDistribution
ruleEnumeratedDistribution returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='Enumerated'
		{
			newLeafNode(otherlv_0, grammarAccess.getEnumeratedDistributionAccess().getEnumeratedKeyword_0());
		}
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getEnumeratedDistributionAccess().getLeftParenthesisKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEnumeratedDistributionAccess().getValuesExpExpressionParserRuleCall_2_0());
				}
				lv_valuesExp_2_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEnumeratedDistributionRule());
					}
					add(
						$current,
						"valuesExp",
						lv_valuesExp_2_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_3=','
			{
				newLeafNode(otherlv_3, grammarAccess.getEnumeratedDistributionAccess().getCommaKeyword_3_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getEnumeratedDistributionAccess().getValuesExpExpressionParserRuleCall_3_1_0());
					}
					lv_valuesExp_4_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getEnumeratedDistributionRule());
						}
						add(
							$current,
							"valuesExp",
							lv_valuesExp_4_0,
							"org.eclipse.lsat.setting.teditor.Setting.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
		(
			otherlv_5=','
			{
				newLeafNode(otherlv_5, grammarAccess.getEnumeratedDistributionAccess().getCommaKeyword_4_0());
			}
			otherlv_6='default'
			{
				newLeafNode(otherlv_6, grammarAccess.getEnumeratedDistributionAccess().getDefaultKeyword_4_1());
			}
			otherlv_7='='
			{
				newLeafNode(otherlv_7, grammarAccess.getEnumeratedDistributionAccess().getEqualsSignKeyword_4_2());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getEnumeratedDistributionAccess().getDefaultExpExpressionParserRuleCall_4_3_0());
					}
					lv_defaultExp_8_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getEnumeratedDistributionRule());
						}
						set(
							$current,
							"defaultExp",
							lv_defaultExp_8_0,
							"org.eclipse.lsat.setting.teditor.Setting.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		otherlv_9=')'
		{
			newLeafNode(otherlv_9, grammarAccess.getEnumeratedDistributionAccess().getRightParenthesisKeyword_5());
		}
	)
;

// Entry rule entryRuleGammaDistribution
entryRuleGammaDistribution returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getGammaDistributionRule()); }
	iv_ruleGammaDistribution=ruleGammaDistribution
	{ $current=$iv_ruleGammaDistribution.current; }
	EOF;

// Rule GammaDistribution
ruleGammaDistribution returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='Gamma'
		{
			newLeafNode(otherlv_0, grammarAccess.getGammaDistributionAccess().getGammaKeyword_0());
		}
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getGammaDistributionAccess().getLeftParenthesisKeyword_1());
		}
		otherlv_2='scale'
		{
			newLeafNode(otherlv_2, grammarAccess.getGammaDistributionAccess().getScaleKeyword_2());
		}
		otherlv_3='='
		{
			newLeafNode(otherlv_3, grammarAccess.getGammaDistributionAccess().getEqualsSignKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getGammaDistributionAccess().getScaleExpExpressionParserRuleCall_4_0());
				}
				lv_scaleExp_4_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getGammaDistributionRule());
					}
					set(
						$current,
						"scaleExp",
						lv_scaleExp_4_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_5=','
		{
			newLeafNode(otherlv_5, grammarAccess.getGammaDistributionAccess().getCommaKeyword_5());
		}
		otherlv_6='shape'
		{
			newLeafNode(otherlv_6, grammarAccess.getGammaDistributionAccess().getShapeKeyword_6());
		}
		otherlv_7='='
		{
			newLeafNode(otherlv_7, grammarAccess.getGammaDistributionAccess().getEqualsSignKeyword_7());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getGammaDistributionAccess().getShapeExpExpressionParserRuleCall_8_0());
				}
				lv_shapeExp_8_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getGammaDistributionRule());
					}
					set(
						$current,
						"shapeExp",
						lv_shapeExp_8_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_9=','
			{
				newLeafNode(otherlv_9, grammarAccess.getGammaDistributionAccess().getCommaKeyword_9_0());
			}
			otherlv_10='inverseCumAccuracy'
			{
				newLeafNode(otherlv_10, grammarAccess.getGammaDistributionAccess().getInverseCumAccuracyKeyword_9_1());
			}
			otherlv_11='='
			{
				newLeafNode(otherlv_11, grammarAccess.getGammaDistributionAccess().getEqualsSignKeyword_9_2());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getGammaDistributionAccess().getInverseCumAccuracyExpExpressionParserRuleCall_9_3_0());
					}
					lv_inverseCumAccuracyExp_12_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getGammaDistributionRule());
						}
						set(
							$current,
							"inverseCumAccuracyExp",
							lv_inverseCumAccuracyExp_12_0,
							"org.eclipse.lsat.setting.teditor.Setting.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		(
			otherlv_13=','
			{
				newLeafNode(otherlv_13, grammarAccess.getGammaDistributionAccess().getCommaKeyword_10_0());
			}
			otherlv_14='default'
			{
				newLeafNode(otherlv_14, grammarAccess.getGammaDistributionAccess().getDefaultKeyword_10_1());
			}
			otherlv_15='='
			{
				newLeafNode(otherlv_15, grammarAccess.getGammaDistributionAccess().getEqualsSignKeyword_10_2());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getGammaDistributionAccess().getDefaultExpExpressionParserRuleCall_10_3_0());
					}
					lv_defaultExp_16_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getGammaDistributionRule());
						}
						set(
							$current,
							"defaultExp",
							lv_defaultExp_16_0,
							"org.eclipse.lsat.setting.teditor.Setting.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		otherlv_17=')'
		{
			newLeafNode(otherlv_17, grammarAccess.getGammaDistributionAccess().getRightParenthesisKeyword_11());
		}
	)
;

// Entry rule entryRulePoissonDistribution
entryRulePoissonDistribution returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPoissonDistributionRule()); }
	iv_rulePoissonDistribution=rulePoissonDistribution
	{ $current=$iv_rulePoissonDistribution.current; }
	EOF;

// Rule PoissonDistribution
rulePoissonDistribution returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='Poisson'
		{
			newLeafNode(otherlv_0, grammarAccess.getPoissonDistributionAccess().getPoissonKeyword_0());
		}
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getPoissonDistributionAccess().getLeftParenthesisKeyword_1());
		}
		otherlv_2='mean'
		{
			newLeafNode(otherlv_2, grammarAccess.getPoissonDistributionAccess().getMeanKeyword_2());
		}
		otherlv_3='='
		{
			newLeafNode(otherlv_3, grammarAccess.getPoissonDistributionAccess().getEqualsSignKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getPoissonDistributionAccess().getPExpExpressionParserRuleCall_4_0());
				}
				lv_pExp_4_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getPoissonDistributionRule());
					}
					set(
						$current,
						"pExp",
						lv_pExp_4_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_5=','
			{
				newLeafNode(otherlv_5, grammarAccess.getPoissonDistributionAccess().getCommaKeyword_5_0());
			}
			otherlv_6='epsilon'
			{
				newLeafNode(otherlv_6, grammarAccess.getPoissonDistributionAccess().getEpsilonKeyword_5_1());
			}
			otherlv_7='='
			{
				newLeafNode(otherlv_7, grammarAccess.getPoissonDistributionAccess().getEqualsSignKeyword_5_2());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getPoissonDistributionAccess().getEpsilonExpExpressionParserRuleCall_5_3_0());
					}
					lv_epsilonExp_8_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPoissonDistributionRule());
						}
						set(
							$current,
							"epsilonExp",
							lv_epsilonExp_8_0,
							"org.eclipse.lsat.setting.teditor.Setting.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		(
			otherlv_9=','
			{
				newLeafNode(otherlv_9, grammarAccess.getPoissonDistributionAccess().getCommaKeyword_6_0());
			}
			otherlv_10='default'
			{
				newLeafNode(otherlv_10, grammarAccess.getPoissonDistributionAccess().getDefaultKeyword_6_1());
			}
			otherlv_11='='
			{
				newLeafNode(otherlv_11, grammarAccess.getPoissonDistributionAccess().getEqualsSignKeyword_6_2());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getPoissonDistributionAccess().getDefaultExpExpressionParserRuleCall_6_3_0());
					}
					lv_defaultExp_12_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPoissonDistributionRule());
						}
						set(
							$current,
							"defaultExp",
							lv_defaultExp_12_0,
							"org.eclipse.lsat.setting.teditor.Setting.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		otherlv_13=')'
		{
			newLeafNode(otherlv_13, grammarAccess.getPoissonDistributionAccess().getRightParenthesisKeyword_7());
		}
	)
;

// Entry rule entryRuleLogNormalDistribution
entryRuleLogNormalDistribution returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLogNormalDistributionRule()); }
	iv_ruleLogNormalDistribution=ruleLogNormalDistribution
	{ $current=$iv_ruleLogNormalDistribution.current; }
	EOF;

// Rule LogNormalDistribution
ruleLogNormalDistribution returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='LogNormal'
		{
			newLeafNode(otherlv_0, grammarAccess.getLogNormalDistributionAccess().getLogNormalKeyword_0());
		}
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getLogNormalDistributionAccess().getLeftParenthesisKeyword_1());
		}
		otherlv_2='scale'
		{
			newLeafNode(otherlv_2, grammarAccess.getLogNormalDistributionAccess().getScaleKeyword_2());
		}
		otherlv_3='='
		{
			newLeafNode(otherlv_3, grammarAccess.getLogNormalDistributionAccess().getEqualsSignKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getLogNormalDistributionAccess().getScaleExpExpressionParserRuleCall_4_0());
				}
				lv_scaleExp_4_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getLogNormalDistributionRule());
					}
					set(
						$current,
						"scaleExp",
						lv_scaleExp_4_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_5=','
		{
			newLeafNode(otherlv_5, grammarAccess.getLogNormalDistributionAccess().getCommaKeyword_5());
		}
		otherlv_6='shape'
		{
			newLeafNode(otherlv_6, grammarAccess.getLogNormalDistributionAccess().getShapeKeyword_6());
		}
		otherlv_7='='
		{
			newLeafNode(otherlv_7, grammarAccess.getLogNormalDistributionAccess().getEqualsSignKeyword_7());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getLogNormalDistributionAccess().getShapeExpExpressionParserRuleCall_8_0());
				}
				lv_shapeExp_8_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getLogNormalDistributionRule());
					}
					set(
						$current,
						"shapeExp",
						lv_shapeExp_8_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_9=','
			{
				newLeafNode(otherlv_9, grammarAccess.getLogNormalDistributionAccess().getCommaKeyword_9_0());
			}
			otherlv_10='inverseCumAccuracy'
			{
				newLeafNode(otherlv_10, grammarAccess.getLogNormalDistributionAccess().getInverseCumAccuracyKeyword_9_1());
			}
			otherlv_11='='
			{
				newLeafNode(otherlv_11, grammarAccess.getLogNormalDistributionAccess().getEqualsSignKeyword_9_2());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getLogNormalDistributionAccess().getInverseCumAccuracyExpExpressionParserRuleCall_9_3_0());
					}
					lv_inverseCumAccuracyExp_12_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getLogNormalDistributionRule());
						}
						set(
							$current,
							"inverseCumAccuracyExp",
							lv_inverseCumAccuracyExp_12_0,
							"org.eclipse.lsat.setting.teditor.Setting.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		(
			otherlv_13=','
			{
				newLeafNode(otherlv_13, grammarAccess.getLogNormalDistributionAccess().getCommaKeyword_10_0());
			}
			otherlv_14='default'
			{
				newLeafNode(otherlv_14, grammarAccess.getLogNormalDistributionAccess().getDefaultKeyword_10_1());
			}
			otherlv_15='='
			{
				newLeafNode(otherlv_15, grammarAccess.getLogNormalDistributionAccess().getEqualsSignKeyword_10_2());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getLogNormalDistributionAccess().getDefaultExpExpressionParserRuleCall_10_3_0());
					}
					lv_defaultExp_16_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getLogNormalDistributionRule());
						}
						set(
							$current,
							"defaultExp",
							lv_defaultExp_16_0,
							"org.eclipse.lsat.setting.teditor.Setting.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		otherlv_17=')'
		{
			newLeafNode(otherlv_17, grammarAccess.getLogNormalDistributionAccess().getRightParenthesisKeyword_11());
		}
	)
;

// Entry rule entryRuleEBigDecimal
entryRuleEBigDecimal returns [String current=null]:
	{ newCompositeNode(grammarAccess.getEBigDecimalRule()); }
	iv_ruleEBigDecimal=ruleEBigDecimal
	{ $current=$iv_ruleEBigDecimal.current.getText(); }
	EOF;

// Rule EBigDecimal
ruleEBigDecimal returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			kw='-'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getEBigDecimalAccess().getHyphenMinusKeyword_0());
			}
		)?
		this_INT_1=RULE_INT
		{
			$current.merge(this_INT_1);
		}
		{
			newLeafNode(this_INT_1, grammarAccess.getEBigDecimalAccess().getINTTerminalRuleCall_1());
		}
		(
			kw='.'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getEBigDecimalAccess().getFullStopKeyword_2_0());
			}
			this_INT_3=RULE_INT
			{
				$current.merge(this_INT_3);
			}
			{
				newLeafNode(this_INT_3, grammarAccess.getEBigDecimalAccess().getINTTerminalRuleCall_2_1());
			}
		)?
		(
			(
				kw='E'
				{
					$current.merge(kw);
					newLeafNode(kw, grammarAccess.getEBigDecimalAccess().getEKeyword_3_0_0());
				}
				    |
				kw='e'
				{
					$current.merge(kw);
					newLeafNode(kw, grammarAccess.getEBigDecimalAccess().getEKeyword_3_0_1());
				}
			)
			(
				kw='-'
				{
					$current.merge(kw);
					newLeafNode(kw, grammarAccess.getEBigDecimalAccess().getHyphenMinusKeyword_3_1());
				}
			)?
			this_INT_7=RULE_INT
			{
				$current.merge(this_INT_7);
			}
			{
				newLeafNode(this_INT_7, grammarAccess.getEBigDecimalAccess().getINTTerminalRuleCall_3_2());
			}
		)?
	)
;

// Entry rule entryRuleIID
entryRuleIID returns [String current=null]:
	{ newCompositeNode(grammarAccess.getIIDRule()); }
	iv_ruleIID=ruleIID
	{ $current=$iv_ruleIID.current.getText(); }
	EOF;

// Rule IID
ruleIID returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_INT_0=RULE_INT
		{
			$current.merge(this_INT_0);
		}
		{
			newLeafNode(this_INT_0, grammarAccess.getIIDAccess().getINTTerminalRuleCall_0());
		}
		    |
		this_ID_1=RULE_ID
		{
			$current.merge(this_ID_1);
		}
		{
			newLeafNode(this_ID_1, grammarAccess.getIIDAccess().getIDTerminalRuleCall_1());
		}
	)
;

// Entry rule entryRuleResourceQualifiedName
entryRuleResourceQualifiedName returns [String current=null]:
	{ newCompositeNode(grammarAccess.getResourceQualifiedNameRule()); }
	iv_ruleResourceQualifiedName=ruleResourceQualifiedName
	{ $current=$iv_ruleResourceQualifiedName.current.getText(); }
	EOF;

// Rule ResourceQualifiedName
ruleResourceQualifiedName returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getResourceQualifiedNameAccess().getIIDParserRuleCall_0());
		}
		this_IID_0=ruleIID
		{
			$current.merge(this_IID_0);
		}
		{
			afterParserOrEnumRuleCall();
		}
		(
			kw='.'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getResourceQualifiedNameAccess().getFullStopKeyword_1_0());
			}
			{
				newCompositeNode(grammarAccess.getResourceQualifiedNameAccess().getIIDParserRuleCall_1_1());
			}
			this_IID_2=ruleIID
			{
				$current.merge(this_IID_2);
			}
			{
				afterParserOrEnumRuleCall();
			}
		)?
	)
;

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

RULE_INT : ('0'..'9')+;

RULE_STRING : ('"' ('\\' .|~(('\\'|'"')))* '"'|'\'' ('\\' .|~(('\\'|'\'')))* '\'');

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_WS : (' '|'\t'|'\r'|'\n')+;

RULE_ANY_OTHER : .;
