/**
 */
package org.eclipse.lsat.common.scheduler.schedule.impl;

import org.eclipse.lsat.common.scheduler.graph.Task;

import org.eclipse.lsat.common.scheduler.resources.Resource;

import org.eclipse.lsat.common.scheduler.schedule.Schedule;
import org.eclipse.lsat.common.scheduler.schedule.SchedulePackage;
import org.eclipse.lsat.common.scheduler.schedule.ScheduledTask;
import org.eclipse.lsat.common.scheduler.schedule.Sequence;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Sequence</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.lsat.common.scheduler.schedule.impl.SequenceImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.lsat.common.scheduler.schedule.impl.SequenceImpl#getSchedule <em>Schedule</em>}</li>
 *   <li>{@link org.eclipse.lsat.common.scheduler.schedule.impl.SequenceImpl#getScheduledTasks <em>Scheduled Tasks</em>}</li>
 *   <li>{@link org.eclipse.lsat.common.scheduler.schedule.impl.SequenceImpl#getResource <em>Resource</em>}</li>
 * </ul>
 *
 * @generated
 */
public class SequenceImpl<T extends Task> extends MinimalEObjectImpl.Container implements Sequence<T> {
	/**
     * The default value of the '{@link #getName() <em>Name</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getName()
     * @generated
     * @ordered
     */
	protected static final String NAME_EDEFAULT = null;

	/**
     * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getName()
     * @generated
     * @ordered
     */
	protected String name = NAME_EDEFAULT;

	/**
     * The cached value of the '{@link #getScheduledTasks() <em>Scheduled Tasks</em>}' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getScheduledTasks()
     * @generated
     * @ordered
     */
	protected EList<ScheduledTask<T>> scheduledTasks;

	/**
     * The cached value of the '{@link #getResource() <em>Resource</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getResource()
     * @generated
     * @ordered
     */
	protected Resource resource;

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected SequenceImpl() {
        super();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	protected EClass eStaticClass() {
        return SchedulePackage.Literals.SEQUENCE;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public String getName() {
        return name;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void setName(String newName) {
        String oldName = name;
        name = newName;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, SchedulePackage.SEQUENCE__NAME, oldName, name));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@SuppressWarnings("unchecked")
	@Override
	public Schedule<T> getSchedule() {
        if (eContainerFeatureID() != SchedulePackage.SEQUENCE__SCHEDULE) return null;
        return (Schedule<T>)eInternalContainer();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain basicSetSchedule(Schedule<T> newSchedule, NotificationChain msgs) {
        msgs = eBasicSetContainer((InternalEObject)newSchedule, SchedulePackage.SEQUENCE__SCHEDULE, msgs);
        return msgs;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void setSchedule(Schedule<T> newSchedule) {
        if (newSchedule != eInternalContainer() || (eContainerFeatureID() != SchedulePackage.SEQUENCE__SCHEDULE && newSchedule != null))
        {
            if (EcoreUtil.isAncestor(this, newSchedule))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eInternalContainer() != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newSchedule != null)
                msgs = ((InternalEObject)newSchedule).eInverseAdd(this, SchedulePackage.SCHEDULE__SEQUENCES, Schedule.class, msgs);
            msgs = basicSetSchedule(newSchedule, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, SchedulePackage.SEQUENCE__SCHEDULE, newSchedule, newSchedule));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public EList<ScheduledTask<T>> getScheduledTasks() {
        if (scheduledTasks == null)
        {
            scheduledTasks = new EObjectWithInverseResolvingEList<ScheduledTask<T>>(ScheduledTask.class, this, SchedulePackage.SEQUENCE__SCHEDULED_TASKS, SchedulePackage.SCHEDULED_TASK__SEQUENCE);
        }
        return scheduledTasks;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Resource getResource() {
        if (resource != null && resource.eIsProxy())
        {
            InternalEObject oldResource = (InternalEObject)resource;
            resource = (Resource)eResolveProxy(oldResource);
            if (resource != oldResource)
            {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, SchedulePackage.SEQUENCE__RESOURCE, oldResource, resource));
            }
        }
        return resource;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Resource basicGetResource() {
        return resource;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void setResource(Resource newResource) {
        Resource oldResource = resource;
        resource = newResource;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, SchedulePackage.SEQUENCE__RESOURCE, oldResource, resource));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID)
        {
            case SchedulePackage.SEQUENCE__SCHEDULE:
                if (eInternalContainer() != null)
                    msgs = eBasicRemoveFromContainer(msgs);
                return basicSetSchedule((Schedule<T>)otherEnd, msgs);
            case SchedulePackage.SEQUENCE__SCHEDULED_TASKS:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getScheduledTasks()).basicAdd(otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID)
        {
            case SchedulePackage.SEQUENCE__SCHEDULE:
                return basicSetSchedule(null, msgs);
            case SchedulePackage.SEQUENCE__SCHEDULED_TASKS:
                return ((InternalEList<?>)getScheduledTasks()).basicRemove(otherEnd, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (eContainerFeatureID())
        {
            case SchedulePackage.SEQUENCE__SCHEDULE:
                return eInternalContainer().eInverseRemove(this, SchedulePackage.SCHEDULE__SEQUENCES, Schedule.class, msgs);
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID)
        {
            case SchedulePackage.SEQUENCE__NAME:
                return getName();
            case SchedulePackage.SEQUENCE__SCHEDULE:
                return getSchedule();
            case SchedulePackage.SEQUENCE__SCHEDULED_TASKS:
                return getScheduledTasks();
            case SchedulePackage.SEQUENCE__RESOURCE:
                if (resolve) return getResource();
                return basicGetResource();
        }
        return super.eGet(featureID, resolve, coreType);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
        switch (featureID)
        {
            case SchedulePackage.SEQUENCE__NAME:
                setName((String)newValue);
                return;
            case SchedulePackage.SEQUENCE__SCHEDULE:
                setSchedule((Schedule<T>)newValue);
                return;
            case SchedulePackage.SEQUENCE__SCHEDULED_TASKS:
                getScheduledTasks().clear();
                getScheduledTasks().addAll((Collection<? extends ScheduledTask<T>>)newValue);
                return;
            case SchedulePackage.SEQUENCE__RESOURCE:
                setResource((Resource)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void eUnset(int featureID) {
        switch (featureID)
        {
            case SchedulePackage.SEQUENCE__NAME:
                setName(NAME_EDEFAULT);
                return;
            case SchedulePackage.SEQUENCE__SCHEDULE:
                setSchedule((Schedule<T>)null);
                return;
            case SchedulePackage.SEQUENCE__SCHEDULED_TASKS:
                getScheduledTasks().clear();
                return;
            case SchedulePackage.SEQUENCE__RESOURCE:
                setResource((Resource)null);
                return;
        }
        super.eUnset(featureID);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public boolean eIsSet(int featureID) {
        switch (featureID)
        {
            case SchedulePackage.SEQUENCE__NAME:
                return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
            case SchedulePackage.SEQUENCE__SCHEDULE:
                return getSchedule() != null;
            case SchedulePackage.SEQUENCE__SCHEDULED_TASKS:
                return scheduledTasks != null && !scheduledTasks.isEmpty();
            case SchedulePackage.SEQUENCE__RESOURCE:
                return resource != null;
        }
        return super.eIsSet(featureID);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (name: ");
        result.append(name);
        result.append(')');
        return result.toString();
    }

} //SequenceImpl
