/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.por;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.lsat.common.ludus.backend.fsm.FSM;
import org.eclipse.lsat.common.ludus.backend.fsm.FSMComposition;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Edge;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.FSMImpl;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Location;
import org.eclipse.lsat.common.ludus.backend.por.DependencyInterface;

public class ClusterPORPerformance {
    private Map<List<Location>, Location> stateMap;
    private Integer currentStateId;
    private List<FSM<Location, Edge>> fsmList;
    private FSMImpl cFSM;
    private Set<String> alphabet;
    private Set<String> controllableEvents;
    private Set<String> uncontrollableEvents;
    private Set<Edge> visitedEdges;
    private Set<Location> visitedLocations;
    private DependencyInterface dependencies;
    private Map<String, Set<Integer>> occursInMap;
    private Map<String, Set<String>> alphabetMap;

    public FSMImpl compute(List<FSM<Location, Edge>> fsmList, DependencyInterface dependencies) {
        this.stateMap = new HashMap<List<Location>, Location>();
        this.currentStateId = 0;
        this.cFSM = new FSMImpl();
        this.visitedEdges = new HashSet<Edge>();
        this.visitedLocations = new HashSet<Location>();
        this.fsmList = fsmList;
        this.dependencies = dependencies;
        this.alphabet = new HashSet<String>();
        this.uncontrollableEvents = new HashSet<String>();
        this.controllableEvents = new HashSet<String>();
        for (FSM<Location, Edge> fsm : fsmList) {
            this.alphabet.addAll(fsm.getAlphabet());
            this.uncontrollableEvents.addAll(fsm.getUncontrollable());
            this.controllableEvents.addAll(fsm.getControllable());
        }
        this.occursInMap = new HashMap<String, Set<Integer>>();
        this.alphabetMap = new HashMap<String, Set<String>>();
        for (String event : this.alphabet) {
            HashSet<Integer> occursList = new HashSet<Integer>();
            HashSet<String> alphabetList = new HashSet<String>();
            int fsmId = 0;
            while (fsmId < this.fsmList.size()) {
                FSM<Location, Edge> fsm = fsmList.get(fsmId);
                if (fsm.getAlphabet().contains(event)) {
                    occursList.add(fsmId);
                    alphabetList.addAll(fsm.getAlphabet());
                }
                ++fsmId;
            }
            this.occursInMap.put(event, occursList);
            this.alphabetMap.put(event, alphabetList);
        }
        ArrayList<Location> initialState = new ArrayList<Location>();
        int fsmId = 0;
        while (fsmId < this.fsmList.size()) {
            initialState.add(fsmId, this.fsmList.get(fsmId).getInitial());
            ++fsmId;
        }
        Location stateLocation = this.getLocation(initialState);
        this.cFSM.setInitial(stateLocation);
        for (String uEvent : this.uncontrollableEvents) {
            this.cFSM.addUncontrollable(uEvent);
        }
        for (String cEvent : this.controllableEvents) {
            this.cFSM.addControllable(cEvent);
        }
        this.dfsTraversal(initialState);
        return this.cFSM;
    }

    private void dfsTraversal(List<Location> state) {
        this.visit(state);
        for (String a : this.cample(this.fsmList, state)) {
            List<Location> targetState = FSMComposition.getEdgeTarget(this.fsmList, state, a);
            Edge e = new Edge(this.getLocation(state), a, this.getLocation(targetState));
            if (this.isVisited(e)) continue;
            this.visit(e);
            if (this.isVisited(this.getLocation(targetState))) continue;
            this.dfsTraversal(targetState);
        }
    }

    private Set<String> cample(List<FSM<Location, Edge>> fsmList, List<Location> state) {
        Set<String> enabled = FSMComposition.enabled(fsmList, state);
        if (enabled.size() <= 1) {
            return enabled;
        }
        Set<String> clusterEnabled = enabled;
        for (String event : enabled) {
            Set<Integer> cluster = this.getCluster(fsmList, state, enabled, event);
            Optional<Set<String>> clusterEnabledCheck = this.checkCluster(fsmList, state, enabled, cluster);
            if (clusterEnabledCheck.isPresent() && clusterEnabledCheck.get().size() < clusterEnabled.size()) {
                clusterEnabled = clusterEnabledCheck.get();
            }
            if (clusterEnabledCheck.isPresent()) continue;
            System.out.println("The cluster that has been computed is incorrect.");
        }
        return clusterEnabled;
    }

    private Set<Integer> getCluster(List<FSM<Location, Edge>> fsmList, List<Location> state, Set<String> enabled, String candidate) {
        HashSet<String> processed = new HashSet<String>();
        HashSet<String> toProcess = new HashSet<String>();
        HashSet<Integer> cluster = new HashSet<Integer>();
        HashSet<String> clusterAlphabet = new HashSet<String>();
        toProcess.add(candidate);
        while (!toProcess.isEmpty()) {
            String event = (String)toProcess.iterator().next();
            processed.add(event);
            if (enabled.contains(event)) {
                cluster.addAll((Collection<Integer>)this.occursInMap.get(event));
                clusterAlphabet.addAll((Collection)this.alphabetMap.get(event));
                for (String dep : this.getDependencies(event)) {
                    if (clusterAlphabet.contains(dep)) continue;
                    Integer fsmId = this.occursInMap.get(dep).iterator().next();
                    cluster.add(fsmId);
                    clusterAlphabet.addAll(fsmList.get(fsmId).getAlphabet());
                }
            }
            Set<String> locallyEnabled = this.getLocallyEnabled(fsmList, cluster, state);
            if (!enabled.contains(event) && locallyEnabled.contains(event)) {
                int fsmId = 0;
                while (fsmId < fsmList.size()) {
                    if (fsmList.get(fsmId).getAlphabet().contains(event) && !cluster.contains(fsmId) && !FSMComposition.isEnabled(fsmList.get(fsmId), state.get(fsmId), event)) {
                        cluster.add(fsmId);
                        clusterAlphabet.addAll(fsmList.get(fsmId).getAlphabet());
                        break;
                    }
                    ++fsmId;
                }
                locallyEnabled = this.getLocallyEnabled(fsmList, cluster, state);
            }
            HashSet<String> newQueue = new HashSet<String>(locallyEnabled);
            newQueue.removeAll(processed);
            toProcess = newQueue;
        }
        return cluster;
    }

    private boolean dependent(String eventA, String eventB) {
        return this.dependencies.hasDependency(eventA, eventB);
    }

    private Set<String> getDependencies(String event) {
        return this.dependencies.getDependencies(event);
    }

    private Optional<Set<String>> checkCluster(List<FSM<Location, Edge>> fsmList, List<Location> state, Set<String> enabled, Set<Integer> cluster) {
        HashSet<String> clusterAlphabet = new HashSet<String>();
        int fsmId = 0;
        while (fsmId < fsmList.size()) {
            if (cluster.contains(fsmId)) {
                clusterAlphabet.addAll(fsmList.get(fsmId).getAlphabet());
            }
            ++fsmId;
        }
        HashSet<String> clusterEnabled = new HashSet<String>(enabled);
        clusterEnabled.retainAll(clusterAlphabet);
        if (clusterEnabled.isEmpty()) {
            return Optional.empty();
        }
        HashSet<String> outsideCluster = new HashSet<String>(this.alphabet);
        outsideCluster.removeAll(clusterAlphabet);
        for (String event : clusterEnabled) {
            for (String other : outsideCluster) {
                if (!this.dependent(event, other)) continue;
                return Optional.empty();
            }
        }
        Set<String> locallyEnabled = this.getLocallyEnabled(fsmList, cluster, state);
        int fsmId2 = 0;
        while (fsmId2 < fsmList.size()) {
            if (!cluster.contains(fsmId2)) {
                FSM<Location, Edge> fsm = fsmList.get(fsmId2);
                if (fsm.getAlphabet().stream().anyMatch(locallyEnabled::contains)) {
                    return Optional.empty();
                }
            }
            ++fsmId2;
        }
        return Optional.of(clusterEnabled);
    }

    private Set<String> getLocallyEnabled(List<FSM<Location, Edge>> fsmList, Set<Integer> cluster, List<Location> state) {
        ArrayList<FSM<Location, Edge>> clusterFSMs = new ArrayList<FSM<Location, Edge>>();
        ArrayList<Location> clusterState = new ArrayList<Location>();
        for (Integer fid : cluster) {
            clusterFSMs.add(fsmList.get(fid));
            clusterState.add(state.get(fid));
        }
        return FSMComposition.enabled(clusterFSMs, clusterState);
    }

    private void visit(List<Location> state) {
        this.visitedLocations.add(this.getLocation(state));
        this.cFSM.addLocation(this.stateMap.get(state));
    }

    private void visit(Edge e) {
        this.visitedEdges.add(e);
        this.cFSM.addEdge(e);
    }

    private Location getLocation(List<Location> state) {
        if (!this.stateMap.containsKey(state)) {
            this.currentStateId = this.currentStateId + 1;
            this.stateMap.put(state, new Location("s" + this.currentStateId));
        }
        return this.stateMap.get(state);
    }

    private boolean isVisited(Location l) {
        return this.visitedLocations.contains(l);
    }

    private boolean isVisited(Edge e) {
        return this.visitedEdges.contains(e);
    }
}

