/*
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

package org.eclipse.lsat.common.ludus.backend.algorithms;

import java.util.List;

import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Tuple;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Location;

public class SimpleCyclesResourceCheckException extends Exception {
    private static final long serialVersionUID = 5762300638917949782L;

    private final List<Location> simpleCycle;

    private final List<Tuple<Integer, Integer>> missingClaimPairs;

    public SimpleCyclesResourceCheckException(List<Location> cycle, List<Tuple<Integer, Integer>> missingPairs) {
        super("not all resources are used on the simple cycle");
        simpleCycle = cycle;
        missingClaimPairs = missingPairs;
    }

    public List<Location> getSimpleCycle() {
        return simpleCycle;
    }

    public List<Tuple<Integer, Integer>> getMissingClaimPairs() {
        return missingClaimPairs;
    }
}
