/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.internal.series;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.internal.axis.Axis;
import org.eclipse.swtchart.internal.series.CircularSeries;
import org.eclipse.swtchart.model.Node;

public class DoughnutSeries
extends CircularSeries {
    protected DoughnutSeries(Chart chart, String id) {
        super(chart, id);
        this.type = ISeries.SeriesType.DOUGHNUT;
    }

    @Override
    protected void drawNode(Node node, GC gc, Axis xAxis, Axis yAxis) {
        if (!node.getChildren().isEmpty()) {
            for (Node nodes : node.getChildren()) {
                this.drawNode(nodes, gc, xAxis, yAxis);
            }
        }
        if (!node.isVisible()) {
            return;
        }
        int level = node.getLevel() - this.getRootPointer().getLevel() + 1;
        int xStart = xAxis.getPixelCoordinate(-level);
        int yStart = yAxis.getPixelCoordinate(level);
        int xWidth = xAxis.getPixelCoordinate(level) - xStart;
        int yWidth = yAxis.getPixelCoordinate(-level) - yStart;
        int xZero = xAxis.getPixelCoordinate(0.0);
        int yZero = yAxis.getPixelCoordinate(0.0);
        int angleStart = node.getAngleBounds().x;
        int angleWidth = node.getAngleBounds().y;
        gc.setBackground(node.getSliceColor());
        gc.fillArc(xStart, yStart, xWidth, yWidth, angleStart, angleWidth);
        gc.drawArc(xStart, yStart, xWidth, yWidth, angleStart, angleWidth);
        double xStartCoordinate = (double)level * Math.cos(Math.toRadians(angleStart));
        double yStartCoordinate = (double)level * Math.sin(Math.toRadians(angleStart));
        int xStartPixelCoordinate = xAxis.getPixelCoordinate(xStartCoordinate);
        int yStartPixelCoordinate = yAxis.getPixelCoordinate(yStartCoordinate);
        if (node != this.getRootPointer()) {
            gc.drawLine(xZero, yZero, xStartPixelCoordinate, yStartPixelCoordinate);
        }
        double xEndCoordinate = (double)level * Math.cos(Math.toRadians(angleStart + angleWidth));
        double yEndCoordinate = (double)level * Math.sin(Math.toRadians(angleStart + angleWidth));
        int xEndPixelCoordinate = xAxis.getPixelCoordinate(xEndCoordinate);
        int yEndPixelCoordinate = yAxis.getPixelCoordinate(yEndCoordinate);
        if (node != this.getRootPointer()) {
            gc.drawLine(xZero, yZero, xEndPixelCoordinate, yEndPixelCoordinate);
        }
    }

    @Override
    protected void setBothAxisRange(int width, int height, Axis xAxis, Axis yAxis) {
        this.setMaxTreeDepth(this.getRootPointer().getMaxSubTreeDepth() - 1);
        double rangeMax = (double)(this.getMaxTreeDepth() + 1) * 1.05;
        xAxis.setRange(new Range(-rangeMax, rangeMax));
        yAxis.setRange(new Range(-rangeMax, rangeMax));
        if (width > height) {
            if (xAxis.isHorizontalAxis()) {
                double ratio = 2.0 * rangeMax * (double)width / (double)height;
                xAxis.setRange(new Range(-ratio / 2.0, ratio / 2.0));
            } else {
                double ratio = 2.0 * rangeMax * (double)width / (double)height;
                yAxis.setRange(new Range(ratio / 2.0, ratio / 2.0));
            }
        } else if (xAxis.isHorizontalAxis()) {
            double ratio = 2.0 * rangeMax * (double)height / (double)width;
            yAxis.setRange(new Range(-ratio / 2.0, ratio / 2.0));
        } else {
            double ratio = 2.0 * rangeMax * (double)height / (double)width;
            xAxis.setRange(new Range(-ratio / 2.0, ratio / 2.0));
        }
    }

    @Override
    public Range getAdjustedRange(Axis axis, int length) {
        this.setMaxTreeDepth(this.getRootNode().getMaxSubTreeDepth() - 1);
        return new Range(-this.getMaxTreeDepth() - 1, this.getMaxTreeDepth() + 1);
    }

    @Override
    public Node getPieSliceFromPosition(double primaryValueX, double primaryValueY) {
        double radius = Math.sqrt(primaryValueX * primaryValueX + primaryValueY * primaryValueY);
        int level = (int)radius;
        Node node = null;
        double angleOfInspection = Math.atan2(primaryValueY, primaryValueX);
        if (angleOfInspection < 0.0) {
            angleOfInspection += Math.PI * 2;
        }
        if (level < this.getNodeDataModel().getNodes().length) {
            for (Node nodeX : this.getNodeDataModel().getNodes()[level]) {
                double lowerBound = (double)nodeX.getAngleBounds().x * Math.PI / 180.0;
                double upperBound = (double)(nodeX.getAngleBounds().x + nodeX.getAngleBounds().y) * Math.PI / 180.0;
                if (!(lowerBound <= angleOfInspection) || !(upperBound >= angleOfInspection)) continue;
                node = nodeX;
                break;
            }
        }
        return node;
    }
}

