
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link Volume}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableVolume.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableVolume implements Volume {
  private final @Nullable String name;
  private final @Nullable String driver;
  private final @Nullable Map<String, String> driverOpts;
  private final @Nullable Map<String, String> options;
  private final @Nullable Map<String, String> labels;
  private final @Nullable String mountpoint;
  private final @Nullable String scope;
  private final @Nullable Map<String, String> status;

  private ImmutableVolume(
      @Nullable String name,
      @Nullable String driver,
      @Nullable Map<String, String> driverOpts,
      @Nullable Map<String, String> options,
      @Nullable Map<String, String> labels,
      @Nullable String mountpoint,
      @Nullable String scope,
      @Nullable Map<String, String> status) {
    this.name = name;
    this.driver = driver;
    this.driverOpts = driverOpts;
    this.options = options;
    this.labels = labels;
    this.mountpoint = mountpoint;
    this.scope = scope;
    this.status = status;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public @Nullable String name() {
    return name;
  }

  /**
   * @return The value of the {@code driver} attribute
   */
  @JsonProperty("Driver")
  @Override
  public @Nullable String driver() {
    return driver;
  }

  /**
   * @return The value of the {@code driverOpts} attribute
   */
  @JsonProperty("DriverOpts")
  @Override
  public @Nullable Map<String, String> driverOpts() {
    return driverOpts;
  }

  /**
   * @return The value of the {@code options} attribute
   */
  @JsonProperty("Options")
  @Override
  public @Nullable Map<String, String> options() {
    return options;
  }

  /**
   * @return The value of the {@code labels} attribute
   */
  @JsonProperty("Labels")
  @Override
  public @Nullable Map<String, String> labels() {
    return labels;
  }

  /**
   * @return The value of the {@code mountpoint} attribute
   */
  @JsonProperty("Mountpoint")
  @Override
  public @Nullable String mountpoint() {
    return mountpoint;
  }

  /**
   * @return The value of the {@code scope} attribute
   */
  @JsonProperty("Scope")
  @Override
  public @Nullable String scope() {
    return scope;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @JsonProperty("Status")
  @Override
  public @Nullable Map<String, String> status() {
    return status;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Volume#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableVolume withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableVolume(
        value,
        this.driver,
        this.driverOpts,
        this.options,
        this.labels,
        this.mountpoint,
        this.scope,
        this.status);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Volume#driver() driver} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for driver (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableVolume withDriver(@Nullable String value) {
    if (Objects.equals(this.driver, value)) return this;
    return new ImmutableVolume(
        this.name,
        value,
        this.driverOpts,
        this.options,
        this.labels,
        this.mountpoint,
        this.scope,
        this.status);
  }

  /**
   * Copy the current immutable object by replacing the {@link Volume#driverOpts() driverOpts} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to replace the driverOpts map
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableVolume withDriverOpts(@Nullable Map<String, ? extends String> entries) {
    if (this.driverOpts == entries) return this;
    @Nullable Map<String, String> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return new ImmutableVolume(
        this.name,
        this.driver,
        newValue,
        this.options,
        this.labels,
        this.mountpoint,
        this.scope,
        this.status);
  }

  /**
   * Copy the current immutable object by replacing the {@link Volume#options() options} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to replace the options map
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableVolume withOptions(@Nullable Map<String, ? extends String> entries) {
    if (this.options == entries) return this;
    @Nullable Map<String, String> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return new ImmutableVolume(
        this.name,
        this.driver,
        this.driverOpts,
        newValue,
        this.labels,
        this.mountpoint,
        this.scope,
        this.status);
  }

  /**
   * Copy the current immutable object by replacing the {@link Volume#labels() labels} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to replace the labels map
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableVolume withLabels(@Nullable Map<String, ? extends String> entries) {
    if (this.labels == entries) return this;
    @Nullable Map<String, String> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return new ImmutableVolume(
        this.name,
        this.driver,
        this.driverOpts,
        this.options,
        newValue,
        this.mountpoint,
        this.scope,
        this.status);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Volume#mountpoint() mountpoint} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mountpoint (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableVolume withMountpoint(@Nullable String value) {
    if (Objects.equals(this.mountpoint, value)) return this;
    return new ImmutableVolume(
        this.name,
        this.driver,
        this.driverOpts,
        this.options,
        this.labels,
        value,
        this.scope,
        this.status);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Volume#scope() scope} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for scope (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableVolume withScope(@Nullable String value) {
    if (Objects.equals(this.scope, value)) return this;
    return new ImmutableVolume(
        this.name,
        this.driver,
        this.driverOpts,
        this.options,
        this.labels,
        this.mountpoint,
        value,
        this.status);
  }

  /**
   * Copy the current immutable object by replacing the {@link Volume#status() status} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to replace the status map
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableVolume withStatus(@Nullable Map<String, ? extends String> entries) {
    if (this.status == entries) return this;
    @Nullable Map<String, String> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return new ImmutableVolume(
        this.name,
        this.driver,
        this.driverOpts,
        this.options,
        this.labels,
        this.mountpoint,
        this.scope,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableVolume} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableVolume
        && equalsByValue((ImmutableVolume) another);
  }

  private boolean equalsByValue(ImmutableVolume another) {
    return Objects.equals(name, another.name)
        && Objects.equals(driver, another.driver)
        && Objects.equals(driverOpts, another.driverOpts)
        && Objects.equals(options, another.options)
        && Objects.equals(labels, another.labels)
        && Objects.equals(mountpoint, another.mountpoint)
        && Objects.equals(scope, another.scope)
        && Objects.equals(status, another.status);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code driver}, {@code driverOpts}, {@code options}, {@code labels}, {@code mountpoint}, {@code scope}, {@code status}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(driver);
    h += (h << 5) + Objects.hashCode(driverOpts);
    h += (h << 5) + Objects.hashCode(options);
    h += (h << 5) + Objects.hashCode(labels);
    h += (h << 5) + Objects.hashCode(mountpoint);
    h += (h << 5) + Objects.hashCode(scope);
    h += (h << 5) + Objects.hashCode(status);
    return h;
  }

  /**
   * Prints the immutable value {@code Volume} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Volume{"
        + "name=" + name
        + ", driver=" + driver
        + ", driverOpts=" + driverOpts
        + ", options=" + options
        + ", labels=" + labels
        + ", mountpoint=" + mountpoint
        + ", scope=" + scope
        + ", status=" + status
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Volume} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Volume instance
   */
  public static ImmutableVolume copyOf(Volume instance) {
    if (instance instanceof ImmutableVolume) {
      return (ImmutableVolume) instance;
    }
    return ImmutableVolume.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableVolume ImmutableVolume}.
   * <pre>
   * ImmutableVolume.builder()
   *    .name(String | null) // nullable {@link Volume#name() name}
   *    .driver(String | null) // nullable {@link Volume#driver() driver}
   *    .driverOpts(Map&lt;String, String&gt; | null) // nullable {@link Volume#driverOpts() driverOpts}
   *    .options(Map&lt;String, String&gt; | null) // nullable {@link Volume#options() options}
   *    .labels(Map&lt;String, String&gt; | null) // nullable {@link Volume#labels() labels}
   *    .mountpoint(String | null) // nullable {@link Volume#mountpoint() mountpoint}
   *    .scope(String | null) // nullable {@link Volume#scope() scope}
   *    .status(Map&lt;String, String&gt; | null) // nullable {@link Volume#status() status}
   *    .build();
   * </pre>
   * @return A new ImmutableVolume builder
   */
  public static ImmutableVolume.Builder builder() {
    return new ImmutableVolume.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableVolume ImmutableVolume}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements Volume.Builder {
    private String name;
    private String driver;
    private Map<String, String> driverOpts = null;
    private Map<String, String> options = null;
    private Map<String, String> labels = null;
    private String mountpoint;
    private String scope;
    private Map<String, String> status = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Volume} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Volume instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String nameValue = instance.name();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable String driverValue = instance.driver();
      if (driverValue != null) {
        driver(driverValue);
      }
      @Nullable Map<String, String> driverOptsValue = instance.driverOpts();
      if (driverOptsValue != null) {
        putAllDriverOpts(driverOptsValue);
      }
      @Nullable Map<String, String> optionsValue = instance.options();
      if (optionsValue != null) {
        putAllOptions(optionsValue);
      }
      @Nullable Map<String, String> labelsValue = instance.labels();
      if (labelsValue != null) {
        putAllLabels(labelsValue);
      }
      @Nullable String mountpointValue = instance.mountpoint();
      if (mountpointValue != null) {
        mountpoint(mountpointValue);
      }
      @Nullable String scopeValue = instance.scope();
      if (scopeValue != null) {
        scope(scopeValue);
      }
      @Nullable Map<String, String> statusValue = instance.status();
      if (statusValue != null) {
        putAllStatus(statusValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Volume#name() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link Volume#driver() driver} attribute.
     * @param driver The value for driver (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Driver")
    public final Builder driver(@Nullable String driver) {
      this.driver = driver;
      return this;
    }

    /**
     * Put one entry to the {@link Volume#driverOpts() driverOpts} map.
     * @param key The key in the driverOpts map
     * @param value The associated value in the driverOpts map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDriverOpt(String key, String value) {
      if (this.driverOpts == null) {
        this.driverOpts = new LinkedHashMap<String, String>();
      }
      this.driverOpts.put(
          Objects.requireNonNull(key, "driverOpts key"),
          Objects.requireNonNull(value, value == null ? "driverOpts value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link Volume#driverOpts() driverOpts} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDriverOpt(Map.Entry<String, ? extends String> entry) {
      if (this.driverOpts == null) {
        this.driverOpts = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.driverOpts.put(
          Objects.requireNonNull(k, "driverOpts key"),
          Objects.requireNonNull(v, v == null ? "driverOpts value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Volume#driverOpts() driverOpts} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the driverOpts map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("DriverOpts")
    public final Builder driverOpts(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.driverOpts = null;
        return this;
      }
      this.driverOpts = new LinkedHashMap<String, String>();
      return putAllDriverOpts(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Volume#driverOpts() driverOpts} map. Nulls are not permitted
     * @param entries The entries that will be added to the driverOpts map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllDriverOpts(Map<String, ? extends String> entries) {
      if (this.driverOpts == null) {
        this.driverOpts = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.driverOpts.put(
            Objects.requireNonNull(k, "driverOpts key"),
            Objects.requireNonNull(v, v == null ? "driverOpts value for key: " + k : null));
      }
      return this;
    }

    /**
     * Put one entry to the {@link Volume#options() options} map.
     * @param key The key in the options map
     * @param value The associated value in the options map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOption(String key, String value) {
      if (this.options == null) {
        this.options = new LinkedHashMap<String, String>();
      }
      this.options.put(
          Objects.requireNonNull(key, "options key"),
          Objects.requireNonNull(value, value == null ? "options value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link Volume#options() options} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOption(Map.Entry<String, ? extends String> entry) {
      if (this.options == null) {
        this.options = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.options.put(
          Objects.requireNonNull(k, "options key"),
          Objects.requireNonNull(v, v == null ? "options value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Volume#options() options} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the options map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Options")
    public final Builder options(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.options = null;
        return this;
      }
      this.options = new LinkedHashMap<String, String>();
      return putAllOptions(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Volume#options() options} map. Nulls are not permitted
     * @param entries The entries that will be added to the options map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllOptions(Map<String, ? extends String> entries) {
      if (this.options == null) {
        this.options = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.options.put(
            Objects.requireNonNull(k, "options key"),
            Objects.requireNonNull(v, v == null ? "options value for key: " + k : null));
      }
      return this;
    }

    /**
     * Put one entry to the {@link Volume#labels() labels} map.
     * @param key The key in the labels map
     * @param value The associated value in the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLabel(String key, String value) {
      if (this.labels == null) {
        this.labels = new LinkedHashMap<String, String>();
      }
      this.labels.put(
          Objects.requireNonNull(key, "labels key"),
          Objects.requireNonNull(value, value == null ? "labels value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link Volume#labels() labels} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLabel(Map.Entry<String, ? extends String> entry) {
      if (this.labels == null) {
        this.labels = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.labels.put(
          Objects.requireNonNull(k, "labels key"),
          Objects.requireNonNull(v, v == null ? "labels value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Volume#labels() labels} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Labels")
    public final Builder labels(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.labels = null;
        return this;
      }
      this.labels = new LinkedHashMap<String, String>();
      return putAllLabels(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Volume#labels() labels} map. Nulls are not permitted
     * @param entries The entries that will be added to the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLabels(Map<String, ? extends String> entries) {
      if (this.labels == null) {
        this.labels = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.labels.put(
            Objects.requireNonNull(k, "labels key"),
            Objects.requireNonNull(v, v == null ? "labels value for key: " + k : null));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Volume#mountpoint() mountpoint} attribute.
     * @param mountpoint The value for mountpoint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Mountpoint")
    public final Builder mountpoint(@Nullable String mountpoint) {
      this.mountpoint = mountpoint;
      return this;
    }

    /**
     * Initializes the value for the {@link Volume#scope() scope} attribute.
     * @param scope The value for scope (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Scope")
    public final Builder scope(@Nullable String scope) {
      this.scope = scope;
      return this;
    }

    /**
     * Put one entry to the {@link Volume#status() status} map.
     * @param key The key in the status map
     * @param value The associated value in the status map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addStatu(String key, String value) {
      if (this.status == null) {
        this.status = new LinkedHashMap<String, String>();
      }
      this.status.put(
          Objects.requireNonNull(key, "status key"),
          Objects.requireNonNull(value, value == null ? "status value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link Volume#status() status} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addStatu(Map.Entry<String, ? extends String> entry) {
      if (this.status == null) {
        this.status = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.status.put(
          Objects.requireNonNull(k, "status key"),
          Objects.requireNonNull(v, v == null ? "status value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Volume#status() status} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the status map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Status")
    public final Builder status(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.status = null;
        return this;
      }
      this.status = new LinkedHashMap<String, String>();
      return putAllStatus(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Volume#status() status} map. Nulls are not permitted
     * @param entries The entries that will be added to the status map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllStatus(Map<String, ? extends String> entries) {
      if (this.status == null) {
        this.status = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.status.put(
            Objects.requireNonNull(k, "status key"),
            Objects.requireNonNull(v, v == null ? "status value for key: " + k : null));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableVolume ImmutableVolume}.
     * @return An immutable instance of Volume
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableVolume build() {
      return new ImmutableVolume(
          name,
          driver,
          driverOpts == null ? null : createUnmodifiableMap(false, false, driverOpts),
          options == null ? null : createUnmodifiableMap(false, false, options),
          labels == null ? null : createUnmodifiableMap(false, false, labels),
          mountpoint,
          scope,
          status == null ? null : createUnmodifiableMap(false, false, status));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
