/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xinclude;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.junit.jupiter.api.Test;

public class XIncludeDocumentLinkTest
extends AbstractCacheBasedTest {
    @Test
    public void includeHrefAtFirstLevel() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<book xmlns:xi=\"http://www.w3.org/2001/XInclude\"> \n  <xi:include href=\"reference.xml\" />\n</book>\n";
        XMLAssert.testDocumentLinkFor(xml, "src/test/resources/xinclude/main.xml", XMLAssert.dl(XMLAssert.r(2, 20, 2, 33), "src/test/resources/xinclude/reference.xml"));
    }

    @Test
    public void includeHrefInAnyLevel() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<book xmlns:xi=\"http://www.w3.org/2001/XInclude\"> \n  <author> \n    <xi:include href=\"reference.xml\" />\n  </author>\n</book>\n";
        XMLAssert.testDocumentLinkFor(xml, "src/test/resources/xinclude/main.xml", XMLAssert.dl(XMLAssert.r(3, 22, 3, 35), "src/test/resources/xinclude/reference.xml"));
    }
}

