/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.commands;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.contentmodel.BaseFileTempTest;
import org.eclipse.lemminx.extensions.contentmodel.commands.SurroundWithCommand;
import org.junit.jupiter.api.Test;

public class SurroundWithCDATACommandTest
extends BaseFileTempTest {
    @Test
    public void surroundInText() throws Exception {
        String xml = "<foo>\r\n\ts|ome te|xt\r\n</foo>";
        String expected = "<foo>\r\n\ts<![CDATA[ome te]]>$0xt\r\n</foo>";
        XMLAssert.assertSurroundWith(xml, SurroundWithCommand.SurroundWithKind.cdata, true, expected);
    }

    @Test
    public void surroundInStartTag() throws Exception {
        String xml = "<fo|o>\r\n\tsom|e text\r\n</foo>";
        String expected = "<fo<![CDATA[o>\r\n\tsom]]>$0e text\r\n</foo>";
        XMLAssert.assertSurroundWith(xml, SurroundWithCommand.SurroundWithKind.cdata, true, expected);
    }

    @Test
    public void surroundEmptySelectionInText() throws Exception {
        String xml = "<foo>\r\n\ts|ome text\r\n</foo>";
        String expected = "<foo>\r\n\ts<![CDATA[$1]]>$0ome text\r\n</foo>";
        XMLAssert.assertSurroundWith(xml, SurroundWithCommand.SurroundWithKind.cdata, true, expected);
    }

    @Test
    public void surroundEmptySelectionInStartTag() throws Exception {
        String xml = "<f|oo>\r\n\tsome text\r\n</foo>";
        String expected = "<![CDATA[$1<foo>\r\n\tsome text\r\n</foo>]]>$0";
        XMLAssert.assertSurroundWith(xml, SurroundWithCommand.SurroundWithKind.cdata, true, expected);
    }

    @Test
    public void surroundEmptySelectionInEndTag() throws Exception {
        String xml = "<foo>\r\n\tsome text\r\n</fo|o>";
        String expected = "<![CDATA[$1<foo>\r\n\tsome text\r\n</foo>]]>$0";
        XMLAssert.assertSurroundWith(xml, SurroundWithCommand.SurroundWithKind.cdata, true, expected);
    }
}

