/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.filepath;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.filepath.IFilePathExpression;
import org.eclipse.lemminx.extensions.filepath.IFilePathSupportParticipant;
import org.eclipse.lemminx.extensions.filepath.participants.FilePathCompletionParticipant;
import org.eclipse.lemminx.extensions.filepath.settings.FilePathMapping;
import org.eclipse.lemminx.extensions.filepath.settings.FilePathSupportSettings;
import org.eclipse.lemminx.services.extensions.IXMLExtension;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.save.ISaveContext;
import org.eclipse.lsp4j.InitializeParams;

public class FilePathPlugin
implements IXMLExtension {
    private static final Logger LOGGER = Logger.getLogger(FilePathPlugin.class.getName());
    private final FilePathCompletionParticipant completionParticipant = new FilePathCompletionParticipant(this);
    private FilePathSupportSettings filePathsSettings;
    private List<IFilePathSupportParticipant> filePathSupportParticipants;

    @Override
    public void doSave(ISaveContext context) {
        if (context.getType() != ISaveContext.SaveContextType.DOCUMENT) {
            this.updateSettings(context);
        }
    }

    private void updateSettings(ISaveContext saveContext) {
        Object initializationOptionsSettings = saveContext.getSettings();
        FilePathSupportSettings settings = FilePathSupportSettings.getFilePathsSettings(initializationOptionsSettings);
        this.updateSettings(settings, saveContext);
    }

    private void updateSettings(FilePathSupportSettings settings, ISaveContext context) {
        this.filePathsSettings = settings;
    }

    @Override
    public void start(InitializeParams params, XMLExtensionsRegistry registry) {
        registry.registerCompletionParticipant(this.completionParticipant);
    }

    @Override
    public void stop(XMLExtensionsRegistry registry) {
        registry.unregisterCompletionParticipant(this.completionParticipant);
    }

    public FilePathSupportSettings getFilePathsSettings() {
        return this.filePathsSettings;
    }

    public List<IFilePathExpression> findFilePathExpressions(DOMDocument xmlDocument) {
        ArrayList<IFilePathExpression> expressions = new ArrayList<IFilePathExpression>();
        this.fillFromParticipants(xmlDocument, expressions);
        this.fillFromUserSettings(xmlDocument, expressions);
        return expressions;
    }

    private void fillFromParticipants(DOMDocument xmlDocument, List<IFilePathExpression> allExpressions) {
        for (IFilePathSupportParticipant participant : this.getFilePathSupportParticipants()) {
            List<IFilePathExpression> expressions = participant.collectFilePathExpressions(xmlDocument);
            if (expressions == null || expressions.isEmpty()) continue;
            allExpressions.addAll(expressions);
        }
    }

    private void fillFromUserSettings(DOMDocument xmlDocument, List<IFilePathExpression> expressions) {
        FilePathSupportSettings settings = this.getFilePathsSettings();
        if (settings == null) {
            return;
        }
        List<FilePathMapping> mappings = settings.getFilePathMappings();
        FilePathPlugin.fillFromMappings(xmlDocument, mappings, expressions);
    }

    private static void fillFromMappings(DOMDocument xmlDocument, List<FilePathMapping> mappings, List<IFilePathExpression> expressions) {
        if (mappings == null) {
            return;
        }
        for (FilePathMapping filePaths : mappings) {
            if (!filePaths.matches(xmlDocument.getDocumentURI())) continue;
            expressions.addAll(filePaths.getExpressions());
        }
    }

    public List<IFilePathSupportParticipant> getFilePathSupportParticipants() {
        if (this.filePathSupportParticipants == null) {
            this.loadFilePathSupportParticipants();
        }
        return this.filePathSupportParticipants;
    }

    private synchronized void loadFilePathSupportParticipants() {
        if (this.filePathSupportParticipants != null) {
            return;
        }
        ArrayList<IFilePathSupportParticipant> participants = new ArrayList<IFilePathSupportParticipant>();
        Iterator<IFilePathSupportParticipant> extensions = ServiceLoader.load(IFilePathSupportParticipant.class).iterator();
        while (extensions.hasNext()) {
            try {
                participants.add(extensions.next());
            }
            catch (ServiceConfigurationError e) {
                LOGGER.log(Level.SEVERE, "Error while instantiating file path support participant", e);
            }
        }
        this.filePathSupportParticipants = participants;
    }
}

