/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.shared.validator;

import java.util.function.Consumer;
import org.eclipse.kura.web.shared.validator.Validator;

public class PunctuatedAlphanumericSequenceValidator
implements Validator<String> {
    private final char[] delimiters;
    private final String message;
    private static final String ALPHANUMERIC_PATTERN = "[a-zA-Z0-9]+";

    public PunctuatedAlphanumericSequenceValidator(char[] delimiters, String message) {
        this.delimiters = delimiters;
        this.message = message;
    }

    private boolean isDelimiter(char value) {
        char[] cArray = this.delimiters;
        int n = this.delimiters.length;
        int n2 = 0;
        while (n2 < n) {
            char delimiter = cArray[n2];
            if (value == delimiter) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void requireNonEmptyAlphanumericString(String value) {
        if (!value.matches(ALPHANUMERIC_PATTERN)) {
            throw new IllegalArgumentException(this.message);
        }
    }

    @Override
    public void validate(String value, Consumer<String> errorMessageConsumer) {
        if (value == null) {
            return;
        }
        try {
            StringBuilder component = new StringBuilder();
            int i = 0;
            while (i < value.length()) {
                char c = value.charAt(i);
                if (this.isDelimiter(c)) {
                    this.requireNonEmptyAlphanumericString(component.toString());
                    component.setLength(0);
                } else {
                    component.append(c);
                }
                ++i;
            }
            this.requireNonEmptyAlphanumericString(component.toString());
        }
        catch (Exception exception) {
            errorMessageConsumer.accept(this.message);
        }
    }
}

