/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.audit.AuditContext;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.core.configuration.ConfigurationChangeEvent;
import org.eclipse.kura.core.configuration.ConfigurationServiceImpl;
import org.osgi.framework.Filter;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationServiceAuditFacade
extends ConfigurationServiceImpl {
    private static final String CONFIGURATION_SERVICE_FAILURE = "{} ConfigurationService - Failure - {}";
    private static final String CONFIGURATION_SERVICE_SUCCESS = "{} ConfigurationService - Success - {}";
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"AuditLogger");

    @Override
    public synchronized void createFactoryConfiguration(String factoryPid, String pid, Map<String, Object> properties, boolean takeSnapshot) throws KuraException {
        ConfigurationServiceAuditFacade.audit(() -> super.createFactoryConfiguration(factoryPid, pid, properties, takeSnapshot), "Create factory configuration " + factoryPid + " " + pid);
        this.postConfigurationChangedEvent(pid);
    }

    @Override
    public synchronized void deleteFactoryConfiguration(String pid, boolean takeSnapshot) throws KuraException {
        ConfigurationServiceAuditFacade.audit(() -> super.deleteFactoryConfiguration(pid, takeSnapshot), "Delete factory configuration: " + pid);
        this.postConfigurationChangedEvent(pid);
    }

    @Override
    public List<ComponentConfiguration> getComponentConfigurations() throws KuraException {
        return ConfigurationServiceAuditFacade.audit(() -> super.getComponentConfigurations(), "Get component configurations");
    }

    @Override
    public List<ComponentConfiguration> getComponentConfigurations(Filter filter) throws KuraException {
        return ConfigurationServiceAuditFacade.audit(() -> super.getComponentConfigurations(filter), "Get component configurations: " + filter);
    }

    @Override
    public ComponentConfiguration getComponentConfiguration(String pid) throws KuraException {
        return ConfigurationServiceAuditFacade.audit(() -> super.getComponentConfiguration(pid), "Get component configuration: " + pid);
    }

    @Override
    public synchronized void updateConfiguration(String pid, Map<String, Object> properties) throws KuraException {
        ConfigurationServiceAuditFacade.audit(() -> super.updateConfiguration(pid, properties), "Update configuration: " + pid);
        this.postConfigurationChangedEvent(pid);
    }

    @Override
    public synchronized void updateConfiguration(String pid, Map<String, Object> properties, boolean takeSnapshot) throws KuraException {
        ConfigurationServiceAuditFacade.audit(() -> super.updateConfiguration(pid, properties, takeSnapshot), "Update configuration: " + pid);
        this.postConfigurationChangedEvent(pid);
    }

    @Override
    public synchronized void updateConfigurations(List<ComponentConfiguration> configs) throws KuraException {
        ConfigurationServiceAuditFacade.audit(() -> super.updateConfigurations(configs), "Update configurations: " + this.formatConfigurationPids(configs));
        this.postConfigurationChangedEvent(this.formatConfigurationPids(configs));
    }

    @Override
    public synchronized void updateConfigurations(List<ComponentConfiguration> configs, boolean takeSnapshot) throws KuraException {
        ConfigurationServiceAuditFacade.audit(() -> super.updateConfigurations(configs, takeSnapshot), "Update configurations: " + this.formatConfigurationPids(configs));
        this.postConfigurationChangedEvent(this.formatConfigurationPids(configs));
    }

    @Override
    public List<ComponentConfiguration> getSnapshot(long sid) throws KuraException {
        return ConfigurationServiceAuditFacade.audit(() -> super.getSnapshot(sid), "Get snapshot: " + sid);
    }

    @Override
    public long snapshot() throws KuraException {
        this.postConfigurationChangedEvent("");
        return ConfigurationServiceAuditFacade.audit(() -> super.snapshot(), "Take snapshot");
    }

    @Override
    public long rollback() throws KuraException {
        this.postConfigurationChangedEvent("");
        return ConfigurationServiceAuditFacade.audit(() -> super.rollback(), "Rollback latest snapshot");
    }

    @Override
    public synchronized void rollback(long id) throws KuraException {
        ConfigurationServiceAuditFacade.audit(() -> super.rollback(id), "Rollback snapshot: " + id);
        this.postConfigurationChangedEvent("");
    }

    private static <T, E extends Throwable> T audit(FallibleSupplier<T, E> task, String message) throws E {
        try {
            T result = task.get();
            auditLogger.info(CONFIGURATION_SERVICE_SUCCESS, (Object)AuditContext.currentOrInternal(), (Object)message);
            return result;
        }
        catch (Exception e) {
            auditLogger.warn(CONFIGURATION_SERVICE_FAILURE, (Object)AuditContext.currentOrInternal(), (Object)message);
            throw e;
        }
    }

    private static <E extends Throwable> void audit(FallibleTask<E> task, String message) throws E {
        try {
            task.run();
            auditLogger.info(CONFIGURATION_SERVICE_SUCCESS, (Object)AuditContext.currentOrInternal(), (Object)message);
        }
        catch (Exception e) {
            auditLogger.warn(CONFIGURATION_SERVICE_FAILURE, (Object)AuditContext.currentOrInternal(), (Object)message);
            throw e;
        }
    }

    private String formatConfigurationPids(List<ComponentConfiguration> configs) {
        return configs.stream().map(ComponentConfiguration::getPid).reduce("", (a, b) -> String.valueOf(a) + " " + b);
    }

    private void postConfigurationChangedEvent(String pid) {
        Optional auditContext = AuditContext.current();
        if (auditContext.isPresent()) {
            String sessionId = (String)((AuditContext)auditContext.get()).getProperties().get("session.id");
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("pid", pid);
            properties.put("session", sessionId);
            if (sessionId != null) {
                this.eventAdmin.postEvent((Event)new ConfigurationChangeEvent(properties));
            }
        }
    }

    private static interface FallibleSupplier<T, E extends Throwable> {
        public T get() throws E;
    }

    private static interface FallibleTask<E extends Throwable> {
        public void run() throws E;
    }
}

