/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.deployment.install;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraInvalidMessageException;
import org.eclipse.kura.core.deployment.DeploymentPackageOptions;
import org.eclipse.kura.core.deployment.download.DownloadFileUtilities;
import org.eclipse.kura.core.deployment.hook.DeploymentHookManager;
import org.eclipse.kura.deployment.hook.DeploymentHook;
import org.eclipse.kura.deployment.hook.RequestContext;
import org.eclipse.kura.message.KuraPayload;

public class DeploymentPackageInstallOptions
extends DeploymentPackageOptions {
    public static final String METRIC_DP_INSTALL_SYSTEM_UPDATE = "dp.install.system.update";
    public static final String METRIC_INSTALL_VERIFIER_URI = "dp.install.verifier.uri";
    public static final String METRIC_REQUEST_TYPE = "request.type";
    public static final String METRIC_HOOK_PROPERTIES = "hook.properties";
    private Boolean systemUpdate = false;
    private String verifierURI = null;
    private String requestType;
    private Map<String, Object> hookProperties = new HashMap<String, Object>();
    private DeploymentHook deploymentHook;
    private String downloadDirectory = "/tmp";
    private RequestContext hookRequestContext;

    public DeploymentPackageInstallOptions(String dpName, String dpVersion) {
        super(dpName, dpVersion);
    }

    public DeploymentPackageInstallOptions(KuraPayload request, DeploymentHookManager hookManager, String downloadDirectory) throws KuraException {
        super(null, null);
        this.setDownloadDirectory(downloadDirectory);
        super.setDpName((String)request.getMetric("dp.name"));
        if (super.getDpName() == null) {
            throw new KuraInvalidMessageException((Object)"Missing deployment package name!");
        }
        super.setDpVersion((String)request.getMetric("dp.version"));
        if (super.getDpVersion() == null) {
            throw new KuraInvalidMessageException((Object)"Missing deployment package version!");
        }
        Long jobId = (Long)request.getMetric("job.id");
        if (jobId != null) {
            super.setJobId(jobId);
        }
        if (super.getJobId() == null) {
            throw new KuraInvalidMessageException((Object)"Missing jobId!");
        }
        this.setSystemUpdate((Boolean)request.getMetric(METRIC_DP_INSTALL_SYSTEM_UPDATE));
        if (this.getSystemUpdate() == null) {
            throw new KuraInvalidMessageException((Object)"Missing System Update!");
        }
        try {
            Object metric = request.getMetric("dp.reboot");
            if (metric != null) {
                super.setReboot((Boolean)metric);
            }
            if ((metric = request.getMetric("dp.reboot.delay")) != null) {
                super.setRebootDelay((Integer)metric);
            }
            if ((metric = request.getMetric("requester.client.id")) != null) {
                super.setRequestClientId((String)metric);
            }
            if ((metric = request.getMetric(METRIC_INSTALL_VERIFIER_URI)) != null) {
                this.setVerifierURI((String)metric);
            }
            this.parseHookRelatedOptions(request, hookManager);
        }
        catch (Exception ex) {
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)ex, new Object[0]);
        }
    }

    public void setSystemUpdate(Boolean systemUpdate) {
        this.systemUpdate = systemUpdate;
    }

    public Boolean getSystemUpdate() {
        return this.systemUpdate;
    }

    public void setVerifierURI(String verifierURI) {
        this.verifierURI = verifierURI;
    }

    public void setDownloadDirectory(String downloadDirectory) {
        this.downloadDirectory = downloadDirectory;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public void setHookProperties(Map<String, Object> hookProperties) {
        this.hookProperties = hookProperties;
    }

    public void setHookRequestContext(RequestContext hookRequestContext) {
        this.hookRequestContext = hookRequestContext;
    }

    public void setDeploymentHook(DeploymentHook hook) {
        this.deploymentHook = hook;
    }

    public String getVerifierURL() {
        return this.verifierURI;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public Map<String, Object> getHookProperties() {
        return this.hookProperties;
    }

    public DeploymentHook getDeploymentHook() {
        return this.deploymentHook;
    }

    public String getDownloadDirectory() {
        return this.downloadDirectory;
    }

    public RequestContext getHookRequestContext() {
        return this.hookRequestContext;
    }

    protected void parseHookRelatedOptions(KuraPayload request, DeploymentHookManager hookManager) throws IOException {
        Object metric = request.getMetric(METRIC_REQUEST_TYPE);
        if (metric != null) {
            this.setRequestType((String)metric);
            this.setDeploymentHook(hookManager.getHook(this.requestType));
            this.setHookRequestContext(new RequestContext(DownloadFileUtilities.getDpDownloadFile(this).getAbsolutePath(), this.requestType));
        } else {
            this.setDeploymentHook(null);
        }
        metric = request.getMetric(METRIC_HOOK_PROPERTIES);
        if (metric != null) {
            Properties hookProperties = new Properties();
            hookProperties.load(new StringReader((String)metric));
            this.setHookProperties(hookProperties.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue())));
        }
    }
}

