/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.camel.internal.camelcloud;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.function.IntSupplier;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StartupListener;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultShutdownStrategy;
import org.apache.camel.spi.ShutdownStrategy;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.camel.camelcloud.CamelCloudService;
import org.eclipse.kura.cloud.CloudClient;
import org.eclipse.kura.cloud.CloudClientListener;
import org.eclipse.kura.message.KuraPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelCloudClient
implements CloudClient {
    private static final Logger logger = LoggerFactory.getLogger(CamelCloudClient.class);
    private final CamelCloudService cloudService;
    private final CamelContext camelContext;
    private final ProducerTemplate producerTemplate;
    private final List<CloudClientListener> cloudClientListeners = new CopyOnWriteArrayList<CloudClientListener>();
    private final String applicationId;
    private final String baseEndpoint;
    private final ExecutorService executorService;
    private final Random messageIdRandom = new Random();
    private final IntSupplier messageIdGenerator = () -> Math.abs(this.messageIdRandom.nextInt());

    public CamelCloudClient(CamelCloudService cloudService, CamelContext camelContext, String applicationId, String baseEndpoint) {
        this.cloudService = cloudService;
        this.camelContext = camelContext;
        this.producerTemplate = camelContext.createProducerTemplate();
        this.applicationId = applicationId;
        this.baseEndpoint = baseEndpoint;
        this.executorService = camelContext.getExecutorServiceManager().newThreadPool((Object)this, "CamelCloudClient/" + applicationId, 0, 1);
    }

    public CamelCloudClient(CamelCloudService cloudService, CamelContext camelContext, String applicationId) {
        this(cloudService, camelContext, applicationId, "vm:%s");
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void release() {
        this.cloudService.release(this.applicationId);
        this.camelContext.getExecutorServiceManager().shutdown(this.executorService);
    }

    public boolean isConnected() {
        return this.camelContext.getStatus() == ServiceStatus.Started;
    }

    public int publish(String topic, KuraPayload kuraPayload, int qos, boolean retain) throws KuraException {
        return this.publish(topic, kuraPayload, qos, retain, 5);
    }

    public int publish(String deviceId, String appTopic, KuraPayload payload, int qos, boolean retain) throws KuraException {
        return this.doPublish(false, deviceId, appTopic, payload, qos, retain, 5);
    }

    public int publish(String topic, KuraPayload kuraPayload, int qos, boolean retain, int priority) throws KuraException {
        return this.doPublish(false, null, topic, kuraPayload, qos, retain, priority);
    }

    public int publish(String deviceId, String appTopic, KuraPayload payload, int qos, boolean retain, int priority) throws KuraException {
        return this.doPublish(false, deviceId, appTopic, payload, qos, retain, priority);
    }

    public int publish(String topic, byte[] payload, int qos, boolean retain, int priority) throws KuraException {
        KuraPayload kuraPayload = new KuraPayload();
        kuraPayload.setBody(payload);
        return this.publish(topic, kuraPayload, qos, retain, priority);
    }

    public int publish(String deviceId, String appTopic, byte[] payload, int qos, boolean retain, int priority) throws KuraException {
        KuraPayload kuraPayload = new KuraPayload();
        kuraPayload.setBody(payload);
        return this.publish(deviceId, appTopic, kuraPayload, qos, retain, priority);
    }

    public int controlPublish(String topic, KuraPayload payload, int qos, boolean retain, int priority) throws KuraException {
        return this.doPublish(true, null, topic, payload, qos, retain, priority);
    }

    public int controlPublish(String deviceId, String topic, KuraPayload kuraPayload, int qos, boolean retain, int priority) throws KuraException {
        return this.doPublish(true, deviceId, topic, kuraPayload, qos, retain, priority);
    }

    public int controlPublish(String deviceId, String topic, byte[] payload, int qos, boolean retain, int priority) throws KuraException {
        KuraPayload kuraPayload = new KuraPayload();
        kuraPayload.setBody(payload);
        return this.doPublish(true, deviceId, topic, kuraPayload, qos, retain, priority);
    }

    public void subscribe(String topic, int qos) throws KuraException {
        this.forkSubscribe(false, null, topic, qos);
    }

    public void subscribe(String deviceId, String appTopic, int qos) throws KuraException {
        this.forkSubscribe(false, deviceId, appTopic, qos);
    }

    public void controlSubscribe(String topic, int qos) throws KuraException {
        this.forkSubscribe(true, null, topic, qos);
    }

    public void controlSubscribe(String deviceId, String appTopic, int qos) throws KuraException {
        this.forkSubscribe(true, deviceId, appTopic, qos);
    }

    public void unsubscribe(String topic) throws KuraException {
        this.doUnsubscribe(null, topic);
    }

    public void unsubscribe(String deviceId, String appTopic) throws KuraException {
        this.doUnsubscribe(deviceId, appTopic);
    }

    public void controlUnsubscribe(String topic) throws KuraException {
        this.doUnsubscribe(null, topic);
    }

    public void controlUnsubscribe(String deviceId, String appTopic) throws KuraException {
        this.doUnsubscribe(deviceId, appTopic);
    }

    public void addCloudClientListener(CloudClientListener cloudClientListener) {
        this.cloudClientListeners.add(cloudClientListener);
    }

    public void removeCloudClientListener(CloudClientListener cloudClientListener) {
        this.cloudClientListeners.remove(cloudClientListener);
    }

    public List<Integer> getUnpublishedMessageIds() throws KuraException {
        return Collections.emptyList();
    }

    public List<Integer> getInFlightMessageIds() throws KuraException {
        return Collections.emptyList();
    }

    public List<Integer> getDroppedInFlightMessageIds() throws KuraException {
        return Collections.emptyList();
    }

    private void doUnsubscribe(String deviceId, String topic) throws KuraException {
        String internalQueue = this.buildTopicName(deviceId, topic);
        try {
            ShutdownStrategy strategy = this.camelContext.getShutdownStrategy();
            if (strategy instanceof DefaultShutdownStrategy && ((DefaultShutdownStrategy)strategy).getCurrentShutdownTaskFuture() != null) {
                logger.info("Skipping cleanup of '{}' since the camel context is being shut down", (Object)internalQueue);
                return;
            }
            this.camelContext.stopRoute(internalQueue);
            this.camelContext.removeRoute(internalQueue);
        }
        catch (Exception e) {
            throw new KuraException(KuraErrorCode.SUBSCRIPTION_ERROR, (Throwable)e, new Object[]{internalQueue});
        }
    }

    private String buildTopicName(String deviceId, String topic) {
        Objects.requireNonNull(topic, "'topic' must not be null");
        if (deviceId == null) {
            return String.format("%s:%s", this.applicationId, topic);
        }
        return String.format("%s:%s:%s", deviceId, this.applicationId, topic);
    }

    private int doPublish(boolean isControl, String deviceId, String topic, KuraPayload kuraPayload, int qos, boolean retain, int priority) throws KuraException {
        String target = this.target(this.buildTopicName(deviceId, topic));
        int kuraMessageId = this.messageIdGenerator.getAsInt();
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("CamelKuraCloudService.control", isControl);
        headers.put("CamelKuraCloudService.messageId", kuraMessageId);
        headers.put("CamelKuraCloudService.deviceId", deviceId);
        headers.put("CamelKuraCloudService.qos", qos);
        headers.put("CamelKuraCloudService.retain", retain);
        headers.put("CamelKuraCloudService.priority", priority);
        logger.trace("Publishing: {} -> {} / {}", new Object[]{target, kuraPayload, this.camelContext});
        this.producerTemplate.sendBodyAndHeaders(target, (Object)kuraPayload, headers);
        return kuraMessageId;
    }

    private void forkSubscribe(final boolean isControl, final String deviceId, final String topic, final int qos) throws KuraException {
        try {
            this.camelContext.addStartupListener(new StartupListener(){

                public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
                    CamelCloudClient.this.executorService.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            CamelCloudClient.this.doSubscribe(isControl, deviceId, topic, qos);
                            return null;
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            throw new KuraException(KuraErrorCode.SUBSCRIPTION_ERROR, (Throwable)e, new Object[]{this.buildTopicName(deviceId, topic)});
        }
    }

    private void doSubscribe(boolean isControl, String deviceId, String topic, int qos) throws KuraException {
        logger.debug("About to subscribe to topic {}:{} with QOS {}.", new Object[]{deviceId, topic, qos});
        final String internalQueue = this.buildTopicName(deviceId, topic);
        logger.debug("\tInternal target: {} / {}", (Object)this.target(internalQueue), (Object)this.camelContext);
        try {
            this.camelContext.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.from(CamelCloudClient.this.target(internalQueue)).routeId(internalQueue).process(new Processor(){

                        public void process(Exchange exchange) throws Exception {
                            logger.debug("Processing: {}", (Object)exchange);
                            for (CloudClientListener listener : CamelCloudClient.this.cloudClientListeners) {
                                KuraPayload payload;
                                logger.debug("\t{}", (Object)listener);
                                Object body = exchange.getIn().getBody();
                                if (body instanceof KuraPayload) {
                                    payload = (KuraPayload)body;
                                } else {
                                    payload = new KuraPayload();
                                    payload.setBody((byte[])this.getContext().getTypeConverter().convertTo(byte[].class, body));
                                }
                                String deviceId = (String)exchange.getIn().getHeader("CamelKuraCloudService.deviceId", String.class);
                                int qos = (Integer)exchange.getIn().getHeader("CamelKuraCloudService.qos", (Object)0, Integer.TYPE);
                                listener.onMessageArrived(deviceId, "camel", payload, qos, true);
                            }
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            logger.warn("Error while adding subscription route. Rethrowing root cause.");
            throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, (Throwable)e, new Object[0]);
        }
    }

    private String target(String topic) {
        if (this.baseEndpoint.contains("%s")) {
            return String.format(this.baseEndpoint, topic);
        }
        return String.valueOf(this.baseEndpoint) + topic;
    }
}

