/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.engine.Mode;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.FileStoreOutputStream;
import org.h2.store.LobStorageInterface;
import org.h2.store.RangeReader;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.ExtTypeInfo;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueLob;

public class ValueLobDb
extends Value {
    private final int valueType;
    private TypeInfo type;
    private final int tableId;
    private final long lobId;
    private final byte[] hmac;
    private final byte[] small;
    private final DataHandler handler;
    private final long precision;
    private final String fileName;
    private final FileStore tempFile;
    private int hash;
    private boolean isRecoveryReference;

    private ValueLobDb(int n, DataHandler dataHandler, int n2, long l, byte[] byArray, long l2) {
        this.valueType = n;
        this.handler = dataHandler;
        this.tableId = n2;
        this.lobId = l;
        this.hmac = byArray;
        this.precision = l2;
        this.small = null;
        this.fileName = null;
        this.tempFile = null;
    }

    private ValueLobDb(int n, byte[] byArray, long l) {
        this.valueType = n;
        this.small = byArray;
        this.precision = l;
        this.lobId = 0L;
        this.hmac = null;
        this.handler = null;
        this.fileName = null;
        this.tempFile = null;
        this.tableId = 0;
    }

    private ValueLobDb(DataHandler dataHandler, Reader reader, long l) throws IOException {
        this.valueType = 16;
        this.handler = dataHandler;
        this.small = null;
        this.lobId = 0L;
        this.hmac = null;
        this.fileName = ValueLobDb.createTempLobFileName(dataHandler);
        this.tempFile = this.handler.openFile(this.fileName, "rw", false);
        this.tempFile.autoDelete();
        long l2 = 0L;
        try (FileStoreOutputStream fileStoreOutputStream = new FileStoreOutputStream(this.tempFile, null, null);){
            char[] cArray = new char[4096];
            while (true) {
                int n = ValueLobDb.getBufferSize(this.handler, false, l);
                if ((n = IOUtils.readFully(reader, cArray, n)) == 0) {
                    break;
                }
                byte[] byArray = new String(cArray, 0, n).getBytes(StandardCharsets.UTF_8);
                fileStoreOutputStream.write(byArray);
                l2 += (long)n;
            }
        }
        this.precision = l2;
        this.tableId = 0;
    }

    private ValueLobDb(DataHandler dataHandler, byte[] byArray, int n, InputStream inputStream, long l) throws IOException {
        this.valueType = 15;
        this.handler = dataHandler;
        this.small = null;
        this.lobId = 0L;
        this.hmac = null;
        this.fileName = ValueLobDb.createTempLobFileName(dataHandler);
        this.tempFile = this.handler.openFile(this.fileName, "rw", false);
        this.tempFile.autoDelete();
        long l2 = 0L;
        boolean bl = this.handler.getLobCompressionAlgorithm(15) != null;
        try (FileStoreOutputStream fileStoreOutputStream = new FileStoreOutputStream(this.tempFile, null, null);){
            do {
                l2 += (long)n;
                fileStoreOutputStream.write(byArray, 0, n);
                if ((l -= (long)n) <= 0L) {
                    break;
                }
                n = ValueLobDb.getBufferSize(this.handler, bl, l);
            } while ((n = IOUtils.readFully(inputStream, byArray, n)) > 0);
        }
        this.precision = l2;
        this.tableId = 0;
    }

    private static String createTempLobFileName(DataHandler dataHandler) throws IOException {
        String string = dataHandler.getDatabasePath();
        if (string.isEmpty()) {
            string = SysProperties.PREFIX_TEMP_FILE;
        }
        return FileUtils.createTempFile(string, ".temp.db", true);
    }

    public static ValueLobDb create(int n, DataHandler dataHandler, int n2, long l, byte[] byArray, long l2) {
        return new ValueLobDb(n, dataHandler, n2, l, byArray, l2);
    }

    @Override
    protected Value convertTo(int n, Mode mode, Object object, ExtTypeInfo extTypeInfo) {
        if (n == this.valueType) {
            return this;
        }
        if (n == 16) {
            if (this.handler != null) {
                return this.handler.getLobStorage().createClob(this.getReader(), -1L);
            }
            if (this.small != null) {
                return ValueLobDb.createSmallLob(n, this.small);
            }
        } else if (n == 15) {
            if (this.handler != null) {
                return this.handler.getLobStorage().createBlob(this.getInputStream(), -1L);
            }
            if (this.small != null) {
                return ValueLobDb.createSmallLob(n, this.small);
            }
        }
        return super.convertTo(n, mode, object, null);
    }

    @Override
    public boolean isLinkedToTable() {
        return this.small == null && this.tableId >= 0;
    }

    public boolean isStored() {
        return this.small == null && this.fileName == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        if (this.fileName != null) {
            if (this.tempFile != null) {
                this.tempFile.stopAutoDelete();
            }
            Object object = this.handler.getLobSyncObject();
            synchronized (object) {
                FileUtils.delete(this.fileName);
            }
        }
        if (this.handler != null) {
            this.handler.getLobStorage().removeLob(this);
        }
    }

    @Override
    public Value copy(DataHandler dataHandler, int n) {
        if (this.small == null) {
            return this.handler.getLobStorage().copyLob(this, n, this.precision);
        }
        if (this.small.length > dataHandler.getMaxLengthInplaceLob()) {
            LobStorageInterface lobStorageInterface = dataHandler.getLobStorage();
            Value value = this.valueType == 15 ? lobStorageInterface.createBlob(this.getInputStream(), this.precision) : lobStorageInterface.createClob(this.getReader(), this.precision);
            Value value2 = value.copy(dataHandler, n);
            value.remove();
            return value2;
        }
        return this;
    }

    @Override
    public int getTableId() {
        return this.tableId;
    }

    @Override
    public TypeInfo getType() {
        TypeInfo typeInfo = this.type;
        if (typeInfo == null) {
            this.type = typeInfo = new TypeInfo(this.valueType, this.precision, 0, MathUtils.convertLongToInt(this.precision), null);
        }
        return typeInfo;
    }

    @Override
    public int getValueType() {
        return this.valueType;
    }

    @Override
    public String getString() {
        int n = this.precision > Integer.MAX_VALUE || this.precision == 0L ? Integer.MAX_VALUE : (int)this.precision;
        try {
            if (this.valueType == 16) {
                if (this.small != null) {
                    return new String(this.small, StandardCharsets.UTF_8);
                }
                return IOUtils.readStringAndClose(this.getReader(), n);
            }
            byte[] byArray = this.small != null ? this.small : IOUtils.readBytesAndClose(this.getInputStream(), n);
            return StringUtils.convertBytesToHex(byArray);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.toString());
        }
    }

    @Override
    public byte[] getBytes() {
        if (this.valueType == 16) {
            return super.getBytes();
        }
        if (this.small != null) {
            return Utils.cloneByteArray(this.small);
        }
        try {
            return IOUtils.readBytesAndClose(this.getInputStream(), Integer.MAX_VALUE);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.toString());
        }
    }

    @Override
    public byte[] getBytesNoCopy() {
        if (this.valueType == 16) {
            return super.getBytesNoCopy();
        }
        if (this.small != null) {
            return this.small;
        }
        try {
            return IOUtils.readBytesAndClose(this.getInputStream(), Integer.MAX_VALUE);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.toString());
        }
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            if (this.precision > 4096L) {
                return (int)(this.precision ^ this.precision >>> 32);
            }
            this.hash = this.valueType == 16 ? this.getString().hashCode() : (this.small != null ? Utils.getByteArrayHash(this.small) : Utils.getByteArrayHash(this.getBytes()));
        }
        return this.hash;
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode) {
        if (value instanceof ValueLobDb) {
            ValueLobDb valueLobDb = (ValueLobDb)value;
            if (value == this) {
                return 0;
            }
            if (this.lobId == valueLobDb.lobId && this.small == null && valueLobDb.small == null) {
                return 0;
            }
        }
        return ValueLob.compare(this, value);
    }

    @Override
    public Object getObject() {
        if (this.valueType == 16) {
            return this.getReader();
        }
        return this.getInputStream();
    }

    @Override
    public Reader getReader() {
        return IOUtils.getBufferedReader(this.getInputStream());
    }

    @Override
    public Reader getReader(long l, long l2) {
        return ValueLob.rangeReader(this.getReader(), l, l2, this.valueType == 16 ? this.precision : -1L);
    }

    @Override
    public InputStream getInputStream() {
        if (this.small != null) {
            return new ByteArrayInputStream(this.small);
        }
        if (this.fileName != null) {
            FileStore fileStore = this.handler.openFile(this.fileName, "r", true);
            boolean bl = SysProperties.lobCloseBetweenReads;
            return new BufferedInputStream(new FileStoreInputStream(fileStore, this.handler, false, bl), 4096);
        }
        long l = this.valueType == 15 ? this.precision : -1L;
        try {
            return this.handler.getLobStorage().getInputStream(this, this.hmac, l);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.toString());
        }
    }

    @Override
    public InputStream getInputStream(long l, long l2) {
        InputStream inputStream;
        long l3;
        if (this.small != null) {
            return super.getInputStream(l, l2);
        }
        if (this.fileName != null) {
            FileStore fileStore = this.handler.openFile(this.fileName, "r", true);
            boolean bl = SysProperties.lobCloseBetweenReads;
            l3 = fileStore.length();
            inputStream = new BufferedInputStream(new FileStoreInputStream(fileStore, this.handler, false, bl), 4096);
        } else {
            l3 = this.valueType == 15 ? this.precision : -1L;
            try {
                inputStream = this.handler.getLobStorage().getInputStream(this, this.hmac, l3);
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, this.toString());
            }
        }
        return ValueLob.rangeInputStream(inputStream, l, l2, l3);
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        long l = this.precision;
        if (l > Integer.MAX_VALUE || l <= 0L) {
            l = -1L;
        }
        if (this.valueType == 15) {
            preparedStatement.setBinaryStream(n, this.getInputStream(), (int)l);
        } else {
            preparedStatement.setCharacterStream(n, this.getReader(), (int)l);
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        if (this.valueType == 16) {
            StringUtils.quoteStringSQL(stringBuilder, this.getString());
        } else {
            stringBuilder.append("X'");
            StringUtils.convertBytesToHex(stringBuilder, this.getBytes()).append('\'');
        }
        return stringBuilder;
    }

    @Override
    public String getTraceSQL() {
        if (this.small != null && this.precision <= SysProperties.MAX_TRACE_DATA_LENGTH) {
            return this.getSQL();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.valueType == 16) {
            stringBuilder.append("SPACE(").append(this.precision);
        } else {
            stringBuilder.append("CAST(REPEAT('00', ").append(this.precision).append(") AS BINARY");
        }
        stringBuilder.append(" /* table: ").append(this.tableId).append(" id: ").append(this.lobId).append(" */)");
        return stringBuilder.toString();
    }

    @Override
    public byte[] getSmall() {
        return this.small;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ValueLobDb)) {
            return false;
        }
        ValueLobDb valueLobDb = (ValueLobDb)object;
        if (this.hashCode() != valueLobDb.hashCode()) {
            return false;
        }
        return this.compareTypeSafe((Value)object, null) == 0;
    }

    @Override
    public int getMemory() {
        if (this.small != null) {
            return this.small.length + 127;
        }
        return 140;
    }

    @Override
    public ValueLobDb copyToTemp() {
        return this;
    }

    @Override
    public ValueLobDb copyToResult() {
        if (this.handler == null) {
            return this;
        }
        LobStorageInterface lobStorageInterface = this.handler.getLobStorage();
        if (lobStorageInterface.isReadOnly()) {
            return this;
        }
        return lobStorageInterface.copyLob(this, -3, this.precision);
    }

    public long getLobId() {
        return this.lobId;
    }

    @Override
    public String toString() {
        return "lob: " + this.fileName + " table: " + this.tableId + " id: " + this.lobId;
    }

    public static ValueLobDb createTempClob(Reader reader, long l, DataHandler dataHandler) {
        if (l >= 0L) {
            try {
                reader = new RangeReader(reader, 0L, l);
            }
            catch (IOException iOException) {
                throw DbException.convert(iOException);
            }
        }
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, 4096);
        try {
            char[] cArray;
            Object object;
            int n;
            boolean bl = dataHandler.getLobCompressionAlgorithm(16) != null;
            long l2 = Long.MAX_VALUE;
            if (l >= 0L && l < l2) {
                l2 = l;
            }
            if ((n = ValueLobDb.getBufferSize(dataHandler, bl, l2)) >= Integer.MAX_VALUE) {
                object = IOUtils.readStringAndClose(bufferedReader, -1);
                cArray = ((String)object).toCharArray();
                n = cArray.length;
            } else {
                cArray = new char[n];
                bufferedReader.mark(n);
                n = IOUtils.readFully(bufferedReader, cArray, n);
            }
            if (n <= dataHandler.getMaxLengthInplaceLob()) {
                object = new String(cArray, 0, n).getBytes(StandardCharsets.UTF_8);
                return ValueLobDb.createSmallLob(16, (byte[])object, n);
            }
            bufferedReader.reset();
            return new ValueLobDb(dataHandler, bufferedReader, l2);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    public static ValueLobDb createTempBlob(InputStream inputStream, long l, DataHandler dataHandler) {
        try {
            byte[] byArray;
            int n;
            boolean bl;
            long l2 = Long.MAX_VALUE;
            boolean bl2 = bl = dataHandler.getLobCompressionAlgorithm(15) != null;
            if (l >= 0L && l < l2) {
                l2 = l;
            }
            if ((n = ValueLobDb.getBufferSize(dataHandler, bl, l2)) >= Integer.MAX_VALUE) {
                byArray = IOUtils.readBytesAndClose(inputStream, -1);
                n = byArray.length;
            } else {
                byArray = Utils.newBytes(n);
                n = IOUtils.readFully(inputStream, byArray, n);
            }
            if (n <= dataHandler.getMaxLengthInplaceLob()) {
                byte[] byArray2 = Utils.copyBytes(byArray, n);
                return ValueLobDb.createSmallLob(15, byArray2, byArray2.length);
            }
            return new ValueLobDb(dataHandler, byArray, n, inputStream, l2);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    private static int getBufferSize(DataHandler dataHandler, boolean bl, long l) {
        long l2;
        if (l < 0L || l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        int n = dataHandler.getMaxLengthInplaceLob();
        long l3 = l2 = bl ? 131072L : 4096L;
        if (l2 < l && l2 <= (long)n) {
            l2 = Math.min(l, (long)n + 1L);
            l2 = MathUtils.roundUpLong(l2, 4096L);
        }
        l2 = Math.min(l, l2);
        if ((l2 = (long)MathUtils.convertLongToInt(l2)) < 0L) {
            l2 = Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    @Override
    public Value convertPrecision(long l, boolean bl) {
        ValueLobDb valueLobDb;
        if (this.precision <= l) {
            return this;
        }
        if (this.valueType == 16) {
            if (this.handler == null) {
                try {
                    int n = MathUtils.convertLongToInt(l);
                    String string = IOUtils.readStringAndClose(this.getReader(), n);
                    byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
                    valueLobDb = ValueLobDb.createSmallLob(this.valueType, byArray, string.length());
                }
                catch (IOException iOException) {
                    throw DbException.convertIOException(iOException, null);
                }
            } else {
                valueLobDb = ValueLobDb.createTempClob(this.getReader(), l, this.handler);
            }
        } else if (this.handler == null) {
            try {
                int n = MathUtils.convertLongToInt(l);
                byte[] byArray = IOUtils.readBytesAndClose(this.getInputStream(), n);
                valueLobDb = ValueLobDb.createSmallLob(this.valueType, byArray, byArray.length);
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, null);
            }
        } else {
            valueLobDb = ValueLobDb.createTempBlob(this.getInputStream(), l, this.handler);
        }
        return valueLobDb;
    }

    public static ValueLobDb createSmallLob(int n, byte[] byArray) {
        int n2 = n == 16 ? new String(byArray, StandardCharsets.UTF_8).length() : byArray.length;
        return ValueLobDb.createSmallLob(n, byArray, n2);
    }

    public static ValueLobDb createSmallLob(int n, byte[] byArray, long l) {
        return new ValueLobDb(n, byArray, l);
    }

    public void setRecoveryReference(boolean bl) {
        this.isRecoveryReference = bl;
    }

    public boolean isRecoveryReference() {
        return this.isRecoveryReference;
    }
}

