/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import io.moquette.broker.NettyUtils;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InflightResender
extends ChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger(InflightResender.class);
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private final long resenderTimeNanos;
    volatile ScheduledFuture<?> resenderTimeout;
    volatile long lastExecutionTime;
    private volatile int state;

    public InflightResender(long writerIdleTime, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.resenderTimeNanos = Math.max(unit.toNanos(writerIdleTime), MIN_TIMEOUT_NANOS);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isActive() && ctx.channel().isRegistered()) {
            this.initialize(ctx);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.destroy();
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isActive()) {
            this.initialize(ctx);
        }
        super.channelRegistered(ctx);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.initialize(ctx);
        super.channelActive(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.destroy();
        super.channelInactive(ctx);
    }

    private void initialize(ChannelHandlerContext ctx) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing autoflush handler on channel {}", (Object)ctx.channel());
        }
        switch (this.state) {
            case 1: 
            case 2: {
                return;
            }
        }
        this.state = 1;
        EventExecutor loop = ctx.executor();
        this.lastExecutionTime = System.nanoTime();
        this.resenderTimeout = loop.schedule(new WriterIdleTimeoutTask(ctx), this.resenderTimeNanos, TimeUnit.NANOSECONDS);
    }

    private void destroy() {
        this.state = 2;
        if (this.resenderTimeout != null) {
            this.resenderTimeout.cancel(false);
            this.resenderTimeout = null;
        }
    }

    private void resendNotAcked(ChannelHandlerContext ctx) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Flushing idle Netty channel {} for clientId: {}", (Object)ctx.channel(), (Object)NettyUtils.clientID(ctx.channel()));
        }
        ctx.fireUserEventTriggered(new ResendNotAckedPublishes());
    }

    private final class WriterIdleTimeoutTask
    implements Runnable {
        private final ChannelHandlerContext ctx;

        WriterIdleTimeoutTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void run() {
            if (!this.ctx.channel().isOpen()) {
                return;
            }
            long nextDelay = InflightResender.this.resenderTimeNanos - (System.nanoTime() - InflightResender.this.lastExecutionTime);
            if (nextDelay <= 0L) {
                InflightResender.this.resenderTimeout = this.ctx.executor().schedule(this, InflightResender.this.resenderTimeNanos, TimeUnit.NANOSECONDS);
                try {
                    InflightResender.this.resendNotAcked(this.ctx);
                }
                catch (Throwable t) {
                    this.ctx.fireExceptionCaught(t);
                }
            } else {
                InflightResender.this.resenderTimeout = this.ctx.executor().schedule(this, nextDelay, TimeUnit.NANOSECONDS);
            }
        }
    }

    public static class ResendNotAckedPublishes {
    }
}

