/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.util.Arrays;
import java.util.Collection;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FixedSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.PrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeEncoding;

public class UnsignedIntegerType
extends AbstractPrimitiveType<UnsignedInteger> {
    private UnsignedIntegerEncoding _unsignedIntegerEncoding;
    private UnsignedIntegerEncoding _smallUnsignedIntegerEncoding;
    private UnsignedIntegerEncoding _zeroUnsignedIntegerEncoding;

    UnsignedIntegerType(EncoderImpl encoder, DecoderImpl decoder) {
        this._unsignedIntegerEncoding = new AllUnsignedIntegerEncoding(encoder, decoder);
        this._smallUnsignedIntegerEncoding = new SmallUnsignedIntegerEncoding(encoder, decoder);
        this._zeroUnsignedIntegerEncoding = new ZeroUnsignedIntegerEncoding(encoder, decoder);
        encoder.register(UnsignedInteger.class, this);
        decoder.register(this);
    }

    @Override
    public Class<UnsignedInteger> getTypeClass() {
        return UnsignedInteger.class;
    }

    public UnsignedIntegerEncoding getEncoding(UnsignedInteger val) {
        int i = val.intValue();
        return i == 0 ? this._zeroUnsignedIntegerEncoding : (i >= 0 && i <= 255 ? this._smallUnsignedIntegerEncoding : this._unsignedIntegerEncoding);
    }

    public void fastWrite(EncoderImpl encoder, UnsignedInteger value) {
        int intValue = value.intValue();
        if (intValue == 0) {
            encoder.writeRaw((byte)67);
        } else if (intValue > 0 && intValue <= 255) {
            encoder.writeRaw((byte)82);
            encoder.writeRaw((byte)intValue);
        } else {
            encoder.writeRaw((byte)112);
            encoder.writeRaw(intValue);
        }
    }

    public UnsignedIntegerEncoding getCanonicalEncoding() {
        return this._unsignedIntegerEncoding;
    }

    @Override
    public Collection<UnsignedIntegerEncoding> getAllEncodings() {
        return Arrays.asList(this._unsignedIntegerEncoding, this._smallUnsignedIntegerEncoding, this._zeroUnsignedIntegerEncoding);
    }

    private class ZeroUnsignedIntegerEncoding
    extends FixedSizePrimitiveTypeEncoding<UnsignedInteger>
    implements UnsignedIntegerEncoding {
        public ZeroUnsignedIntegerEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        public byte getEncodingCode() {
            return 67;
        }

        @Override
        protected int getFixedSize() {
            return 0;
        }

        public UnsignedIntegerType getType() {
            return UnsignedIntegerType.this;
        }

        @Override
        public void writeValue(UnsignedInteger val) {
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<UnsignedInteger> encoder) {
            return encoder == this;
        }

        @Override
        public UnsignedInteger readValue() {
            return UnsignedInteger.ZERO;
        }
    }

    private class SmallUnsignedIntegerEncoding
    extends FixedSizePrimitiveTypeEncoding<UnsignedInteger>
    implements UnsignedIntegerEncoding {
        public SmallUnsignedIntegerEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        public byte getEncodingCode() {
            return 82;
        }

        @Override
        protected int getFixedSize() {
            return 1;
        }

        public UnsignedIntegerType getType() {
            return UnsignedIntegerType.this;
        }

        @Override
        public void writeValue(UnsignedInteger val) {
            this.getEncoder().writeRaw((byte)val.intValue());
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<UnsignedInteger> encoder) {
            return encoder == this || encoder instanceof ZeroUnsignedIntegerEncoding;
        }

        @Override
        public UnsignedInteger readValue() {
            return UnsignedInteger.valueOf(this.getDecoder().readRawByte() & 0xFF);
        }
    }

    private class AllUnsignedIntegerEncoding
    extends FixedSizePrimitiveTypeEncoding<UnsignedInteger>
    implements UnsignedIntegerEncoding {
        public AllUnsignedIntegerEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected int getFixedSize() {
            return 4;
        }

        @Override
        public byte getEncodingCode() {
            return 112;
        }

        public UnsignedIntegerType getType() {
            return UnsignedIntegerType.this;
        }

        @Override
        public void writeValue(UnsignedInteger val) {
            this.getEncoder().writeRaw(val.intValue());
        }

        public void write(int i) {
            this.writeConstructor();
            this.getEncoder().writeRaw(i);
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<UnsignedInteger> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public UnsignedInteger readValue() {
            return UnsignedInteger.valueOf(this.getDecoder().readRawInt());
        }
    }

    public static interface UnsignedIntegerEncoding
    extends PrimitiveTypeEncoding<UnsignedInteger> {
    }
}

