/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.spi.ReloadStrategy;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.LRUCacheFactory;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.XmlLineNumberParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ReloadStrategySupport
extends ServiceSupport
implements ReloadStrategy {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected Map<String, Object> cache;
    private CamelContext camelContext;
    private int succeeded;
    private int failed;

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void onReloadXml(CamelContext camelContext, String name, InputStream resource) {
        Document dom;
        String xml;
        this.log.debug("Reloading routes from XML resource: {}", (Object)name);
        try {
            xml = camelContext.getTypeConverter().mandatoryConvertTo(String.class, resource);
            dom = XmlLineNumberParser.parseXml(new ByteArrayInputStream(xml.getBytes()), null, "camelContext,routeContext,routes", "http://camel.apache.org/schema/spring");
        }
        catch (Exception e) {
            ++this.failed;
            this.log.warn("Cannot load the resource {} as XML", (Object)name);
            return;
        }
        ResourceState state = ObjectHelper.cast(ResourceState.class, this.cache.get(name));
        if (state == null) {
            state = new ResourceState(name, dom, xml);
            this.cache.put(name, state);
        }
        String oldXml = state.getXml();
        List<Integer> changed = StringHelper.changedLines(oldXml, xml);
        NodeList list = dom.getElementsByTagName("route");
        ArrayList<RouteDefinition> routes = new ArrayList<RouteDefinition>();
        if (list != null && list.getLength() > 0) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String lineNumber = (String)node.getUserData("lineNumber");
                String lineNumberEnd = (String)node.getUserData("lineNumberEnd");
                if (lineNumber != null && lineNumberEnd != null && !changed.isEmpty()) {
                    int end;
                    int start = Integer.valueOf(lineNumber);
                    boolean within = this.withinChanged(start, end = Integer.valueOf(lineNumberEnd).intValue(), changed);
                    if (within) {
                        this.log.debug("Updating route in lines: {}-{}", (Object)start, (Object)end);
                    } else {
                        this.log.debug("No changes to route in lines: {}-{}", (Object)start, (Object)end);
                        continue;
                    }
                }
                try {
                    RoutesDefinition loaded = ModelHelper.loadRoutesDefinition(camelContext, node);
                    if (loaded.getRoutes().isEmpty()) continue;
                    routes.addAll(loaded.getRoutes());
                    continue;
                }
                catch (Exception e) {
                    ++this.failed;
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
            }
        }
        if (!routes.isEmpty()) {
            try {
                boolean unassignedRouteIds = false;
                CollectionStringBuffer csb = new CollectionStringBuffer(",");
                for (RouteDefinition route : routes) {
                    unassignedRouteIds |= !route.hasCustomIdAssigned();
                    String id = route.idOrCreate(camelContext.getNodeIdFactory());
                    csb.append(id);
                }
                this.log.debug("Reloading routes: [{}] from XML resource: {}", (Object)csb, (Object)name);
                if (unassignedRouteIds) {
                    this.log.warn("Routes with no id's detected. Its recommended to assign id's to your routes so Camel can reload the routes correctly.");
                }
                camelContext.addRouteDefinitions(routes);
                this.log.info("Reloaded routes: [{}] from XML resource: {}", (Object)csb, (Object)name);
            }
            catch (Exception e) {
                ++this.failed;
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        state = new ResourceState(name, dom, xml);
        this.cache.put(name, state);
        ++this.succeeded;
    }

    private boolean withinChanged(int start, int end, List<Integer> changed) {
        for (int change : changed) {
            this.log.trace("Changed line: {} within {}-{}", new Object[]{change, start, end});
            if (change < start || change > end) continue;
            return true;
        }
        return false;
    }

    @Override
    @ManagedAttribute(description="Number of reloads succeeded")
    public int getReloadCounter() {
        return this.succeeded;
    }

    @Override
    @ManagedAttribute(description="Number of reloads failed")
    public int getFailedCounter() {
        return this.failed;
    }

    public void setSucceeded(int succeeded) {
        this.succeeded = succeeded;
    }

    public void setFailed(int failed) {
        this.failed = failed;
    }

    @Override
    @ManagedOperation(description="Reset counters")
    public void resetCounters() {
        this.succeeded = 0;
        this.failed = 0;
    }

    @Override
    protected void doStart() throws Exception {
        this.cache = LRUCacheFactory.newLRUCache(100);
    }

    @Override
    protected void doStop() throws Exception {
        this.cache.clear();
    }

    private static final class ResourceState {
        private final String name;
        private final Document dom;
        private final String xml;

        ResourceState(String name, Document dom, String xml) {
            this.name = name;
            this.dom = dom;
            this.xml = xml;
        }

        public String getName() {
            return this.name;
        }

        public Document getDom() {
            return this.dom;
        }

        public String getXml() {
            return this.xml;
        }
    }
}

