/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.pmp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.tigris.mtoolkit.iagent.internal.pmp.Connection;
import org.tigris.mtoolkit.iagent.internal.pmp.InvocationThread;
import org.tigris.mtoolkit.iagent.internal.pmp.ObjectInfo;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPAnswer;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPData;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPInputStream;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPOutputStream;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPPeerImpl;
import org.tigris.mtoolkit.iagent.internal.pmp.RemoteMethodImpl;
import org.tigris.mtoolkit.iagent.internal.utils.DebugUtils;
import org.tigris.mtoolkit.iagent.internal.utils.ThreadPool;
import org.tigris.mtoolkit.iagent.transport.TransportConnection;

public class PMPSessionThread
extends Thread {
    protected PMPOutputStream os;
    protected PMPInputStream is;
    protected String url;
    protected boolean running;
    private Connection connection;
    private Socket socket;
    private TransportConnection transportConnection;
    boolean connected = false;
    private short msgID;
    private int opID;
    private PMPAnswer answer;
    protected int maxS = -1;
    protected int maxA = -1;
    protected PMPPeerImpl peer;
    protected String sessionID;
    private Vector eventTypes;
    private static int objID = 1;
    private Map objects;
    protected static final int PING_REQ_OP = 0;
    protected static final byte[] PING = new byte[1];
    protected static final int PING_REPLY_OP = 144;
    protected static final byte[] PING_REPLY = new byte[]{-112};
    protected static final int CONNECT_REPLY_OP = 1;
    protected static final byte[] CONNECT_REPLY = new byte[]{1};
    protected static final int REFERENCE_REPLY_OP = 2;
    protected static final byte[] REFERENCE = new byte[]{2};
    protected static final int SERIALIZED_OBJ_REPLY_OP = 4;
    protected static final byte[] SERIALIZED = new byte[]{4};
    protected static final int EVENT_LISTENER_REPLY_OP = 8;
    protected static final byte[] EV_REPLY = new byte[]{8};
    protected static final int EVENT_LISTENER_FAILED_REPLY_OP = 24;
    protected static final byte[] EV_FAILED = new byte[]{24};
    protected static final int NEW_EVENT_REQ_OP = 16;
    protected static final byte[] EVENT = new byte[]{16};
    protected static final int GET_METHODS_REPLY_OP = 32;
    protected static final byte[] METHODS = new byte[]{32};
    protected static final int GET_METHOD_REPLY_OP = 96;
    protected static final byte[] METHOD = new byte[]{96};
    protected static final int DISCONNECT_REQ_OP = 64;
    protected static final byte[] DISCONNECT = new byte[]{64};
    protected static final int CONNECT_REQ_OP = 129;
    protected static final byte[] CONNECT = new byte[]{-127};
    protected static final int GET_REFERENCE_REQ_OP = 130;
    protected static final byte[] GET_REF = new byte[]{-126};
    protected static final int GET_REFERENCE_BY_ID_REQ_OP = 134;
    protected static final byte[] GET_REF_BY_ID = new byte[]{-122};
    protected static final int INVOKE_METHOD_REQ_OP = 132;
    protected static final byte[] INVOKE = new byte[]{-124};
    protected static final int INVOKE_METHOD_WITH_REFS_REQ_OP = 140;
    protected static final byte[] INVOKE_R = new byte[]{-116};
    protected static final int ADD_LISTENER_REQ_OP = 136;
    protected static final byte[] ADD_LS = new byte[]{-120};
    protected static final int REMOVE_LISTENER_REQ_OP = 152;
    protected static final byte[] REMOVE_LS = new byte[]{-104};
    protected static final int GET_METHOD_REQ_OP = 160;
    protected static final byte[] GET_METHOD = new byte[]{-96};
    protected static final int DISPOSE_REQ_OP = 192;
    protected static final byte[] DISPOSE = new byte[]{-64};
    private static final String ERRMSG1 = "Protocol Error";
    protected static final String ERRMSG2 = "Write Error";
    private static final String ERRMSG3 = "Read Error";
    private static final String DSCMSG1 = "Normal Disconnect Received";
    private static final String DSCMSG2 = "Error Disconnect Received: ";
    protected ThreadPool pool;
    String uri;

    public PMPSessionThread(PMPPeerImpl peer, Socket socket, String sessionID, String host) throws IOException {
        super("PMP " + peer.getRole() + " Thread [" + host + "]");
        this.url = host;
        this.socket = socket;
        this.sessionID = sessionID;
        this.os = new PMPOutputStream(socket.getOutputStream(), this);
        this.is = new PMPInputStream(socket.getInputStream(), this);
        this.running = true;
        this.connection = new Connection(this.is, this.os, this);
        this.objects = new Hashtable();
        this.peer = peer;
        this.pool = peer.pool;
        this.maxS = peer.maxStringLength;
        this.maxA = peer.maxArrayLength;
        this.start();
    }

    public PMPSessionThread(PMPPeerImpl peer, TransportConnection tc, String sessionID) throws IOException {
        super("PMP " + peer.getRole() + " Thread [" + tc + "]");
        this.transportConnection = tc;
        this.sessionID = sessionID;
        this.os = new PMPOutputStream(tc.getOutputStream(), this);
        this.is = new PMPInputStream(tc.getInputStream(), this);
        this.running = true;
        this.connection = new Connection(this.is, this.os, this);
        this.objects = new Hashtable();
        this.peer = peer;
        this.pool = peer.pool;
        this.maxS = peer.maxStringLength;
        this.maxA = peer.maxArrayLength;
        this.start();
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [7 : 665->669)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareAnswerReply() {
        Map map = this.os.answers;
        synchronized (map) {
            this.answer = (PMPAnswer)this.os.answers.remove(new Short(this.msgID));
        }
        if (this.answer == null) {
            this.debug("No Such Message ID " + this.msgID);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addRemoteObject(Object obj, Class[] interfaces, Object context) {
        Map map = this.objects;
        synchronized (map) {
            ObjectInfo info = new ObjectInfo(obj, interfaces, context);
            return this.addRemoteObject(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addRemoteObject(Object obj, Class[] interfaces) {
        Map map = this.objects;
        synchronized (map) {
            ObjectInfo info = new ObjectInfo(obj, interfaces);
            return this.addRemoteObject(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addRemoteObject(ObjectInfo info) {
        Map map = this.objects;
        synchronized (map) {
            do {
                if (++objID >= 0) continue;
                objID = 1;
            } while (this.objects.get(new Integer(objID)) != null);
            this.objects.put(new Integer(objID), info);
            return objID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect(String errMsg, boolean toAnswer) {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.interrupt();
        this.connection.disconnected(errMsg);
        this.peer.removeElement(this);
        this.debug("Disconnecting Client " + (this.url != null ? this.url : this.transportConnection.toString()));
        this.peer.fireConnectionEvent(false, this);
        if (toAnswer && this.connected) {
            try {
                this.os.begin((short)-1);
                this.os.write(DISCONNECT);
                PMPData.writeString(errMsg, this.os);
                this.os.end(false);
            }
            catch (Throwable exc) {
                this.debug("Can't Send Disconnect: " + exc.toString());
            }
        }
        try {
            this.os.close();
            this.is.close();
        }
        catch (Exception exc) {
            this.error("Close Error", exc);
        }
        if (toAnswer) {
            try {
                if (this.socket != null) {
                    this.socket.close();
                } else {
                    this.transportConnection.close();
                }
            }
            catch (Exception exception) {}
        }
        if (this.eventTypes != null) {
            this.peer.removeListeners(this.eventTypes, this);
        }
        Map map = this.objects;
        synchronized (map) {
            Iterator it = this.objects.keySet().iterator();
            while (it.hasNext()) {
                try {
                    ObjectInfo info = (ObjectInfo)it.next();
                    it.remove();
                    if (info == null) continue;
                    info.freeInfo();
                }
                catch (Exception exception) {}
            }
        }
        if (this.answer != null) {
            this.answer.errMsg = errMsg;
            this.answer.finish();
        }
        this.objects.clear();
    }

    private void connect() throws IOException {
        try {
            this.is.timeout = PMPData.readInt(this.is);
        }
        catch (Exception ioExc) {
            if (this.running) {
                this.os.begin(this.msgID);
                try {
                    this.os.write(CONNECT_REPLY);
                    this.os.write(1);
                    PMPData.writeString(ioExc.toString(), this.os);
                    this.os.end(false);
                }
                catch (Exception exc) {
                    this.error(ERRMSG2, exc);
                    this.os.unlock();
                }
            }
            if (ioExc instanceof IOException) {
                throw (IOException)ioExc;
            }
            throw new IOException(ioExc.getMessage());
        }
        try {
            this.os.begin(this.msgID);
            this.os.write(CONNECT_REPLY);
            this.os.write(0);
            this.os.end(false);
        }
        catch (Exception exc) {
            this.error(ERRMSG2, exc);
            this.os.unlock();
        }
        this.peer.fireConnectionEvent(true, this);
    }

    private void getReference(int opID) throws IOException {
        if (!this.connected) {
            this.disconnect("Handshake hasn't finished", true);
            return;
        }
        String clazz = null;
        String filter = null;
        long bid = 0L;
        try {
            clazz = PMPData.readString(this.is, this.maxS);
            filter = PMPData.readString(this.is, this.maxS);
            if (filter.length() == 0) {
                filter = null;
            }
            bid = opID == 6 ? PMPData.readLong(this.is) : 0L;
        }
        catch (IOException ioExc) {
            if (this.running) {
                this.writeRef(0, ioExc.toString());
            }
            throw ioExc;
        }
        this.debug("Getting Service " + clazz + " " + filter + (bid == 0L ? "" : " " + bid));
        String errMsg = null;
        int objID = 0;
        ObjectInfo newInfo = this.peer.getService(clazz, filter);
        if (newInfo != null) {
            objID = this.addRemoteObject(newInfo);
        } else {
            errMsg = "Requested service " + clazz + " [" + filter + "] is not available.";
        }
        this.writeRef(objID, errMsg);
    }

    private void writeRef(int objID, String errMsg) {
        try {
            this.os.begin(this.msgID);
            this.os.write(REFERENCE);
            PMPData.writeInt(objID, this.os);
            if (errMsg != null) {
                PMPData.writeString(errMsg, this.os);
            }
            this.os.end(false);
        }
        catch (Exception exc) {
            this.error(ERRMSG2, exc);
            this.os.unlock();
        }
    }

    private void invokeMethod() throws IOException {
        if (!this.connected) {
            this.disconnect("Handshake hasn't finished", true);
            return;
        }
        this.debug("Method Invocation Request ...");
        int objID = 0;
        int methodID = 0;
        try {
            objID = PMPData.readInt(this.is);
            methodID = PMPData.readInt(this.is);
        }
        catch (IOException ioExc) {
            if (this.running) {
                this.writeInvocationError(ioExc.toString(), this.msgID);
            }
            throw ioExc;
        }
        ObjectInfo info = (ObjectInfo)this.objects.get(new Integer(objID));
        if (info == null) {
            this.writeInvocationError("No Remote Object With ID: " + objID + " On Server", this.msgID);
            return;
        }
        Method m = null;
        if (methodID < 0 || methodID > info.methods.size()) {
            this.writeInvocationError("No Method With ID: " + methodID + " Associated With This Remote Object", this.msgID);
            return;
        }
        try {
            m = (Method)info.methods.elementAt(methodID - 1);
        }
        catch (Exception exception) {
            this.writeInvocationError("No Method With ID: " + methodID + " Associated With This Remote Object", this.msgID);
            return;
        }
        int ser = 0;
        try {
            ser = this.is.read();
        }
        catch (IOException ioExc) {
            if (this.running) {
                this.writeInvocationError(ioExc.toString(), this.msgID);
            }
            throw ioExc;
        }
        if (ser == -1) {
            this.writeInvocationError(ERRMSG3, this.msgID);
            throw new IOException(ERRMSG3);
        }
        boolean serflag = ser == 0;
        Class<?>[] argTypes = m.getParameterTypes();
        Object[] args = new Object[argTypes.length];
        try {
            boolean refs = this.opID == 12;
            int i = 0;
            while (i < args.length) {
                this.debug("Reading Argument " + i + " : ");
                boolean readReal = true;
                if (refs) {
                    boolean bl = readReal = this.is.read() == 1;
                }
                if (readReal) {
                    args[i] = PMPData.readObject(null, info.obj.getClass().getClassLoader(), this.is, new String(), this.maxA, -1, null);
                    if (i != args.length - 1 && args[i] instanceof InputStream) {
                        int read;
                        byte[] buf = new byte[256];
                        InputStream input = (InputStream)args[i];
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
                        while ((read = input.read(buf)) != -1) {
                            bos.write(buf, 0, read);
                        }
                        input.close();
                        args[i] = new ByteArrayInputStream(bos.toByteArray());
                    }
                } else {
                    int tempID = PMPData.readInt(this.is);
                    args[i] = ((ObjectInfo)this.objects.get((Object)new Integer((int)tempID))).obj;
                    if (args[i] == null) {
                        throw new IOException("No Remote Object With ID: " + tempID + " On Server");
                    }
                }
                this.debug("Argument " + i + " Is: " + args[i]);
                ++i;
            }
        }
        catch (Exception ioExc) {
            if (this.running) {
                this.writeInvocationError(ioExc.toString(), this.msgID);
            }
            throw new IOException(ioExc.getMessage());
        }
        new InvocationThread(this, m, info.obj, serflag, info.context, args, this.msgID);
    }

    protected void writeInvocationError(String errMsg, short msgId) {
        this.error(errMsg, null);
        try {
            this.os.begin(msgId);
            this.os.write(SERIALIZED);
            this.os.write(0);
            PMPData.writeString(errMsg, this.os);
            this.os.end(false);
        }
        catch (Exception exc) {
            this.error(ERRMSG2, exc);
            this.os.unlock();
        }
    }

    private void getMethod() throws IOException {
        if (!this.connected) {
            this.disconnect("Handshake hasn't finished", true);
            return;
        }
        int objID = -1;
        String methodName = null;
        this.debug("Get Method Request ...");
        try {
            objID = PMPData.readInt(this.is);
            this.debug("Requested Object ID: " + objID);
            methodName = PMPData.readString(this.is, this.maxS);
        }
        catch (IOException ioExc) {
            if (this.running) {
                this.writeGetMethodError(ioExc.toString());
            }
            throw ioExc;
        }
        boolean all = methodName.equals("");
        this.debug(all ? "All Methods Requested" : "Requested Method Name: " + methodName);
        ObjectInfo info = (ObjectInfo)this.objects.get(new Integer(objID));
        if (info == null) {
            this.writeGetMethodError("No Remote Object With ID: " + objID + " On Server");
        } else if (all) {
            Vector methods = info.getMethods();
            int size = methods.size();
            this.os.begin(this.msgID);
            try {
                this.os.write(METHODS);
                PMPData.writeInt(size, this.os);
                int i = 0;
                while (i < size) {
                    Method method = (Method)methods.elementAt(i);
                    PMPData.writeString(method.getName(), this.os);
                    PMPData.writeString(method.getReturnType().getName(), this.os);
                    Class<?>[] argTypes = method.getParameterTypes();
                    PMPData.writeInt(argTypes.length, this.os);
                    int j = 0;
                    while (j < argTypes.length) {
                        PMPData.writeString(argTypes[j].getName(), this.os);
                        ++j;
                    }
                    ++i;
                }
                this.os.end(false);
            }
            catch (Exception exc) {
                this.error(ERRMSG2, exc);
                this.os.unlock();
            }
        } else {
            int length = 0;
            String[] argTypes = null;
            try {
                length = PMPData.readInt(this.is);
                argTypes = new String[length];
                int i = 0;
                while (i < length) {
                    argTypes[i] = PMPData.readString(this.is, this.maxS);
                    ++i;
                }
            }
            catch (IOException ioExc) {
                if (this.running) {
                    this.writeGetMethodError(ioExc.toString());
                }
                throw ioExc;
            }
            Method[] methods = new Method[1];
            int methodID = 0;
            try {
                methodID = info.getMethod(methodName, argTypes, methods);
            }
            catch (Exception exc) {
                this.writeGetMethodError("Error Getting Method Of " + info.obj + " : " + exc.toString());
                return;
            }
            this.os.begin(this.msgID);
            try {
                this.os.write(METHOD);
                this.debug("Remote Method ID: " + methodID);
                PMPData.writeInt(1, this.os);
                PMPData.writeInt(methodID, this.os);
                this.debug("Method To Return: " + methods[0]);
                PMPData.writeString(methods[0].getReturnType().getName(), this.os);
                this.os.end(false);
            }
            catch (Exception exc) {
                this.error(ERRMSG2, exc);
                this.os.unlock();
            }
        }
    }

    private void writeGetMethodError(String errMsg) {
        this.error(errMsg, null);
        try {
            this.os.begin(this.msgID);
            this.os.write(METHOD);
            PMPData.writeInt(1, this.os);
            PMPData.writeInt(0, this.os);
            PMPData.writeString(errMsg, this.os);
            this.os.end(false);
        }
        catch (Exception exc) {
            this.error(ERRMSG1, exc);
            this.os.unlock();
        }
    }

    private void remoteListener(int opID) throws IOException {
        String evType;
        if (!this.connected) {
            this.disconnect("Handshake hasn't finished", true);
            return;
        }
        if ((opID & 0x10) != 0) {
            evType = PMPData.readString(this.is, this.maxS);
            byte res = this.peer.removeListener(evType, this);
            if (res == 2) {
                this.eventTypes.removeElement(evType);
            }
        } else {
            evType = null;
            try {
                evType = PMPData.readString(this.is, this.maxS);
            }
            catch (Exception exc) {
                this.writeEventFailed(exc.toString());
                return;
            }
            byte res = this.peer.addListener(evType, this);
            if (res == 2) {
                if (this.eventTypes == null) {
                    this.eventTypes = new Vector();
                }
                this.eventTypes.addElement(evType);
            }
        }
        this.os.begin(this.msgID);
        try {
            this.os.write(EV_REPLY);
            this.os.end(false);
        }
        catch (Exception exc) {
            this.error(ERRMSG1, exc);
            this.os.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose() {
        int objID;
        if (!this.connected) {
            this.disconnect("Handshake hasn't finished", true);
            return;
        }
        try {
            objID = PMPData.readInt(this.is);
        }
        catch (IOException exc) {
            this.error(ERRMSG3, exc);
            return;
        }
        this.debug("Disposing objID " + objID);
        Map map = this.objects;
        synchronized (map) {
            ObjectInfo info = (ObjectInfo)this.objects.remove(new Integer(objID));
            if (info != null) {
                info.freeInfo();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(Object context) {
        Map map = this.objects;
        synchronized (map) {
            Iterator it = this.objects.values().iterator();
            while (it.hasNext()) {
                ObjectInfo info = (ObjectInfo)it.next();
                if (info == null || !context.equals(info.context)) continue;
                it.remove();
                this.peer.ungetService(info);
                info.freeInfo();
            }
        }
    }

    protected void event(Object ev, String eventType) {
        try {
            this.os.begin((short)-1);
            this.os.write(EVENT);
            PMPData.writeString(eventType, this.os);
            PMPData.writeObject(ev, this.os, true);
            this.os.end(false);
        }
        catch (Exception exception) {
            this.os.unlock();
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void postEvent(Object event, String eventType) {
        this.event(event, eventType);
    }

    private void writeEventFailed(String errMsg) {
        this.error(errMsg, null);
        try {
            this.os.begin(this.msgID);
            this.os.write(EV_FAILED);
            PMPData.writeString(errMsg, this.os);
            this.os.end(false);
        }
        catch (Exception exc) {
            this.error(ERRMSG1, exc);
            this.os.unlock();
        }
    }

    protected final void debug(String msg) {
        DebugUtils.debug(this, msg);
    }

    protected final void error(String msg, Throwable exc) {
        DebugUtils.error(this, msg, exc);
    }

    protected final void info(String msg) {
        DebugUtils.info(this, msg);
    }

    protected void ping_repl() {
        try {
            this.os.begin(null);
            this.os.write(PING_REPLY);
            this.os.end(true);
        }
        catch (Exception exception) {
            this.os.unlock();
        }
    }

    protected void ping() {
        try {
            this.os.begin((short)-1);
            this.os.write(PING);
            this.os.end(false);
        }
        catch (Exception exception) {
            this.os.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectReplay() {
        this.debug("answer " + this.answer);
        if (!this.prepareAnswerReply()) {
            return;
        }
        int success = 1;
        try {
            success = this.is.read();
            if (success == -1) {
                this.answer.errMsg = ERRMSG3;
            } else if (success == 1) {
                this.answer.errMsg = PMPData.readString(this.is, this.maxS);
                if (this.answer.errMsg == null) {
                    this.answer.errMsg = ERRMSG3;
                }
            }
        }
        catch (IOException ioExc) {
            this.answer.errMsg = ioExc.toString();
        }
        PMPAnswer pMPAnswer = this.answer;
        synchronized (pMPAnswer) {
            this.answer.received = true;
            if (success == 0) {
                this.answer.connected = true;
                this.connected = true;
                this.peer.fireConnectionEvent(true, this);
            }
            if (this.answer.waiting) {
                this.answer.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readReference() {
        if (!this.connected) {
            this.disconnect("Handshake hasn't finished", true);
            return;
        }
        if (!this.prepareAnswerReply()) {
            return;
        }
        try {
            this.answer.objID = PMPData.readInt(this.is);
            if (this.answer.objID == 0) {
                this.answer.errMsg = PMPData.readString(this.is, this.maxS);
            }
        }
        catch (Exception exc) {
            this.answer.errMsg = exc.toString();
        }
        this.debug("objID: " + this.answer.objID);
        PMPAnswer pMPAnswer = this.answer;
        synchronized (pMPAnswer) {
            this.answer.received = true;
            if (this.answer.waiting) {
                this.answer.notify();
            }
        }
    }

    private void getObject() {
        if (!this.connected) {
            this.disconnect("Handshake hasn't finished", true);
            return;
        }
        if (!this.prepareAnswerReply()) {
            return;
        }
        try {
            this.debug("method result");
            int type = this.is.read();
            this.debug("type: " + type);
            if (type == -1) {
                this.answer.errMsg = ERRMSG3;
            } else if (type == 0) {
                this.answer.errMsg = PMPData.readString(this.is, this.maxS);
                if (this.answer.errMsg == null) {
                    this.answer.errMsg = ERRMSG3;
                }
            } else if (type == 1) {
                this.debug("return expected: " + this.answer.expectsReturn);
                if (this.answer.expectsReturn) {
                    try {
                        this.answer.obj = PMPData.readObject(null, this.answer.loader, this.is, this.answer.returnType, this.maxA, -1, null);
                    }
                    catch (Exception exc) {
                        this.answer.errMsg = exc.toString();
                    }
                }
            }
        }
        catch (Exception ioExc) {
            this.answer.errMsg = ioExc.toString();
        }
        this.answer.finish();
    }

    private void readMethods(int opID) {
        block12: {
            if (!this.connected) {
                this.disconnect("Handshake hasn't finished", true);
                return;
            }
            if (!this.prepareAnswerReply()) {
                return;
            }
            try {
                this.debug("get methods ...");
                int length = PMPData.readInt(this.is);
                this.debug("methods l " + length);
                if (length == 1) {
                    if ((opID & 0x40) != 0) {
                        this.debug("method id ");
                        this.answer.methodID = PMPData.readInt(this.is);
                        this.debug(" " + this.answer.methodID);
                        this.debug("return type ");
                        this.answer.returnType = PMPData.readString(this.is, this.maxS);
                        this.debug(this.answer.returnType);
                        if (this.answer.returnType == null) {
                            this.answer.errMsg = ERRMSG3;
                        } else if (this.answer.methodID <= 0) {
                            this.answer.errMsg = this.answer.returnType;
                        }
                    } else {
                        this.answer.methods = new RemoteMethodImpl[1];
                        this.answer.errMsg = this.readMethod(this.answer.methods, 0);
                    }
                    break block12;
                }
                this.answer.methods = new RemoteMethodImpl[length];
                int i = 0;
                while (i < length) {
                    this.answer.errMsg = this.readMethod(this.answer.methods, i);
                    if (this.answer.errMsg == null) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ioExc) {
                this.answer.errMsg = ioExc.toString();
            }
        }
        this.answer.finish();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readMethod(RemoteMethodImpl[] methods, int pos) {
        try {
            String name = PMPData.readString(this.is, this.maxS);
            if (name == null) {
                return ERRMSG3;
            }
            String returnType = PMPData.readString(this.is, this.maxS);
            if (returnType == null) {
                return ERRMSG3;
            }
            int params = PMPData.readInt(this.is);
            String[] argTypes = new String[params];
            int i = 0;
            while (true) {
                if (i >= params) {
                    methods[pos] = new RemoteMethodImpl(name, returnType, argTypes, this.answer.connection, pos + 1, this.answer.requestingRObj);
                    return null;
                }
                argTypes[i] = PMPData.readString(this.is, this.maxS);
                if (argTypes[i] == null) {
                    return ERRMSG3;
                }
                ++i;
            }
        }
        catch (IOException ioExc) {
            return ioExc.toString();
        }
    }

    private void eventReply(int opID) throws Exception {
        if (!this.connected) {
            this.disconnect("Handshake hasn't finished", true);
            return;
        }
        if (!this.prepareAnswerReply()) {
            return;
        }
        try {
            if ((opID & 0x10) != 0) {
                this.answer.errMsg = PMPData.readString(this.is, this.maxS);
                if (this.answer.errMsg == null) {
                    this.answer.errMsg = ERRMSG3;
                }
                this.answer.success = false;
            } else {
                this.answer.success = true;
            }
        }
        catch (IOException ioExc) {
            this.answer.errMsg = ioExc.toString();
        }
        this.answer.finish();
    }

    private void readEvent(int opID) throws Exception {
        if (!this.connected) {
            this.disconnect("Handshake hasn't finished", true);
            return;
        }
        try {
            if (this.connection.evMngr != null) {
                String sEvType = PMPData.readString(this.is, this.maxS);
                this.debug(sEvType);
                ClassLoader loader = this.connection.evMngr.getClassLoader(sEvType);
                Object event = PMPData.readObject(null, loader, this.is, new String(), this.maxA, -1, null);
                this.connection.evMngr.postEvent(sEvType, event);
            }
        }
        catch (IOException ioExc) {
            this.error("error receiving event", ioExc);
        }
    }
}

