/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.message.impl.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTConnection;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTConnectionManager;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTLogger;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTProtocolHandler;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTProtocolManager;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTPublishManager;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTRetainMessageManager;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSessionCallback;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSessionState;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSubscriptionManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;

public class MQTTSession {
    static Map<String, MQTTSessionState> SESSIONS = new ConcurrentHashMap<String, MQTTSessionState>();
    private final String id = UUID.randomUUID().toString();
    private MQTTProtocolHandler protocolHandler;
    private MQTTSubscriptionManager subscriptionManager;
    private MQTTSessionCallback sessionCallback;
    private ServerSessionImpl serverSession;
    private MQTTPublishManager mqttPublishManager;
    private MQTTConnectionManager mqttConnectionManager;
    private MQTTRetainMessageManager retainMessageManager;
    private MQTTConnection connection;
    protected MQTTSessionState state;
    private boolean stopped = false;
    private MQTTLogger log = MQTTLogger.LOGGER;
    private MQTTProtocolManager protocolManager;
    private boolean isClean;
    private WildcardConfiguration wildcardConfiguration;
    private CoreMessageObjectPools coreMessageObjectPools = new CoreMessageObjectPools();

    public MQTTSession(MQTTProtocolHandler protocolHandler, MQTTConnection connection, MQTTProtocolManager protocolManager, WildcardConfiguration wildcardConfiguration) throws Exception {
        this.protocolHandler = protocolHandler;
        this.protocolManager = protocolManager;
        this.wildcardConfiguration = wildcardConfiguration;
        this.connection = connection;
        this.mqttConnectionManager = new MQTTConnectionManager(this);
        this.mqttPublishManager = new MQTTPublishManager(this);
        this.sessionCallback = new MQTTSessionCallback(this, connection);
        this.subscriptionManager = new MQTTSubscriptionManager(this);
        this.retainMessageManager = new MQTTRetainMessageManager(this);
        this.log.debug("SESSION CREATED: " + this.id);
    }

    synchronized void start() throws Exception {
        this.mqttPublishManager.start();
        this.subscriptionManager.start();
        this.stopped = false;
    }

    synchronized void stop() throws Exception {
        if (!this.stopped) {
            this.protocolHandler.stop();
            this.subscriptionManager.stop();
            this.mqttPublishManager.stop();
            if (this.serverSession != null) {
                this.serverSession.stop();
                this.serverSession.close(false);
            }
            if (this.state != null) {
                this.state.setAttached(false);
            }
            if (this.isClean()) {
                this.clean();
            }
        }
        this.stopped = true;
    }

    boolean getStopped() {
        return this.stopped;
    }

    boolean isClean() {
        return this.isClean;
    }

    void setIsClean(boolean isClean) throws Exception {
        this.isClean = isClean;
        if (isClean) {
            this.clean();
        }
    }

    MQTTPublishManager getMqttPublishManager() {
        return this.mqttPublishManager;
    }

    MQTTSessionState getState() {
        return this.state;
    }

    MQTTConnectionManager getConnectionManager() {
        return this.mqttConnectionManager;
    }

    MQTTSessionState getSessionState() {
        return this.state;
    }

    ServerSessionImpl getServerSession() {
        return this.serverSession;
    }

    ActiveMQServer getServer() {
        return this.protocolHandler.getServer();
    }

    MQTTSubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    MQTTProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    SessionCallback getSessionCallback() {
        return this.sessionCallback;
    }

    void setServerSession(ServerSessionImpl serverSession) {
        this.serverSession = serverSession;
    }

    void setSessionState(MQTTSessionState state) {
        this.state = state;
        state.setAttached(true);
    }

    MQTTRetainMessageManager getRetainMessageManager() {
        return this.retainMessageManager;
    }

    MQTTConnection getConnection() {
        return this.connection;
    }

    MQTTProtocolManager getProtocolManager() {
        return this.protocolManager;
    }

    void clean() throws Exception {
        this.subscriptionManager.clean();
        this.mqttPublishManager.clean();
        this.state.clear();
    }

    public WildcardConfiguration getWildcardConfiguration() {
        return this.wildcardConfiguration;
    }

    public void setWildcardConfiguration(WildcardConfiguration wildcardConfiguration) {
        this.wildcardConfiguration = wildcardConfiguration;
    }

    public CoreMessageObjectPools getCoreMessageObjectPools() {
        return this.coreMessageObjectPools;
    }
}

