/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.configuration;

import java.util.Map;
import org.eclipse.kura.configuration.metatype.Designate;
import org.eclipse.kura.configuration.metatype.OCD;
import org.eclipse.kura.core.configuration.ConfigurationServiceImpl;
import org.eclipse.kura.core.configuration.metatype.Tmetadata;
import org.eclipse.kura.core.configuration.metatype.Tocd;
import org.eclipse.kura.core.configuration.util.ComponentUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentMetaTypeBundleTracker
extends BundleTracker<Bundle> {
    private static final Logger s_logger = LoggerFactory.getLogger(ComponentMetaTypeBundleTracker.class);
    private final BundleContext m_context;
    private final ConfigurationServiceImpl m_configurationService;

    public ComponentMetaTypeBundleTracker(BundleContext context, ConfigurationServiceImpl configurationService) throws InvalidSyntaxException {
        super(context, 32, null);
        this.m_context = context;
        this.m_configurationService = configurationService;
    }

    public Bundle addingBundle(Bundle bundle, BundleEvent event) {
        Bundle bnd = (Bundle)super.addingBundle(bundle, event);
        s_logger.debug("addingBundle(): processing MetaType for bundle: {}...", (Object)bundle.getSymbolicName());
        this.processBundleMetaType(bundle);
        s_logger.debug("addingBundle(): processed MetaType for bundle: {}", (Object)bundle.getSymbolicName());
        return bnd;
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Bundle object) {
        super.removedBundle(bundle, event, (Object)object);
        this.m_configurationService.onBundleRemoved(bundle);
    }

    private void processBundleMetaType(Bundle bundle) {
        Map<String, Tmetadata> metas = ComponentUtil.getMetadata(this.m_context, bundle);
        for (String metatypePid : metas.keySet()) {
            try {
                Tmetadata metadata = metas.get(metatypePid);
                if (metadata == null) continue;
                boolean isFactory = false;
                Designate designate = ComponentUtil.getDesignate(metadata, metatypePid);
                if (designate.getFactoryPid() != null && !designate.getFactoryPid().isEmpty()) {
                    isFactory = true;
                    metatypePid = designate.getFactoryPid();
                }
                OCD ocd = ComponentUtil.getOCD(metadata, metatypePid);
                this.m_configurationService.registerComponentOCD(metatypePid, (Tocd)ocd, isFactory, bundle);
            }
            catch (Exception e) {
                s_logger.error("Error seeding configuration for pid: " + metatypePid, (Throwable)e);
            }
        }
    }
}

