/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.configuration.metatype.AD;
import org.eclipse.kura.configuration.metatype.Icon;
import org.eclipse.kura.configuration.metatype.OCD;
import org.eclipse.kura.configuration.metatype.Option;
import org.eclipse.kura.core.configuration.ComponentConfigurationImpl;
import org.eclipse.kura.core.configuration.metatype.Tad;
import org.eclipse.kura.core.configuration.metatype.Tocd;
import org.eclipse.kura.driver.descriptor.DriverDescriptor;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtConfigParameter;

public final class GwtServerUtil {
    public static final String PASSWORD_PLACEHOLDER = "Placeholder";
    public static final String PATTERN_CONFIGURATION_REQUIRE = "configuration-policy=\"require\"";
    public static final String PATTERN_SERVICE_PROVIDE_CONFIGURABLE_COMP = "provide interface=\"org.eclipse.kura.configuration.ConfigurableComponent\"";
    public static final String PATTERN_SERVICE_PROVIDE_EMITTER = "provide interface=\"org.eclipse.kura.wire.WireEmitter\"";
    public static final String PATTERN_SERVICE_PROVIDE_RECEIVER = "provide interface=\"org.eclipse.kura.wire.WireReceiver\"";
    public static final String PATTERN_SERVICE_PROVIDE_SELF_CONFIGURING_COMP = "provide interface=\"org.eclipse.kura.configuration.SelfConfiguringComponent\"";
    private static final String DRIVER_PID = "driver.pid";

    public static Object getObjectValue(GwtConfigParameter param) {
        Object objValue = null;
        GwtConfigParameter.GwtConfigParameterType gwtType = param.getType();
        String strValue = param.getValue();
        if (gwtType == GwtConfigParameter.GwtConfigParameterType.STRING) {
            objValue = strValue;
        } else if (strValue != null && !strValue.trim().isEmpty()) {
            switch (gwtType) {
                case LONG: {
                    objValue = Long.parseLong(strValue);
                    break;
                }
                case DOUBLE: {
                    objValue = Double.parseDouble(strValue);
                    break;
                }
                case FLOAT: {
                    objValue = Float.valueOf(Float.parseFloat(strValue));
                    break;
                }
                case INTEGER: {
                    objValue = Integer.parseInt(strValue);
                    break;
                }
                case SHORT: {
                    objValue = Short.parseShort(strValue);
                    break;
                }
                case BYTE: {
                    objValue = Byte.parseByte(strValue);
                    break;
                }
                case BOOLEAN: {
                    objValue = Boolean.parseBoolean(strValue);
                    break;
                }
                case PASSWORD: {
                    objValue = new Password(strValue);
                    break;
                }
                case CHAR: {
                    objValue = Character.valueOf(strValue.charAt(0));
                    break;
                }
            }
        }
        return objValue;
    }

    public static Object[] getObjectValues(GwtConfigParameter param, String[] defaultValues) {
        ArrayList<Object> values = new ArrayList<Object>();
        GwtConfigParameter.GwtConfigParameterType type = param.getType();
        switch (type) {
            case BOOLEAN: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    if (!value.trim().isEmpty()) {
                        values.add(Boolean.valueOf(value));
                    }
                    ++n2;
                }
                return values.toArray(new Boolean[0]);
            }
            case BYTE: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n3 = 0;
                while (n3 < n) {
                    String value = stringArray[n3];
                    if (!value.trim().isEmpty()) {
                        values.add(Byte.valueOf(value));
                    }
                    ++n3;
                }
                return values.toArray(new Byte[0]);
            }
            case CHAR: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n4 = 0;
                while (n4 < n) {
                    String value = stringArray[n4];
                    if (!value.trim().isEmpty()) {
                        values.add(new Character(value.charAt(0)));
                    }
                    ++n4;
                }
                return values.toArray(new Character[0]);
            }
            case DOUBLE: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n5 = 0;
                while (n5 < n) {
                    String value = stringArray[n5];
                    if (!value.trim().isEmpty()) {
                        values.add(Double.valueOf(value));
                    }
                    ++n5;
                }
                return values.toArray(new Double[0]);
            }
            case FLOAT: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n6 = 0;
                while (n6 < n) {
                    String value = stringArray[n6];
                    if (!value.trim().isEmpty()) {
                        values.add(Float.valueOf(value));
                    }
                    ++n6;
                }
                return values.toArray(new Float[0]);
            }
            case INTEGER: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n7 = 0;
                while (n7 < n) {
                    String value = stringArray[n7];
                    if (!value.trim().isEmpty()) {
                        values.add(Integer.valueOf(value));
                    }
                    ++n7;
                }
                return values.toArray(new Integer[0]);
            }
            case LONG: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n8 = 0;
                while (n8 < n) {
                    String value = stringArray[n8];
                    if (!value.trim().isEmpty()) {
                        values.add(Long.valueOf(value));
                    }
                    ++n8;
                }
                return values.toArray(new Long[0]);
            }
            case SHORT: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n9 = 0;
                while (n9 < n) {
                    String value = stringArray[n9];
                    if (!value.trim().isEmpty()) {
                        values.add(Short.valueOf(value));
                    }
                    ++n9;
                }
                return values.toArray(new Short[0]);
            }
            case PASSWORD: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n10 = 0;
                while (n10 < n) {
                    String value = stringArray[n10];
                    if (!value.trim().isEmpty()) {
                        values.add(new Password(value));
                    }
                    ++n10;
                }
                return values.toArray(new Password[0]);
            }
            case STRING: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n11 = 0;
                while (n11 < n) {
                    String value = stringArray[n11];
                    if (!value.trim().isEmpty()) {
                        values.add(value);
                    }
                    ++n11;
                }
                return values.toArray(new String[0]);
            }
        }
        return null;
    }

    public static Object getUserDefinedObject(GwtConfigParameter param, Object currentObjValue) {
        Object objValue;
        int cardinality = param.getCardinality();
        if (cardinality == 0 || cardinality == 1 || cardinality == -1) {
            String strValue = param.getValue();
            objValue = currentObjValue instanceof Password && PASSWORD_PLACEHOLDER.equals(strValue) ? currentObjValue : GwtServerUtil.getObjectValue(param);
        } else {
            String[] strValues = param.getValues();
            if (currentObjValue instanceof Password[]) {
                Password[] currentPasswordValue = (Password[])currentObjValue;
                int i = 0;
                while (i < strValues.length) {
                    if (PASSWORD_PLACEHOLDER.equals(strValues[i])) {
                        strValues[i] = new String(currentPasswordValue[i].getPassword());
                    }
                    ++i;
                }
            }
            objValue = GwtServerUtil.getObjectValues(param, strValues);
        }
        return objValue;
    }

    public static String stripPidPrefix(String pid) {
        if (pid == null) {
            return null;
        }
        int start = pid.lastIndexOf(46);
        if (start < 0) {
            return pid;
        }
        int begin = start + 1;
        if (begin < pid.length()) {
            return pid.substring(begin);
        }
        return pid;
    }

    private GwtServerUtil() {
    }

    public static Map<String, Object> fillPropertiesFromConfiguration(GwtConfigComponent config, ComponentConfiguration currentCC) {
        HashMap<String, Object> properties = new HashMap<String, Object>(config.getProperties());
        ComponentConfiguration backupCC = currentCC;
        if (backupCC == null) {
            for (GwtConfigParameter gwtConfigParam : config.getParameters()) {
                properties.put(gwtConfigParam.getId(), GwtServerUtil.getUserDefinedObject(gwtConfigParam, null));
            }
        } else {
            Map backupConfigProp = backupCC.getConfigurationProperties();
            for (GwtConfigParameter gwtConfigParam : config.getParameters()) {
                Map currentConfigProp = currentCC.getConfigurationProperties();
                properties.put(gwtConfigParam.getId(), GwtServerUtil.getUserDefinedObject(gwtConfigParam, currentConfigProp.get(gwtConfigParam.getName())));
            }
            if (backupConfigProp.get("kura.service.pid") != null) {
                properties.put("kura.service.pid", backupConfigProp.get("kura.service.pid"));
            }
        }
        String factoryPid = config.getFactoryId();
        if (factoryPid != null) {
            properties.put("service.factoryPid", factoryPid);
        }
        return properties;
    }

    private static List<GwtConfigParameter> getADProperties(ComponentConfiguration config) {
        ArrayList<GwtConfigParameter> gwtParams = new ArrayList<GwtConfigParameter>();
        OCD ocd = config.getDefinition();
        for (AD ad : ocd.getAD()) {
            GwtConfigParameter gwtParam = new GwtConfigParameter();
            gwtParam.setId(ad.getId());
            gwtParam.setName(ad.getName());
            gwtParam.setDescription(ad.getDescription());
            gwtParam.setType(GwtConfigParameter.GwtConfigParameterType.valueOf(ad.getType().name()));
            gwtParam.setRequired(ad.isRequired());
            gwtParam.setCardinality(ad.getCardinality());
            gwtParam.setDefault(ad.getDefault());
            if (ad.getOption() != null && !ad.getOption().isEmpty()) {
                HashMap<String, String> options = new HashMap<String, String>();
                for (Option option : ad.getOption()) {
                    options.put(option.getLabel(), option.getValue());
                }
                gwtParam.setOptions(options);
            }
            gwtParam.setMin(ad.getMin());
            gwtParam.setMax(ad.getMax());
            int cardinality = ad.getCardinality();
            Object value = null;
            if (config.getConfigurationProperties() != null) {
                value = config.getConfigurationProperties().get(ad.getId());
            }
            if (value != null) {
                if (cardinality == 0 || cardinality == 1 || cardinality == -1) {
                    if (gwtParam.getType().equals((Object)GwtConfigParameter.GwtConfigParameterType.PASSWORD)) {
                        gwtParam.setValue(PASSWORD_PLACEHOLDER);
                    } else {
                        gwtParam.setValue(String.valueOf(value));
                    }
                } else if (value instanceof Object[]) {
                    Object[] objValues = value;
                    ArrayList<String> strValues = new ArrayList<String>();
                    Object[] objectArray = objValues;
                    int n = objValues.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object v = objectArray[n2];
                        if (v != null) {
                            if (gwtParam.getType().equals((Object)GwtConfigParameter.GwtConfigParameterType.PASSWORD)) {
                                strValues.add(PASSWORD_PLACEHOLDER);
                            } else {
                                strValues.add(String.valueOf(v));
                            }
                        }
                        ++n2;
                    }
                    gwtParam.setValues(strValues.toArray(new String[0]));
                }
            }
            gwtParams.add(gwtParam);
        }
        return gwtParams;
    }

    public static GwtConfigComponent toGwtConfigComponent(ComponentConfiguration config) {
        GwtConfigComponent gwtConfig = null;
        OCD ocd = config.getDefinition();
        if (ocd != null) {
            gwtConfig = new GwtConfigComponent();
            gwtConfig.setComponentId(config.getPid());
            Map props = config.getConfigurationProperties();
            if (props != null && props.get(DRIVER_PID) != null) {
                gwtConfig.set(DRIVER_PID, props.get(DRIVER_PID));
            }
            if (props != null && props.get("service.factoryPid") != null) {
                gwtConfig.setFactoryComponent(true);
                gwtConfig.setFactoryPid(String.valueOf(props.get("service.factoryPid")));
            } else {
                gwtConfig.setFactoryComponent(false);
            }
            if (ocd.getName() != null) {
                gwtConfig.setComponentName(ocd.getName());
            }
            gwtConfig.setComponentDescription(ocd.getDescription());
            if (ocd.getIcon() != null && !ocd.getIcon().isEmpty()) {
                Icon icon = (Icon)ocd.getIcon().get(0);
                gwtConfig.setComponentIcon(icon.getResource());
            }
            if (gwtConfig.getComponentName() == null) {
                gwtConfig.setComponentName(GwtServerUtil.stripPidPrefix(config.getPid()));
            }
            ArrayList<GwtConfigParameter> gwtParams = new ArrayList<GwtConfigParameter>();
            gwtConfig.setParameters(gwtParams);
            List<GwtConfigParameter> metatypeProps = GwtServerUtil.getADProperties(config);
            gwtParams.addAll(metatypeProps);
        }
        return gwtConfig;
    }

    public static GwtConfigComponent toGwtConfigComponent(String pid, Object descriptor) {
        if (!(descriptor instanceof List)) {
            return null;
        }
        List ads = (List)descriptor;
        Tocd ocd = new Tocd();
        ocd.setId(pid);
        for (Object ad : ads) {
            if (!(ad instanceof Tad)) {
                return null;
            }
            ocd.addAD((Tad)ad);
        }
        return GwtServerUtil.toGwtConfigComponent((ComponentConfiguration)new ComponentConfigurationImpl(pid, ocd, null));
    }

    public static ComponentConfiguration fromGwtConfigComponent(GwtConfigComponent gwtCompConfig, ComponentConfiguration currentCC) {
        String factoryPid;
        if (currentCC == null) {
            ComponentConfigurationImpl result = new ComponentConfigurationImpl();
            result.setPid(gwtCompConfig.getComponentId());
            result.setProperties(GwtServerUtil.fillPropertiesFromConfiguration(gwtCompConfig, null));
            return result;
        }
        HashMap properties = new HashMap();
        Map currentConfigProp = currentCC.getConfigurationProperties();
        for (GwtConfigParameter gwtConfigParam : gwtCompConfig.getParameters()) {
            Object currentValue = currentConfigProp.get(gwtConfigParam.getId());
            boolean isReadOnly = gwtConfigParam.getMin() != null && gwtConfigParam.getMin().equals(gwtConfigParam.getMax());
            Object objValue = isReadOnly ? currentValue : GwtServerUtil.getUserDefinedObject(gwtConfigParam, currentValue);
            properties.put(gwtConfigParam.getId(), objValue);
        }
        if (currentConfigProp.get("kura.service.pid") != null) {
            properties.put("kura.service.pid", currentConfigProp.get("kura.service.pid"));
        }
        if ((factoryPid = gwtCompConfig.getFactoryId()) != null) {
            properties.put("service.factoryPid", factoryPid);
        }
        currentConfigProp.clear();
        currentConfigProp.putAll(properties);
        return currentCC;
    }

    public static GwtConfigComponent toGwtConfigComponent(DriverDescriptor descriptor) {
        Object channelDescriptor = descriptor.getChannelDescriptor();
        if (channelDescriptor == null) {
            return null;
        }
        return GwtServerUtil.toGwtConfigComponent(descriptor.getPid(), channelDescriptor);
    }
}

