/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.system.SystemService;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.server.util.KuraExceptionHandler;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtSnapshot;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtSnapshotService;

public class GwtSnapshotServiceImpl
extends OsgiRemoteServiceServlet
implements GwtSnapshotService {
    private static final long serialVersionUID = 8804372718146289179L;

    @Override
    public ArrayList<GwtSnapshot> findDeviceSnapshots(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ArrayList<GwtSnapshot> snapshots = new ArrayList<GwtSnapshot>();
        try {
            ServiceLocator locator = ServiceLocator.getInstance();
            ConfigurationService cs = locator.getService(ConfigurationService.class);
            Set snapshotIds = cs.getSnapshots();
            if (snapshotIds != null && snapshotIds != null && snapshotIds.size() > 0) {
                for (Long snapshotId : snapshotIds) {
                    GwtSnapshot snapshot = new GwtSnapshot();
                    snapshot.setCreatedOn(new Date(snapshotId));
                    snapshots.add(0, snapshot);
                }
            }
        }
        catch (Throwable t) {
            KuraExceptionHandler.handle(t);
        }
        return new ArrayList<GwtSnapshot>(snapshots);
    }

    @Override
    public void rollbackDeviceSnapshot(GwtXSRFToken xsrfToken, GwtSnapshot snapshot) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        try {
            ServiceLocator locator = ServiceLocator.getInstance();
            ConfigurationService cs = locator.getService(ConfigurationService.class);
            cs.rollback(snapshot.getSnapshotId());
            SystemService ss = locator.getService(SystemService.class);
            long delay = Long.parseLong(ss.getProperties().getProperty("console.updateConfigDelay", "5000"));
            if (delay > 0L) {
                Thread.sleep(delay);
            }
        }
        catch (Throwable t) {
            KuraExceptionHandler.handle(t);
        }
    }
}

