/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.cloudconnection;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import java.util.logging.Level;
import org.eclipse.kura.web.client.ui.AbstractServicesUi;
import org.eclipse.kura.web.client.ui.AlertDialog;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.client.util.request.RequestQueue;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtConfigParameter;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtComponentService;
import org.eclipse.kura.web.shared.service.GwtComponentServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.FieldSet;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.FormGroup;

public class CloudConnectionConfigurationUi
extends AbstractServicesUi {
    private static ServiceConfigurationUiUiBinder uiBinder = (ServiceConfigurationUiUiBinder)GWT.create(ServiceConfigurationUiUiBinder.class);
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    private final GwtComponentServiceAsync gwtComponentService = (GwtComponentServiceAsync)GWT.create(GwtComponentService.class);
    private boolean dirty;
    private boolean initialized;
    private GwtConfigComponent originalConfig;
    @UiField
    Button applyConnectionEdit;
    @UiField
    Button resetConnectionEdit;
    @UiField
    FieldSet connectionEditFields;
    @UiField
    Form connectionEditField;
    @UiField
    AlertDialog alertDialog;

    public CloudConnectionConfigurationUi(GwtConfigComponent addedItem) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.initialized = false;
        this.originalConfig = addedItem;
        this.restoreConfiguration(this.originalConfig);
        this.connectionEditFields.clear();
        this.applyConnectionEdit.setText(MSGS.apply());
        this.applyConnectionEdit.addClickHandler(e -> this.apply());
        this.resetConnectionEdit.setText(MSGS.reset());
        this.resetConnectionEdit.addClickHandler(e -> this.reset());
        this.setDirty(false);
        this.applyConnectionEdit.setEnabled(false);
        this.resetConnectionEdit.setEnabled(false);
    }

    @Override
    protected void setDirty(boolean flag) {
        this.dirty = flag;
        if (this.dirty && this.initialized) {
            this.applyConnectionEdit.setEnabled(true);
            this.resetConnectionEdit.setEnabled(true);
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    protected void reset() {
        if (this.isDirty()) {
            this.alertDialog.show(MSGS.deviceConfigDirty(), this::resetVisualization);
        }
    }

    @Override
    protected void renderForm() {
        this.connectionEditFields.clear();
        for (GwtConfigParameter param : this.configurableComponent.getParameters()) {
            if (param.getCardinality() == 0 || param.getCardinality() == 1 || param.getCardinality() == -1) {
                FormGroup formGroup = new FormGroup();
                this.renderConfigParameter(param, true, formGroup);
                continue;
            }
            this.renderMultiFieldConfigParameter(param);
        }
        this.initialized = true;
    }

    @Override
    protected void renderTextField(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        super.renderTextField(param, isFirstInstance, formGroup);
        this.connectionEditFields.add((Widget)formGroup);
    }

    @Override
    protected void renderPasswordField(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        super.renderPasswordField(param, isFirstInstance, formGroup);
        this.connectionEditFields.add((Widget)formGroup);
    }

    @Override
    protected void renderBooleanField(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        super.renderBooleanField(param, isFirstInstance, formGroup);
        this.connectionEditFields.add((Widget)formGroup);
    }

    @Override
    protected void renderChoiceField(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        super.renderChoiceField(param, isFirstInstance, formGroup);
        this.connectionEditFields.add((Widget)formGroup);
    }

    private void apply() {
        if (this.isValid()) {
            if (this.isDirty()) {
                this.alertDialog.show(MSGS.deviceConfigConfirmation(this.configurableComponent.getComponentName()), () -> {
                    try {
                        this.getUpdatedConfiguration();
                    }
                    catch (Exception ex) {
                        EntryClassUi.hideWaitModal();
                        FailureHandler.handle(ex);
                        return;
                    }
                    RequestQueue.submit(context -> this.gwtXSRFService.generateSecurityToken(context.callback(token -> this.gwtComponentService.updateComponentConfiguration((GwtXSRFToken)token, this.configurableComponent, context.callback(result -> {
                        logger.info(String.valueOf(MSGS.info()) + ": " + MSGS.deviceConfigApplied());
                        this.applyConnectionEdit.setEnabled(false);
                        this.resetConnectionEdit.setEnabled(false);
                        this.setDirty(false);
                        this.originalConfig = this.configurableComponent;
                        EntryClassUi.hideWaitModal();
                    })))));
                });
            }
        } else {
            errorLogger.log(Level.SEVERE, "Device configuration error!");
            this.alertDialog.show(MSGS.formWithErrorsOrIncomplete(), AlertDialog.Severity.ALERT, null);
        }
    }

    private GwtConfigComponent getUpdatedConfiguration() {
        for (Widget w : this.connectionEditFields) {
            if (!(w instanceof FormGroup)) continue;
            FormGroup fg = (FormGroup)w;
            this.fillUpdatedConfiguration(fg);
        }
        return this.configurableComponent;
    }

    protected void resetVisualization() {
        this.restoreConfiguration(this.originalConfig);
        this.renderForm();
        this.applyConnectionEdit.setEnabled(false);
        this.resetConnectionEdit.setEnabled(false);
        this.setDirty(false);
    }

    static interface ServiceConfigurationUiUiBinder
    extends UiBinder<Widget, CloudConnectionConfigurationUi> {
    }
}

