/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.january.dataset.DataEvent;
import org.eclipse.january.dataset.IDataListener;

public class DataListenerDelegate {
    private Set<IDataListener> listeners = Collections.newSetFromMap(new ConcurrentHashMap());

    public void addDataListener(IDataListener l) {
        this.listeners.add(l);
    }

    public void removeDataListener(IDataListener l) {
        this.listeners.remove(l);
    }

    public void fire(DataEvent evt) {
        for (IDataListener listener : this.listeners) {
            listener.dataChangePerformed(evt);
        }
    }

    public boolean hasDataListeners() {
        return this.listeners.size() > 0;
    }

    public void clear() {
        this.listeners.clear();
    }
}

